/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Category;
import jdk.jfr.Event;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.JVMSupport;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

public final class EventType {
    private final PlatformEventType platformEventType;
    private final List<String> UNCATEGORIZED = Collections.singletonList("Uncategorized");
    private Map<String, ValueDescriptor> cache;

    EventType(PlatformEventType platformEventType) {
        this.platformEventType = platformEventType;
    }

    public List<ValueDescriptor> getFields() {
        return this.platformEventType.getFields();
    }

    public ValueDescriptor getField(String name) {
        Objects.requireNonNull(name);
        if (this.cache == null) {
            List<ValueDescriptor> fields = this.getFields();
            LinkedHashMap<String, ValueDescriptor> newCache = new LinkedHashMap<String, ValueDescriptor>(fields.size());
            for (ValueDescriptor v : fields) {
                newCache.put(v.getName(), v);
            }
            this.cache = newCache;
        }
        return this.cache.get(name);
    }

    public String getName() {
        return this.platformEventType.getName();
    }

    public String getLabel() {
        return this.platformEventType.getLabel();
    }

    public long getId() {
        return this.platformEventType.getId();
    }

    public List<AnnotationElement> getAnnotationElements() {
        return this.platformEventType.getAnnotationElements();
    }

    public boolean isEnabled() {
        return this.platformEventType.isEnabled();
    }

    public String getDescription() {
        return this.platformEventType.getDescription();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return (A)((Annotation)this.platformEventType.getAnnotation(annotationClass));
    }

    public static EventType getEventType(Class<? extends Event> eventClass) {
        Objects.requireNonNull(eventClass);
        Utils.ensureValidEventSubclass(eventClass);
        JVMSupport.ensureWithInternalError();
        return MetadataRepository.getInstance().getEventType(eventClass);
    }

    public List<SettingDescriptor> getSettingDescriptors() {
        return Collections.unmodifiableList(this.platformEventType.getSettings());
    }

    public List<String> getCategoryNames() {
        Category c = (Category)this.platformEventType.getAnnotation(Category.class);
        if (c == null) {
            return this.UNCATEGORIZED;
        }
        return Collections.unmodifiableList(Arrays.asList(c.value()));
    }

    Type getType() {
        return this.platformEventType;
    }

    PlatformEventType getPlatformEventType() {
        return this.platformEventType;
    }
}

