/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.consumer.ConstantMap;
import jdk.jfr.consumer.EventParser;
import jdk.jfr.consumer.LongMap;
import jdk.jfr.consumer.ObjectFactory;
import jdk.jfr.consumer.Parser;
import jdk.jfr.consumer.ParserFactory;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.TimeConverter;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.consumer.ChunkHeader;
import jdk.jfr.internal.consumer.RecordingInput;

final class ChunkParser {
    private static final long CONSTANT_POOL_TYPE_ID = 1L;
    private final RecordingInput input;
    private final LongMap<Parser> parsers;
    private final ChunkHeader chunkHeader;
    private final long absoluteChunkEnd;
    private final MetadataDescriptor metadata;
    private final LongMap<Type> typeMap;
    private final TimeConverter timeConverter;

    public ChunkParser(RecordingInput input) throws IOException {
        this(new ChunkHeader(input));
    }

    private ChunkParser(ChunkHeader header) throws IOException {
        this.input = header.getInput();
        this.chunkHeader = header;
        this.metadata = header.readMetadata();
        this.absoluteChunkEnd = header.getEnd();
        this.timeConverter = new TimeConverter(this.chunkHeader, this.metadata.getGMTOffset());
        ParserFactory factory = new ParserFactory(this.metadata, this.timeConverter);
        LongMap<ConstantMap> constantPools = factory.getConstantPools();
        this.parsers = factory.getParsers();
        this.typeMap = factory.getTypeMap();
        this.fillConstantPools(this.parsers, constantPools);
        constantPools.forEach(ConstantMap::setIsResolving);
        constantPools.forEach(ConstantMap::resolve);
        constantPools.forEach(ConstantMap::setResolved);
        this.input.position(this.chunkHeader.getEventStart());
    }

    public RecordedEvent readEvent() throws IOException {
        while (this.input.position() < this.absoluteChunkEnd) {
            Parser ep;
            long pos = this.input.position();
            int size = this.input.readInt();
            if (size == 0) {
                throw new IOException("Event can't have zero size");
            }
            long typeId = this.input.readLong();
            if (typeId > 1L && (ep = this.parsers.get(typeId)) instanceof EventParser) {
                return (RecordedEvent)ep.parse(this.input);
            }
            this.input.position(pos + (long)size);
        }
        return null;
    }

    private void fillConstantPools(LongMap<Parser> typeParser, LongMap<ConstantMap> constantPools) throws IOException {
        long nextCP = this.chunkHeader.getAbsoluteChunkStart();
        long deltaToNext = this.chunkHeader.getConstantPoolPosition();
        while (deltaToNext != 0L) {
            this.input.position(nextCP += deltaToNext);
            long position = nextCP;
            int size = this.input.readInt();
            long typeId = this.input.readLong();
            if (typeId != 1L) {
                throw new IOException("Expected check point event (id = 1) at position " + nextCP + ", but found type id = " + typeId);
            }
            this.input.readLong();
            this.input.readLong();
            long delta = deltaToNext = this.input.readLong();
            boolean flush = this.input.readBoolean();
            int poolCount = this.input.readInt();
            Logger.log(LogTag.JFR_SYSTEM_PARSER, LogLevel.TRACE, () -> "New constant pool: startPosition=" + position + ", size=" + size + ", deltaToNext=" + delta + ", flush=" + flush + ", poolCount=" + poolCount);
            for (int i = 0; i < poolCount; ++i) {
                Parser parser;
                long id = this.input.readLong();
                ConstantMap pool = constantPools.get(id);
                Type type = this.typeMap.get(id);
                if (pool == null) {
                    Logger.log(LogTag.JFR_SYSTEM_PARSER, LogLevel.INFO, "Found constant pool(" + id + ") that is never used");
                    if (type == null) {
                        throw new IOException("Error parsing constant pool type " + this.getName(id) + " at position " + this.input.position() + " at check point between [" + nextCP + ", " + nextCP + size + "]");
                    }
                    pool = new ConstantMap(ObjectFactory.create(type, this.timeConverter), type.getName());
                    constantPools.put(type.getId(), pool);
                }
                if ((parser = typeParser.get(id)) == null) {
                    throw new IOException("Could not find constant pool type with id = " + id);
                }
                try {
                    int count = this.input.readInt();
                    Logger.log(LogTag.JFR_SYSTEM_PARSER, LogLevel.TRACE, () -> "Constant: " + this.getName(id) + "[" + count + "]");
                    for (int j = 0; j < count; ++j) {
                        long key = this.input.readLong();
                        Object value = parser.parse(this.input);
                        pool.put(key, value);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new IOException("Error parsing constant pool type " + this.getName(id) + " at position " + this.input.position() + " at check point between [" + nextCP + ", " + nextCP + size + "]", e);
                }
            }
            if (this.input.position() == nextCP + (long)size) continue;
            throw new IOException("Size of check point event doesn't match content");
        }
    }

    private String getName(long id) {
        Type type = this.typeMap.get(id);
        return type == null ? "unknown(" + id + ")" : type.getName();
    }

    public Collection<Type> getTypes() {
        return this.metadata.getTypes();
    }

    public List<EventType> getEventTypes() {
        return this.metadata.getEventTypes();
    }

    public boolean isLastChunk() {
        return this.chunkHeader.isLastChunk();
    }

    public ChunkParser nextChunkParser() throws IOException {
        return new ChunkParser(this.chunkHeader.nextHeader());
    }
}

