/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.jfr.AnnotationElement;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.consumer.RecordingInput;

final class MetadataReader {
    private final DataInput input;
    private final List<String> pool;
    private final MetadataDescriptor descriptor;
    private final Map<Long, Type> types = new HashMap<Long, Type>();

    public MetadataReader(DataInput input) throws IOException {
        this.input = input;
        int size = input.readInt();
        ((RecordingInput)input).require(size, "Metadata string pool size %d exceeds available data");
        this.pool = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            this.pool.add(input.readUTF());
        }
        this.descriptor = new MetadataDescriptor();
        MetadataDescriptor.Element root = this.createElement();
        MetadataDescriptor.Element metadata = root.elements("metadata").get(0);
        this.declareTypes(metadata);
        this.defineTypes(metadata);
        this.annotateTypes(metadata);
        this.buildEvenTypes();
        MetadataDescriptor.Element time = root.elements("region").get(0);
        this.descriptor.gmtOffset = time.attribute("gmtOffset", 1L);
        this.descriptor.locale = time.attribute("locale", "");
        this.descriptor.root = root;
        if (Logger.shouldLog(LogTag.JFR_SYSTEM_PARSER, LogLevel.TRACE)) {
            ArrayList<Type> ts = new ArrayList<Type>(this.types.values());
            Collections.sort(ts, (x, y) -> x.getName().compareTo(y.getName()));
            for (Type t : ts) {
                t.log("Found", LogTag.JFR_SYSTEM_PARSER, LogLevel.TRACE);
            }
        }
    }

    private String readString() throws IOException {
        return this.pool.get(this.readInt());
    }

    private int readInt() throws IOException {
        return this.input.readInt();
    }

    private MetadataDescriptor.Element createElement() throws IOException {
        String name = this.readString();
        MetadataDescriptor.Element e = new MetadataDescriptor.Element(name);
        int attributeCount = this.readInt();
        for (int i = 0; i < attributeCount; ++i) {
            e.addAttribute(this.readString(), this.readString());
        }
        int childrenCount = this.readInt();
        for (int i = 0; i < childrenCount; ++i) {
            e.add(this.createElement());
        }
        return e;
    }

    private void annotateTypes(MetadataDescriptor.Element metadata) throws IOException {
        for (MetadataDescriptor.Element typeElement : metadata.elements("class")) {
            ArrayList<AnnotationElement> annotations;
            Type type = this.getType("id", typeElement);
            ArrayList<AnnotationElement> aes = new ArrayList<AnnotationElement>();
            for (MetadataDescriptor.Element annotationElement : typeElement.elements("annotation")) {
                aes.add(this.makeAnnotation(annotationElement));
            }
            aes.trimToSize();
            type.setAnnotations(aes);
            int index = 0;
            if (type instanceof PlatformEventType) {
                List<SettingDescriptor> settings = ((PlatformEventType)type).getAllSettings();
                for (MetadataDescriptor.Element settingElement : typeElement.elements("setting")) {
                    annotations = new ArrayList<AnnotationElement>();
                    for (MetadataDescriptor.Element annotationElement : settingElement.elements("annotation")) {
                        annotations.add(this.makeAnnotation(annotationElement));
                    }
                    annotations.trimToSize();
                    PrivateAccess.getInstance().setAnnotations(settings.get(index), annotations);
                    ++index;
                }
            }
            index = 0;
            List<ValueDescriptor> fields = type.getFields();
            for (MetadataDescriptor.Element fieldElement : typeElement.elements("field")) {
                annotations = new ArrayList();
                for (MetadataDescriptor.Element annotationElement : fieldElement.elements("annotation")) {
                    annotations.add(this.makeAnnotation(annotationElement));
                }
                annotations.trimToSize();
                PrivateAccess.getInstance().setAnnotations(fields.get(index), annotations);
                ++index;
            }
        }
    }

    private AnnotationElement makeAnnotation(MetadataDescriptor.Element annotationElement) throws IOException {
        Type annotationType = this.getType("class", annotationElement);
        ArrayList<Object> values = new ArrayList<Object>();
        for (ValueDescriptor v : annotationType.getFields()) {
            if (v.isArray()) {
                String text;
                ArrayList<Object> list = new ArrayList<Object>();
                int index = 0;
                while ((text = annotationElement.attribute(v.getName() + "-" + index)) != null) {
                    list.add(this.objectify(v.getTypeName(), text));
                    ++index;
                }
                Object object = Utils.makePrimitiveArray(v.getTypeName(), list);
                if (object == null) {
                    throw new IOException("Unsupported type " + list + " in array");
                }
                values.add(object);
                continue;
            }
            String text = annotationElement.attribute(v.getName());
            values.add(this.objectify(v.getTypeName(), text));
        }
        return PrivateAccess.getInstance().newAnnotation(annotationType, values, false);
    }

    private Object objectify(String typeName, String text) throws IOException {
        try {
            switch (typeName) {
                case "int": {
                    return Integer.valueOf(text);
                }
                case "long": {
                    return Long.valueOf(text);
                }
                case "double": {
                    return Double.valueOf(text);
                }
                case "float": {
                    return Float.valueOf(text);
                }
                case "short": {
                    return Short.valueOf(text);
                }
                case "char": {
                    if (text.length() != 1) {
                        throw new IOException("Unexpected size of char");
                    }
                    return Character.valueOf(text.charAt(0));
                }
                case "byte": {
                    return Byte.valueOf(text);
                }
                case "boolean": {
                    return Boolean.valueOf(text);
                }
                case "java.lang.String": {
                    return text;
                }
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Could not parse text representation of " + typeName);
        }
        throw new IOException("Unsupported type for annotation " + typeName);
    }

    private Type getType(String attribute, MetadataDescriptor.Element element) {
        long id = element.longValue(attribute);
        Type type = this.types.get(id);
        if (type == null) {
            String name = element.attribute("type");
            throw new IllegalStateException("Type '" + id + "' is not defined for " + name);
        }
        return type;
    }

    private void buildEvenTypes() {
        for (Type type : this.descriptor.types) {
            if (!(type instanceof PlatformEventType)) continue;
            this.descriptor.eventTypes.add(PrivateAccess.getInstance().newEventType((PlatformEventType)type));
        }
    }

    private void defineTypes(MetadataDescriptor.Element metadata) {
        for (MetadataDescriptor.Element typeElement : metadata.elements("class")) {
            String name;
            long id = typeElement.attribute("id", -1L);
            Type t = this.types.get(id);
            for (MetadataDescriptor.Element fieldElement : typeElement.elements("setting")) {
                name = fieldElement.attribute("name");
                String defaultValue = fieldElement.attribute("name");
                Type settingType = this.getType("class", fieldElement);
                PlatformEventType eventType = (PlatformEventType)t;
                eventType.add(PrivateAccess.getInstance().newSettingDescriptor(settingType, name, defaultValue, new ArrayList<AnnotationElement>(2)));
            }
            for (MetadataDescriptor.Element fieldElement : typeElement.elements("field")) {
                name = fieldElement.attribute("name");
                Type fieldType = this.getType("class", fieldElement);
                long dimension = fieldElement.attribute("dimension", 0L);
                boolean constantPool = fieldElement.attribute("constantPool") != null;
                t.add(PrivateAccess.getInstance().newValueDescriptor(name, fieldType, new ArrayList<AnnotationElement>(), (int)dimension, constantPool, null));
            }
            t.trimFields();
        }
    }

    private void declareTypes(MetadataDescriptor.Element metadata) {
        for (MetadataDescriptor.Element typeElement : metadata.elements("class")) {
            String typeName = typeElement.attribute("name");
            String superType = typeElement.attribute("superType");
            boolean simpleType = typeElement.attribute("simpleType") != null;
            long id = typeElement.attribute("id", -1L);
            Type t = Type.SUPER_TYPE_EVENT.equals(superType) ? new PlatformEventType(typeName, id, false, false) : new Type(typeName, superType, id, false, simpleType);
            this.types.put(id, t);
            this.descriptor.types.add(t);
        }
    }

    public MetadataDescriptor getDescriptor() {
        return this.descriptor;
    }
}

