/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.dcmd;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Recording;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.dcmd.DCmdException;

abstract class AbstractDCmd {
    private final StringWriter result = new StringWriter();
    private final PrintWriter log = new PrintWriter(this.result);

    protected AbstractDCmd() {
    }

    protected final FlightRecorder getFlightRecorder() {
        return FlightRecorder.getFlightRecorder();
    }

    public final String getResult() {
        return this.result.toString();
    }

    public String getPid() {
        return JVM.getJVM().getPid();
    }

    protected final SecuritySupport.SafePath resolvePath(Recording recording, String filename) throws InvalidPathException {
        if (filename == null) {
            return this.makeGenerated(recording, Paths.get(".", new String[0]));
        }
        Path path = Paths.get(filename, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            return this.makeGenerated(recording, path);
        }
        return new SecuritySupport.SafePath(path.toAbsolutePath().normalize());
    }

    private SecuritySupport.SafePath makeGenerated(Recording recording, Path directory) {
        return new SecuritySupport.SafePath(directory.toAbsolutePath().resolve(Utils.makeFilename(recording)).normalize());
    }

    protected final Recording findRecording(String name) throws DCmdException {
        try {
            return this.findRecordingById(Integer.parseInt(name));
        }
        catch (NumberFormatException nfe) {
            return this.findRecordingByName(name);
        }
    }

    protected final void reportOperationComplete(String actionPrefix, String name, SecuritySupport.SafePath file) {
        this.print(actionPrefix);
        this.print(" recording");
        if (name != null) {
            this.print(" \"" + name + "\"");
        }
        if (file != null) {
            this.print(",");
            try {
                this.print(" ");
                long bytes = SecuritySupport.getFileSize(file);
                this.printBytes(bytes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.println(" written to:", new Object[0]);
            this.println();
            this.printPath(file);
        } else {
            this.println(".", new Object[0]);
        }
    }

    protected final List<Recording> getRecordings() {
        ArrayList<Recording> list = new ArrayList<Recording>(this.getFlightRecorder().getRecordings());
        Collections.sort(list, Comparator.comparing(Recording::getId));
        return list;
    }

    static String quoteIfNeeded(String text) {
        if (text.contains(" ")) {
            return "\\\"" + text + "\\\"";
        }
        return text;
    }

    protected final void println() {
        this.log.println();
    }

    protected final void print(String s) {
        this.log.print(s);
    }

    protected final void print(String s, Object ... args) {
        this.log.printf(s, args);
    }

    protected final void println(String s, Object ... args) {
        this.print(s, args);
        this.println();
    }

    protected final void printBytes(long bytes) {
        this.print(Utils.formatBytes(bytes));
    }

    protected final void printTimespan(Duration timespan, String separator) {
        this.print(Utils.formatTimespan(timespan, separator));
    }

    protected final void printPath(SecuritySupport.SafePath path) {
        if (path == null) {
            this.print("N/A");
            return;
        }
        try {
            this.printPath(SecuritySupport.getAbsolutePath(path).toPath());
        }
        catch (IOException ioe) {
            this.printPath(path.toPath());
        }
    }

    protected final void printPath(Path path) {
        try {
            this.println(path.toAbsolutePath().toString(), new Object[0]);
        }
        catch (SecurityException e) {
            this.println(path.toString(), new Object[0]);
        }
    }

    private Recording findRecordingById(int id) throws DCmdException {
        for (Recording r : this.getFlightRecorder().getRecordings()) {
            if (r.getId() != (long)id) continue;
            return r;
        }
        throw new DCmdException("Could not find %d.\n\nUse JFR.check without options to see list of all available recordings.", id);
    }

    private Recording findRecordingByName(String name) throws DCmdException {
        for (Recording recording : this.getFlightRecorder().getRecordings()) {
            if (!name.equals(recording.getName())) continue;
            return recording;
        }
        throw new DCmdException("Could not find %s.\n\nUse JFR.check without options to see list of all available recordings.", name);
    }
}

