/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import jdk.jfr.internal.tool.Assemble;
import jdk.jfr.internal.tool.Disassemble;
import jdk.jfr.internal.tool.Help;
import jdk.jfr.internal.tool.Metadata;
import jdk.jfr.internal.tool.Print;
import jdk.jfr.internal.tool.Summary;
import jdk.jfr.internal.tool.UserDataException;
import jdk.jfr.internal.tool.UserSyntaxException;
import jdk.jfr.internal.tool.Version;

abstract class Command {
    public static final String title = "Tool for working with Flight Recorder files (.jfr)";
    private static final Command HELP = new Help();
    private static final List<Command> COMMANDS = Command.createCommands();

    Command() {
    }

    private static List<Command> createCommands() {
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(new Print());
        commands.add(new Metadata());
        commands.add(new Summary());
        commands.add(new Assemble());
        commands.add(new Disassemble());
        commands.add(new Version());
        commands.add(HELP);
        return Collections.unmodifiableList(commands);
    }

    static void displayHelp() {
        System.out.println(title);
        System.out.println();
        Command.displayAvailableCommands(System.out);
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract void execute(Deque<String> var1) throws UserSyntaxException, UserDataException;

    protected String getTitle() {
        return this.getDescription();
    }

    static void displayAvailableCommands(PrintStream stream) {
        boolean first = true;
        for (Command c : COMMANDS) {
            if (!first) {
                System.out.println();
            }
            Command.displayCommand(stream, c);
            stream.println("     " + c.getDescription());
            first = false;
        }
    }

    protected static void displayCommand(PrintStream stream, Command c) {
        boolean firstSyntax = true;
        String alias = Command.buildAlias(c);
        String initial = " jfr " + c.getName();
        for (String syntaxLine : c.getOptionSyntax()) {
            if (firstSyntax) {
                if (syntaxLine.length() != 0) {
                    stream.println(initial + " " + syntaxLine + alias);
                } else {
                    stream.println(initial + alias);
                }
            } else {
                for (int i = 0; i < initial.length(); ++i) {
                    stream.print(" ");
                }
                stream.println(" " + syntaxLine);
            }
            firstSyntax = false;
        }
    }

    private static String buildAlias(Command c) {
        List<String> aliases = c.getAliases();
        if (aliases.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (aliases.size() == 1) {
            sb.append(" (alias ");
            sb.append(aliases.get(0));
            sb.append(")");
            return sb.toString();
        }
        sb.append(" (aliases ");
        for (int i = 0; i < aliases.size(); ++i) {
            sb.append(aliases.get(i));
            if (i >= aliases.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static List<Command> getCommands() {
        return COMMANDS;
    }

    public static Command valueOf(String commandName) {
        for (Command command : COMMANDS) {
            if (!command.getName().equals(commandName)) continue;
            return command;
        }
        return null;
    }

    public List<String> getOptionSyntax() {
        return Collections.singletonList("");
    }

    public void displayOptionUsage(PrintStream stream) {
    }

    protected boolean acceptOption(Deque<String> options, String expected) throws UserSyntaxException {
        if (expected.equals(options.peek())) {
            if (options.size() < 2) {
                throw new UserSyntaxException("missing value for " + options.peek());
            }
            options.remove();
            return true;
        }
        return false;
    }

    protected void warnForWildcardExpansion(String option, String filter) throws UserDataException {
        try {
            Path p;
            if (!filter.contains(File.pathSeparator) && !Files.exists(p = Paths.get(".", filter), new LinkOption[0])) {
                return;
            }
            throw new UserDataException("wildcards should be quoted, for example " + option + " \"Foo*\"");
        }
        catch (InvalidPathException invalidPathException) {
            return;
        }
    }

    protected boolean acceptFilterOption(Deque<String> options, String expected) throws UserSyntaxException {
        if (!this.acceptOption(options, expected)) {
            return false;
        }
        if (options.isEmpty()) {
            throw new UserSyntaxException("missing filter after " + expected);
        }
        String filter = options.peek();
        if (filter.startsWith("--")) {
            throw new UserSyntaxException("missing filter after " + expected);
        }
        return true;
    }

    protected final void ensureMaxArgumentCount(Deque<String> options, int maxCount) throws UserSyntaxException {
        if (options.size() > maxCount) {
            throw new UserSyntaxException("too many arguments");
        }
    }

    protected final void ensureMinArgumentCount(Deque<String> options, int minCount) throws UserSyntaxException {
        if (options.size() < minCount) {
            throw new UserSyntaxException("too few arguments");
        }
    }

    protected final Path getDirectory(String pathText) throws UserDataException {
        try {
            Path path = Paths.get(pathText, new String[0]).toAbsolutePath();
            if (!Files.exists(path, new LinkOption[0])) {
                throw new UserDataException("directory does not exist, " + pathText);
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new UserDataException("path must be directory, " + pathText);
            }
            return path;
        }
        catch (InvalidPathException ipe) {
            throw new UserDataException("invalid path '" + pathText + "'");
        }
    }

    protected final Path getJFRInputFile(Deque<String> options) throws UserSyntaxException, UserDataException {
        if (options.isEmpty()) {
            throw new UserSyntaxException("missing file");
        }
        String file = options.removeLast();
        if (file.startsWith("--")) {
            throw new UserSyntaxException("missing file");
        }
        try {
            Path path = Paths.get(file, new String[0]).toAbsolutePath();
            this.ensureAccess(path);
            this.ensureJFRFile(path);
            return path;
        }
        catch (IOError ioe) {
            throw new UserDataException("i/o error reading file '" + file + "', " + ioe.getMessage());
        }
        catch (InvalidPathException ipe) {
            throw new UserDataException("invalid path '" + file + "'");
        }
    }

    private void ensureAccess(Path path) throws UserDataException {
        try (RandomAccessFile rad = new RandomAccessFile(path.toFile(), "r");){
            if (rad.length() == 0L) {
                throw new UserDataException("file is empty '" + path + "'");
            }
            rad.read();
        }
        catch (FileNotFoundException e) {
            throw new UserDataException("could not open file " + e.getMessage());
        }
        catch (IOException e) {
            throw new UserDataException("i/o error reading file '" + path + "', " + e.getMessage());
        }
    }

    protected final void couldNotReadError(Path p, IOException e) throws UserDataException {
        throw new UserDataException("could not read recording at " + p.toAbsolutePath() + ". " + e.getMessage());
    }

    protected final Path ensureFileDoesNotExist(Path file) throws UserDataException {
        if (Files.exists(file, new LinkOption[0])) {
            throw new UserDataException("file '" + file + "' already exists");
        }
        return file;
    }

    protected final void ensureJFRFile(Path path) throws UserDataException {
        if (!path.toString().endsWith(".jfr")) {
            throw new UserDataException("filename must end with '.jfr'");
        }
    }

    protected void displayUsage(PrintStream stream) {
        Command.displayCommand(stream, this);
        stream.println();
        this.displayOptionUsage(stream);
    }

    protected final void println() {
        System.out.println();
    }

    protected final void print(String text) {
        System.out.print(text);
    }

    protected final void println(String text) {
        System.out.println(text);
    }

    protected final boolean matches(String command) {
        for (String s : this.getNames()) {
            if (!s.equals(command)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getAliases() {
        return Collections.emptyList();
    }

    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.getName());
        names.addAll(this.getAliases());
        return names;
    }
}

