/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.PrintWriter;

abstract class StructuredWriter {
    private static final String LINE_SEPARATOR = String.format("%n", new Object[0]);
    private final PrintWriter out;
    private final StringBuilder builder = new StringBuilder(4000);
    private char[] indentionArray = new char[0];
    private int indent = 0;
    private int column;
    private boolean first = true;

    StructuredWriter(PrintWriter p) {
        this.out = p;
    }

    protected final int getColumn() {
        return this.column;
    }

    public final void flush(boolean hard) {
        if (hard) {
            this.out.print(this.builder.toString());
            this.builder.setLength(0);
            return;
        }
        if (this.first || this.builder.length() > 100000) {
            this.out.print(this.builder.toString());
            this.builder.setLength(0);
            this.first = false;
        }
    }

    public final void printIndent() {
        this.builder.append(this.indentionArray, 0, this.indent);
        this.column += this.indent;
    }

    public final void println() {
        this.builder.append(LINE_SEPARATOR);
        this.column = 0;
    }

    public final void print(String ... texts) {
        for (String text : texts) {
            this.print(text);
        }
    }

    public final void printAsString(Object o) {
        this.print(String.valueOf(o));
    }

    public final void print(String text) {
        this.builder.append(text);
        this.column += text.length();
    }

    public final void print(char c) {
        this.builder.append(c);
        ++this.column;
    }

    public final void print(int value) {
        this.print(String.valueOf(value));
    }

    public final void indent() {
        this.indent += 2;
        this.updateIndent();
    }

    public final void retract() {
        this.indent -= 2;
        this.updateIndent();
    }

    public final void println(String text) {
        this.print(text);
        this.println();
    }

    private void updateIndent() {
        if (this.indent > this.indentionArray.length) {
            this.indentionArray = new char[this.indent];
            for (int i = 0; i < this.indentionArray.length; ++i) {
                this.indentionArray[i] = 32;
            }
        }
    }
}

