/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.util.Date;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5ProxyCredential;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KerberosSecrets;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

public class Krb5InitCredential
extends KerberosTicket
implements Krb5CredElement {
    private static final long serialVersionUID = 7723415700837898232L;
    private Krb5NameElement name;
    private Credentials krb5Credentials;
    public KerberosTicket proxyTicket;

    private Krb5InitCredential(Krb5NameElement name, byte[] asn1Encoding, KerberosPrincipal client, KerberosPrincipal clientAlias, KerberosPrincipal server, KerberosPrincipal serverAlias, byte[] sessionKey, int keyType, boolean[] flags, Date authTime, Date startTime, Date endTime, Date renewTill, InetAddress[] clientAddresses) throws GSSException {
        super(asn1Encoding, client, server, sessionKey, keyType, flags, authTime, startTime, endTime, renewTill, clientAddresses);
        KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketSetClientAlias(this, clientAlias);
        KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketSetServerAlias(this, serverAlias);
        this.name = name;
        try {
            this.krb5Credentials = new Credentials(asn1Encoding, client.getName(), clientAlias != null ? clientAlias.getName() : null, server.getName(), serverAlias != null ? serverAlias.getName() : null, sessionKey, keyType, flags, authTime, startTime, endTime, renewTill, clientAddresses);
        }
        catch (KrbException e) {
            throw new GSSException(13, -1, e.getMessage());
        }
        catch (IOException e) {
            throw new GSSException(13, -1, e.getMessage());
        }
    }

    private Krb5InitCredential(Krb5NameElement name, Credentials delegatedCred, byte[] asn1Encoding, KerberosPrincipal client, KerberosPrincipal clientAlias, KerberosPrincipal server, KerberosPrincipal serverAlias, byte[] sessionKey, int keyType, boolean[] flags, Date authTime, Date startTime, Date endTime, Date renewTill, InetAddress[] clientAddresses) throws GSSException {
        super(asn1Encoding, client, server, sessionKey, keyType, flags, authTime, startTime, endTime, renewTill, clientAddresses);
        KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketSetClientAlias(this, clientAlias);
        KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketSetServerAlias(this, serverAlias);
        this.name = name;
        this.krb5Credentials = delegatedCred;
    }

    static Krb5InitCredential getInstance(GSSCaller caller, Krb5NameElement name, int initLifetime) throws GSSException {
        KerberosTicket tgt = Krb5InitCredential.getTgt(caller, name, initLifetime);
        if (tgt == null) {
            throw new GSSException(13, -1, "Failed to find any Kerberos tgt");
        }
        if (name == null) {
            String fullName = tgt.getClient().getName();
            name = Krb5NameElement.getInstance(fullName, Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
        }
        KerberosPrincipal clientAlias = KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketGetClientAlias(tgt);
        KerberosPrincipal serverAlias = KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketGetServerAlias(tgt);
        Krb5InitCredential result = new Krb5InitCredential(name, tgt.getEncoded(), tgt.getClient(), clientAlias, tgt.getServer(), serverAlias, tgt.getSessionKey().getEncoded(), tgt.getSessionKeyType(), tgt.getFlags(), tgt.getAuthTime(), tgt.getStartTime(), tgt.getEndTime(), tgt.getRenewTill(), tgt.getClientAddresses());
        result.proxyTicket = KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketGetProxy(tgt);
        return result;
    }

    static Krb5InitCredential getInstance(Krb5NameElement name, Credentials delegatedCred) throws GSSException {
        EncryptionKey sessionKey = delegatedCred.getSessionKey();
        PrincipalName cPrinc = delegatedCred.getClient();
        PrincipalName cAPrinc = delegatedCred.getClientAlias();
        PrincipalName sPrinc = delegatedCred.getServer();
        PrincipalName sAPrinc = delegatedCred.getServerAlias();
        KerberosPrincipal client = null;
        KerberosPrincipal clientAlias = null;
        KerberosPrincipal server = null;
        KerberosPrincipal serverAlias = null;
        Krb5NameElement credName = null;
        if (cPrinc != null) {
            String fullName = cPrinc.getName();
            credName = Krb5NameElement.getInstance(fullName, Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
            client = new KerberosPrincipal(fullName);
        }
        if (cAPrinc != null) {
            clientAlias = new KerberosPrincipal(cAPrinc.getName());
        }
        if (sPrinc != null) {
            server = new KerberosPrincipal(sPrinc.getName(), 2);
        }
        if (sAPrinc != null) {
            serverAlias = new KerberosPrincipal(sAPrinc.getName());
        }
        return new Krb5InitCredential(credName, delegatedCred, delegatedCred.getEncoded(), client, clientAlias, server, serverAlias, sessionKey.getBytes(), sessionKey.getEType(), delegatedCred.getFlags(), delegatedCred.getAuthTime(), delegatedCred.getStartTime(), delegatedCred.getEndTime(), delegatedCred.getRenewTill(), delegatedCred.getClientAddresses());
    }

    @Override
    public final GSSNameSpi getName() throws GSSException {
        return this.name;
    }

    @Override
    public int getInitLifetime() throws GSSException {
        Date d = this.getEndTime();
        if (d == null) {
            return 0;
        }
        long retVal = d.getTime() - System.currentTimeMillis();
        return (int)(retVal / 1000L);
    }

    @Override
    public int getAcceptLifetime() throws GSSException {
        return 0;
    }

    @Override
    public boolean isInitiatorCredential() throws GSSException {
        return true;
    }

    @Override
    public boolean isAcceptorCredential() throws GSSException {
        return false;
    }

    @Override
    public final Oid getMechanism() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    @Override
    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    Credentials getKrb5Credentials() {
        return this.krb5Credentials;
    }

    @Override
    public void dispose() throws GSSException {
        try {
            this.destroy();
        }
        catch (DestroyFailedException e) {
            GSSException gssException = new GSSException(11, -1, "Could not destroy credentials - " + e.getMessage());
            gssException.initCause(e);
        }
    }

    private static KerberosTicket getTgt(GSSCaller caller, Krb5NameElement name, int initLifetime) throws GSSException {
        final String clientPrincipal = name != null ? name.getKrb5PrincipalName().getName() : null;
        final AccessControlContext acc = AccessController.getContext();
        try {
            final GSSCaller realCaller = caller == GSSCaller.CALLER_UNKNOWN ? GSSCaller.CALLER_INITIATE : caller;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosTicket>(){

                @Override
                public KerberosTicket run() throws Exception {
                    return Krb5Util.getInitialTicket(realCaller, clientPrincipal, acc);
                }
            });
        }
        catch (PrivilegedActionException e) {
            GSSException ge = new GSSException(13, -1, "Attempt to obtain new INITIATE credentials failed! (" + e.getMessage() + ")");
            ge.initCause(e.getException());
            throw ge;
        }
    }

    @Override
    public GSSCredentialSpi impersonate(GSSNameSpi name) throws GSSException {
        try {
            Krb5NameElement kname = (Krb5NameElement)name;
            Credentials newCred = Credentials.acquireS4U2selfCreds(kname.getKrb5PrincipalName(), this.krb5Credentials);
            return new Krb5ProxyCredential(this, kname, newCred.getTicket());
        }
        catch (IOException | KrbException ke) {
            GSSException ge = new GSSException(11, -1, "Attempt to obtain S4U2self credentials failed!");
            ge.initCause(ke);
            throw ge;
        }
    }
}

