/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.util.Objects;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.internal.rcache.AuthTime;

public class AuthTimeWithHash
extends AuthTime
implements Comparable<AuthTimeWithHash> {
    public static final String DEFAULT_HASH_ALG = GetPropertyAction.privilegedGetProperty("jdk.krb5.rcache.useMD5", "false").equals("true") ? "HASH" : "SHA256";
    final String hashAlg;
    final String hash;

    public static String realAlg(String alg) {
        switch (alg) {
            case "HASH": {
                return "MD5";
            }
            case "SHA256": {
                return "SHA-256";
            }
        }
        throw new AssertionError((Object)(alg + " is not HASH or SHA256"));
    }

    public AuthTimeWithHash(String client, String server, int ctime, int cusec, String hashAlg, String hash) {
        super(client, server, ctime, cusec);
        this.hashAlg = hashAlg;
        this.hash = hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthTimeWithHash)) {
            return false;
        }
        AuthTimeWithHash that = (AuthTimeWithHash)o;
        return Objects.equals(this.hash, that.hash) && Objects.equals(this.hashAlg, that.hashAlg) && Objects.equals(this.client, that.client) && Objects.equals(this.server, that.server) && this.ctime == that.ctime && this.cusec == that.cusec;
    }

    public int hashCode() {
        return Objects.hash(this.hash);
    }

    @Override
    public String toString() {
        return String.format("%d/%06d/%s/%s", this.ctime, this.cusec, this.hash, this.client);
    }

    @Override
    public int compareTo(AuthTimeWithHash other) {
        int cmp = 0;
        cmp = this.ctime != other.ctime ? Integer.compare(this.ctime, other.ctime) : (this.cusec != other.cusec ? Integer.compare(this.cusec, other.cusec) : this.hash.compareTo(other.hash));
        return cmp;
    }

    public boolean sameTimeDiffHash(AuthTimeWithHash old) {
        if (!this.isSameIgnoresHash(old)) {
            return false;
        }
        return this.hashAlg.equals(old.hashAlg) && !this.hash.equals(old.hash);
    }

    public boolean isSameIgnoresHash(AuthTime old) {
        return this.client.equals(old.client) && this.server.equals(old.server) && this.ctime == old.ctime && this.cusec == old.cusec;
    }

    @Override
    public byte[] encode(boolean withHash) {
        String sstring;
        String cstring;
        if (withHash) {
            cstring = "";
            sstring = String.format("%s:%s %d:%s %d:%s", this.hashAlg, this.hash, this.client.length(), this.client, this.server.length(), this.server);
        } else {
            cstring = this.client;
            sstring = this.server;
        }
        return this.encode0(cstring, sstring);
    }
}

