/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.ObjectFactory;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.consumer.TimeConverter;
import jdk.jfr.internal.Type;

public final class RecordedStackTrace
extends RecordedObject {
    static ObjectFactory<RecordedStackTrace> createFactory(Type type, final TimeConverter timeConverter) {
        return new ObjectFactory<RecordedStackTrace>(type){

            @Override
            RecordedStackTrace createTyped(List<ValueDescriptor> desc, long id, Object[] object) {
                return new RecordedStackTrace(desc, object, timeConverter);
            }
        };
    }

    private RecordedStackTrace(List<ValueDescriptor> desc, Object[] values, TimeConverter timeConverter) {
        super(desc, values, timeConverter);
    }

    public List<RecordedFrame> getFrames() {
        Object[] array = this.getTyped("frames", Object[].class, null);
        if (array == null) {
            return Collections.EMPTY_LIST;
        }
        List<Object> list = Arrays.asList(array);
        return list;
    }

    public boolean isTruncated() {
        return this.getTyped("truncated", Boolean.class, true);
    }
}

