/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PropertyPermission;
import java.util.concurrent.Callable;
import jdk.jfr.Event;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.FlightRecorderPermission;
import jdk.jfr.Recording;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import sun.misc.Unsafe;

public final class SecuritySupport {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    public static final SafePath JFC_DIRECTORY = SecuritySupport.getPathInProperty("java.home", "lib/jfr");
    static final SafePath USER_HOME = SecuritySupport.getPathInProperty("user.home", null);
    static final SafePath JAVA_IO_TMPDIR = SecuritySupport.getPathInProperty("java.io.tmpdir", null);

    private static <U> U doPrivilegedIOWithReturn(final Callable<U> function) throws IOException {
        try {
            return (U)AccessController.doPrivileged(new PrivilegedExceptionAction<U>(){

                @Override
                public U run() throws Exception {
                    return function.call();
                }
            }, null);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Unexpected error during I/O operation. " + t.getMessage(), t);
        }
    }

    private static void doPriviligedIO(RunnableWithCheckedException function) throws IOException {
        SecuritySupport.doPrivilegedIOWithReturn(() -> {
            function.run();
            return null;
        });
    }

    private static void doPrivileged(final Runnable function, Permission ... perms) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                function.run();
                return null;
            }
        }, null, perms);
    }

    private static void doPrivileged(final Runnable function) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                function.run();
                return null;
            }
        });
    }

    private static <T> T doPrivilegedWithReturn(final CallableWithoutCheckException<T> function, Permission ... perms) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return function.call();
            }
        }, null, perms);
    }

    public static List<SafePath> getPredefinedJFCFiles() {
        ArrayList<SafePath> list = new ArrayList<SafePath>();
        try {
            Iterator pathIterator = SecuritySupport.doPrivilegedIOWithReturn(() -> Files.newDirectoryStream(JFC_DIRECTORY.toPath(), "*").iterator());
            while (pathIterator.hasNext()) {
                Path path = (Path)pathIterator.next();
                if (!path.toString().endsWith(".jfc")) continue;
                list.add(new SafePath(path));
            }
        }
        catch (IOException ioe) {
            Logger.log(LogTag.JFR, LogLevel.WARN, "Could not access .jfc-files in " + JFC_DIRECTORY + ", " + ioe.getMessage());
        }
        return list;
    }

    static void makeVisibleToJFR(Class<?> clazz) {
    }

    static void addHandlerExport(Class<?> clazz) {
    }

    public static void registerEvent(Class<? extends Event> eventClass) {
        SecuritySupport.doPrivileged(() -> FlightRecorder.register(eventClass), new FlightRecorderPermission("registerEvent"));
    }

    static boolean getBooleanProperty(String propertyName) {
        return SecuritySupport.doPrivilegedWithReturn(() -> Boolean.getBoolean(propertyName), new PropertyPermission(propertyName, "read"));
    }

    private static SafePath getPathInProperty(String prop, String subPath) {
        return SecuritySupport.doPrivilegedWithReturn(() -> {
            String path = System.getProperty(prop);
            if (path == null) {
                return null;
            }
            File file = subPath == null ? new File(path) : new File(path, subPath);
            return new SafePath(file.getAbsolutePath());
        }, new PropertyPermission("*", "read"));
    }

    static Thread createRecorderThread(ThreadGroup systemThreadGroup, ClassLoader contextClassLoader) {
        Thread thread = SecuritySupport.doPrivilegedWithReturn(() -> new Thread(systemThreadGroup, "JFR Recorder Thread"), new RuntimePermission("modifyThreadGroup"), new RuntimePermission("modifyThread"));
        SecuritySupport.doPrivileged(() -> thread.setContextClassLoader(contextClassLoader), new RuntimePermission("setContextClassLoader"), new RuntimePermission("modifyThread"));
        return thread;
    }

    static void registerShutdownHook(Thread shutdownHook) {
        SecuritySupport.doPrivileged(() -> Runtime.getRuntime().addShutdownHook(shutdownHook), new RuntimePermission("shutdownHooks"));
    }

    static void setUncaughtExceptionHandler(Thread thread, Thread.UncaughtExceptionHandler eh) {
        SecuritySupport.doPrivileged(() -> thread.setUncaughtExceptionHandler(eh), new RuntimePermission("modifyThread"));
    }

    static void moveReplace(SafePath from, SafePath to) throws IOException {
        SecuritySupport.doPrivilegedIOWithReturn(() -> Files.move(from.toPath(), to.toPath(), new CopyOption[0]));
    }

    static void clearDirectory(SafePath safePath) throws IOException {
        SecuritySupport.doPriviligedIO(() -> Files.walkFileTree(safePath.toPath(), new DirectoryCleaner()));
    }

    static SafePath toRealPath(SafePath safePath) throws Exception {
        return new SafePath(SecuritySupport.doPrivilegedIOWithReturn(() -> safePath.toPath().toRealPath(new LinkOption[0])));
    }

    static boolean existDirectory(SafePath directory) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.exists(directory.toPath(), new LinkOption[0]));
    }

    static RandomAccessFile createRandomAccessFile(SafePath path) throws Exception {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> new RandomAccessFile(path.toPath().toFile(), "rw"));
    }

    public static InputStream newFileInputStream(SafePath safePath) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.newInputStream(safePath.toPath(), new OpenOption[0]));
    }

    public static long getFileSize(SafePath safePath) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.size(safePath.toPath()));
    }

    static SafePath createDirectories(SafePath safePath) throws IOException {
        Path p = SecuritySupport.doPrivilegedIOWithReturn(() -> Files.createDirectories(safePath.toPath(), new FileAttribute[0]));
        return new SafePath(p);
    }

    public static boolean exists(SafePath safePath) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.exists(safePath.toPath(), new LinkOption[0]));
    }

    public static boolean isDirectory(SafePath safePath) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.isDirectory(safePath.toPath(), new LinkOption[0]));
    }

    static void delete(SafePath localPath) throws IOException {
        SecuritySupport.doPriviligedIO(() -> Files.delete(localPath.toPath()));
    }

    static boolean isWritable(SafePath safePath) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.isWritable(safePath.toPath()));
    }

    static void deleteOnExit(SafePath safePath) {
        SecuritySupport.doPrivileged(() -> safePath.toPath().toFile().deleteOnExit());
    }

    static ReadableByteChannel newFileChannelToRead(SafePath safePath) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> FileChannel.open(safePath.toPath(), StandardOpenOption.READ));
    }

    public static InputStream getResourceAsStream(String name) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> SecuritySupport.class.getResourceAsStream(name));
    }

    public static Reader newFileReader(SafePath safePath) throws FileNotFoundException, IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.newBufferedReader(safePath.toPath()));
    }

    static void touch(SafePath path) throws IOException {
        SecuritySupport.doPriviligedIO(() -> new RandomAccessFile(path.toPath().toFile(), "rw").close());
    }

    static void setAccessible(Method method) {
        SecuritySupport.doPrivileged(() -> method.setAccessible(true), new ReflectPermission("suppressAccessChecks"));
    }

    static void setAccessible(Field field) {
        SecuritySupport.doPrivileged(() -> field.setAccessible(true), new ReflectPermission("suppressAccessChecks"));
    }

    static void setAccessible(Constructor<?> constructor) {
        SecuritySupport.doPrivileged(() -> constructor.setAccessible(true), new ReflectPermission("suppressAccessChecks"));
    }

    static void ensureClassIsInitialized(Class<?> clazz) {
        unsafe.ensureClassInitialized(clazz);
    }

    static Class<?> defineClass(String name, byte[] bytes, ClassLoader classLoader) {
        return unsafe.defineClass(name, bytes, 0, bytes.length, classLoader, null);
    }

    static Thread createThreadWitNoPermissions(String threadName, Runnable runnable) {
        return SecuritySupport.doPrivilegedWithReturn(() -> new Thread(runnable, threadName), new Permission[0]);
    }

    static void setDaemonThread(Thread t, boolean daeomn) {
        SecuritySupport.doPrivileged(() -> t.setDaemon(daeomn), new RuntimePermission("modifyThread"));
    }

    public static SafePath getAbsolutePath(SafePath path) throws IOException {
        return new SafePath(SecuritySupport.doPrivilegedIOWithReturn(() -> path.toPath().toAbsolutePath()));
    }

    private static interface CallableWithoutCheckException<T> {
        public T call();
    }

    private static interface RunnableWithCheckedException {
        public void run() throws Exception;
    }

    public static final class SafePath {
        private final Path path;
        private final String text;

        public SafePath(Path p) {
            this.text = p.toString();
            this.path = Paths.get(this.text, new String[0]);
        }

        public SafePath(String path) {
            this(Paths.get(path, new String[0]));
        }

        public Path toPath() {
            return this.path;
        }

        public String toString() {
            return this.text;
        }
    }

    private static final class DirectoryCleaner
    extends SimpleFileVisitor<Path> {
        private DirectoryCleaner() {
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            Files.delete(path);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc != null) {
                throw exc;
            }
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    }

    static final class SecureRecorderListener
    implements FlightRecorderListener {
        private final AccessControlContext context;
        private final FlightRecorderListener changeListener;

        SecureRecorderListener(AccessControlContext context, FlightRecorderListener changeListener) {
            this.context = Objects.requireNonNull(context);
            this.changeListener = Objects.requireNonNull(changeListener);
        }

        @Override
        public void recordingStateChanged(Recording recording) {
            AccessController.doPrivileged(() -> {
                try {
                    this.changeListener.recordingStateChanged(recording);
                }
                catch (Throwable t) {
                    Logger.log(LogTag.JFR, LogLevel.WARN, "Unexpected exception in listener " + this.changeListener.getClass() + " at recording state change");
                }
                return null;
            }, this.context);
        }

        @Override
        public void recorderInitialized(FlightRecorder recorder) {
            AccessController.doPrivileged(() -> {
                try {
                    this.changeListener.recorderInitialized(recorder);
                }
                catch (Throwable t) {
                    Logger.log(LogTag.JFR, LogLevel.WARN, "Unexpected exception in listener " + this.changeListener.getClass() + " when initializing FlightRecorder");
                }
                return null;
            }, this.context);
        }

        public FlightRecorderListener getChangeListener() {
            return this.changeListener;
        }
    }
}

