/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import jdk.jfr.internal.JVM;
import sun.misc.Unsafe;

public final class StringPool {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    static final int MIN_LIMIT = 16;
    static final int MAX_LIMIT = 128;
    private static final long epochAddress;
    private static final SimpleStringIdPool sp;

    public static long addString(String s) {
        return StringPool.sp.addString(s);
    }

    private static boolean getCurrentEpoch() {
        return unsafe.getByte(epochAddress) == 1;
    }

    static {
        sp = new SimpleStringIdPool();
        epochAddress = JVM.getJVM().getEpochAddress();
        sp.reset();
    }

    private static class SimpleStringIdPool {
        private final AtomicLong sidIdx = new AtomicLong();
        private boolean poolEpoch;
        private final ConcurrentHashMap<String, Long> cache;
        private final int MAX_SIZE = 32768;
        private final long MAX_SIZE_UTF16 = 0x1000000L;
        private long currentSizeUTF16;
        private final String[] preCache = new String[]{"", "", "", ""};
        private int preCacheOld = 0;
        private static final int preCacheMask = 3;

        SimpleStringIdPool() {
            this.cache = new ConcurrentHashMap(32768, 0.75f);
        }

        void reset() {
            this.reset(StringPool.getCurrentEpoch());
        }

        private void reset(boolean epoch) {
            this.cache.clear();
            this.poolEpoch = epoch;
            this.currentSizeUTF16 = 0L;
        }

        private long addString(String s) {
            boolean currentEpoch = StringPool.getCurrentEpoch();
            if (this.poolEpoch == currentEpoch) {
                Long lsid = this.cache.get(s);
                if (lsid != null) {
                    return lsid;
                }
            } else {
                this.reset(currentEpoch);
            }
            if (!this.preCache(s)) {
                return -1L;
            }
            if (this.cache.size() > 32768 || this.currentSizeUTF16 > 0x1000000L) {
                this.reset(currentEpoch);
            }
            return this.storeString(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long storeString(String s) {
            long sid = this.sidIdx.getAndIncrement();
            this.cache.put(s, sid);
            Class<SimpleStringIdPool> clazz = SimpleStringIdPool.class;
            synchronized (SimpleStringIdPool.class) {
                boolean currentEpoch = JVM.addStringConstant(this.poolEpoch, sid, s);
                this.currentSizeUTF16 += (long)s.length();
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return currentEpoch == this.poolEpoch ? sid : -1L;
            }
        }

        private boolean preCache(String s) {
            if (this.preCache[0].equals(s)) {
                return true;
            }
            if (this.preCache[1].equals(s)) {
                return true;
            }
            if (this.preCache[2].equals(s)) {
                return true;
            }
            if (this.preCache[3].equals(s)) {
                return true;
            }
            this.preCacheOld = this.preCacheOld - 1 & 3;
            this.preCache[this.preCacheOld] = s;
            return false;
        }
    }
}

