/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.security.AccessController;
import sun.java2d.marlin.MarlinUtils;
import sun.security.action.GetPropertyAction;

public final class MarlinProperties {
    private MarlinProperties() {
    }

    public static boolean isUseThreadLocal() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.useThreadLocal", "true");
    }

    public static int getInitialImageSize() {
        return MarlinProperties.getInteger("sun.java2d.renderer.pixelsize", 2048, 64, 32768);
    }

    public static int getSubPixel_Log2_X() {
        return MarlinProperties.getInteger("sun.java2d.renderer.subPixel_log2_X", 3, 1, 8);
    }

    public static int getSubPixel_Log2_Y() {
        return MarlinProperties.getInteger("sun.java2d.renderer.subPixel_log2_Y", 3, 1, 8);
    }

    public static int getTileSize_Log2() {
        return MarlinProperties.getInteger("sun.java2d.renderer.tileSize_log2", 5, 3, 8);
    }

    public static int getBlockSize_Log2() {
        return MarlinProperties.getInteger("sun.java2d.renderer.blockSize_log2", 5, 3, 8);
    }

    public static boolean isForceRLE() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.forceRLE", "false");
    }

    public static boolean isForceNoRLE() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.forceNoRLE", "false");
    }

    public static boolean isUseTileFlags() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.useTileFlags", "true");
    }

    public static boolean isUseTileFlagsWithHeuristics() {
        return MarlinProperties.isUseTileFlags() && MarlinProperties.getBoolean("sun.java2d.renderer.useTileFlags.useHeuristics", "true");
    }

    public static int getRLEMinWidth() {
        return MarlinProperties.getInteger("sun.java2d.renderer.rleMinWidth", 64, 0, Integer.MAX_VALUE);
    }

    public static boolean isUseSimplifier() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.useSimplifier", "false");
    }

    public static boolean isDoStats() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.doStats", "false");
    }

    public static boolean isDoMonitors() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.doMonitors", "false");
    }

    public static boolean isDoChecks() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.doChecks", "false");
    }

    public static boolean isLoggingEnabled() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.log", "false");
    }

    public static boolean isUseLogger() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.useLogger", "false");
    }

    public static boolean isLogCreateContext() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.logCreateContext", "false");
    }

    public static boolean isLogUnsafeMalloc() {
        return MarlinProperties.getBoolean("sun.java2d.renderer.logUnsafeMalloc", "false");
    }

    static boolean getBoolean(String key, String def) {
        return Boolean.valueOf(AccessController.doPrivileged(new GetPropertyAction(key, def)));
    }

    static int getInteger(String key, int def, int min, int max) {
        String property = AccessController.doPrivileged(new GetPropertyAction(key));
        int value = def;
        if (property != null) {
            try {
                value = Integer.decode(property);
            }
            catch (NumberFormatException e) {
                MarlinUtils.logInfo("Invalid integer value for " + key + " = " + property);
            }
        }
        if (value < min || value > max) {
            MarlinUtils.logInfo("Invalid value for " + key + " = " + value + "; expected value in range[" + min + ", " + max + "] !");
            value = def;
        }
        return value;
    }
}

