/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11GraphicsEnvironment;
import sun.awt.image.OffScreenImage;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.java2d.SunGraphics2D;
import sun.java2d.Surface;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.GLXSurfaceData;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.hw.AccelDeviceEventListener;
import sun.java2d.pipe.hw.AccelDeviceEventNotifier;
import sun.java2d.pipe.hw.AccelSurface;
import sun.java2d.pipe.hw.AccelTypedVolatileImage;
import sun.java2d.pipe.hw.ContextCapabilities;

public class GLXGraphicsConfig
extends X11GraphicsConfig
implements OGLGraphicsConfig {
    private static ImageCapabilities imageCaps = new GLXImageCaps();
    private BufferCapabilities bufferCaps;
    private long pConfigInfo;
    private ContextCapabilities oglCaps;
    private OGLContext context;

    private static native long getGLXConfigInfo(int var0, int var1);

    private static native int getOGLCapabilities(long var0);

    private native void initConfig(long var1, long var3);

    private GLXGraphicsConfig(X11GraphicsDevice device, int visualnum, long configInfo, ContextCapabilities oglCaps) {
        super(device, visualnum, 0, 0, (oglCaps.getCaps() & 0x10000) != 0);
        this.pConfigInfo = configInfo;
        this.initConfig(this.getAData(), configInfo);
        this.oglCaps = oglCaps;
        this.context = new OGLContext(OGLRenderQueue.getInstance(), this);
    }

    @Override
    public Object getProxyKey() {
        return this;
    }

    @Override
    public SurfaceData createManagedSurface(int w, int h, int transparency) {
        return GLXSurfaceData.createData(this, w, h, this.getColorModel(transparency), null, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GLXGraphicsConfig getConfig(X11GraphicsDevice device, int visualnum) {
        if (!X11GraphicsEnvironment.isGLXAvailable()) {
            return null;
        }
        long cfginfo = 0L;
        final String[] ids = new String[1];
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            OGLContext.invalidateCurrentContext();
            GLXGetConfigInfo action = new GLXGetConfigInfo(device.getScreen(), visualnum);
            rq.flushAndInvokeNow(action);
            cfginfo = action.getConfigInfo();
            if (cfginfo != 0L) {
                OGLContext.setScratchSurface(cfginfo);
                rq.flushAndInvokeNow(new Runnable(){

                    @Override
                    public void run() {
                        ids[0] = OGLContext.getOGLIdString();
                    }
                });
            }
        }
        finally {
            rq.unlock();
        }
        if (cfginfo == 0L) {
            return null;
        }
        int oglCaps = GLXGraphicsConfig.getOGLCapabilities(cfginfo);
        OGLContext.OGLContextCaps caps = new OGLContext.OGLContextCaps(oglCaps, ids[0]);
        return new GLXGraphicsConfig(device, visualnum, cfginfo, caps);
    }

    @Override
    public final boolean isCapPresent(int cap) {
        return (this.oglCaps.getCaps() & cap) != 0;
    }

    @Override
    public final long getNativeConfigInfo() {
        return this.pConfigInfo;
    }

    @Override
    public final OGLContext getContext() {
        return this.context;
    }

    @Override
    public BufferedImage createCompatibleImage(int width, int height) {
        DirectColorModel model = new DirectColorModel(24, 0xFF0000, 65280, 255);
        WritableRaster raster = ((ColorModel)model).createCompatibleWritableRaster(width, height);
        return new BufferedImage(model, raster, model.isAlphaPremultiplied(), null);
    }

    @Override
    public ColorModel getColorModel(int transparency) {
        switch (transparency) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                ColorSpace cs = ColorSpace.getInstance(1000);
                return new DirectColorModel(cs, 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "GLXGraphicsConfig[dev=" + this.screen + ",vis=0x" + Integer.toHexString(this.visual) + "]";
    }

    @Override
    public SurfaceData createSurfaceData(X11ComponentPeer peer) {
        return GLXSurfaceData.createData(peer);
    }

    @Override
    public Image createAcceleratedImage(Component target, int width, int height) {
        ColorModel model = this.getColorModel(1);
        WritableRaster wr = model.createCompatibleWritableRaster(width, height);
        return new OffScreenImage(target, model, wr, model.isAlphaPremultiplied());
    }

    @Override
    public long createBackBuffer(X11ComponentPeer peer, int numBuffers, BufferCapabilities caps) throws AWTException {
        if (numBuffers > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities configCaps = this.getBufferCapabilities();
        if (!configCaps.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (caps.getFlipContents() == BufferCapabilities.FlipContents.PRIOR) {
            throw new AWTException("FlipContents.PRIOR is not supported");
        }
        return 1L;
    }

    @Override
    public void destroyBackBuffer(long backBuffer) {
    }

    @Override
    public VolatileImage createBackBufferImage(Component target, long backBuffer) {
        return new SunVolatileImage(target, target.getWidth(), target.getHeight(), Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flip(X11ComponentPeer peer, Component target, VolatileImage xBackBuffer, int x1, int y1, int x2, int y2, BufferCapabilities.FlipContents flipAction) {
        if (flipAction == BufferCapabilities.FlipContents.COPIED) {
            SurfaceManager vsm = SurfaceManager.getManager(xBackBuffer);
            SurfaceData sd = vsm.getPrimarySurfaceData();
            if (sd instanceof GLXSurfaceData.GLXVSyncOffScreenSurfaceData) {
                GLXSurfaceData.GLXVSyncOffScreenSurfaceData vsd = (GLXSurfaceData.GLXVSyncOffScreenSurfaceData)sd;
                SurfaceData bbsd = vsd.getFlipSurface();
                SunGraphics2D bbg = new SunGraphics2D(bbsd, Color.black, Color.white, null);
                try {
                    ((Graphics)bbg).drawImage(xBackBuffer, 0, 0, null);
                }
                finally {
                    ((Graphics)bbg).dispose();
                }
            }
            Graphics g = peer.getGraphics();
            try {
                g.drawImage(xBackBuffer, x1, y1, x2, y2, x1, y1, x2, y2, null);
            }
            finally {
                g.dispose();
            }
            return;
        }
        if (flipAction == BufferCapabilities.FlipContents.PRIOR) {
            return;
        }
        OGLSurfaceData.swapBuffers(peer.getContentWindow());
        if (flipAction == BufferCapabilities.FlipContents.BACKGROUND) {
            Graphics g = xBackBuffer.getGraphics();
            try {
                g.setColor(target.getBackground());
                g.fillRect(0, 0, xBackBuffer.getWidth(), xBackBuffer.getHeight());
            }
            finally {
                g.dispose();
            }
        }
    }

    @Override
    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = new GLXBufferCaps(this.isDoubleBuffered());
        }
        return this.bufferCaps;
    }

    @Override
    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    @Override
    public VolatileImage createCompatibleVolatileImage(int width, int height, int transparency, int type) {
        if (type != 5 && type != 3 || transparency == 2 || type == 5 && !this.isCapPresent(12)) {
            return null;
        }
        AccelTypedVolatileImage vi = new AccelTypedVolatileImage((GraphicsConfiguration)this, width, height, transparency, type);
        Surface sd = vi.getDestSurface();
        if (!(sd instanceof AccelSurface) || ((AccelSurface)sd).getType() != type) {
            vi.flush();
            vi = null;
        }
        return vi;
    }

    @Override
    public ContextCapabilities getContextCapabilities() {
        return this.oglCaps;
    }

    @Override
    public void addDeviceEventListener(AccelDeviceEventListener l) {
        AccelDeviceEventNotifier.addListener(l, this.screen.getScreen());
    }

    @Override
    public void removeDeviceEventListener(AccelDeviceEventListener l) {
        AccelDeviceEventNotifier.removeListener(l);
    }

    private static class GLXImageCaps
    extends ImageCapabilities {
        private GLXImageCaps() {
            super(true);
        }

        @Override
        public boolean isTrueVolatile() {
            return true;
        }
    }

    private static class GLXBufferCaps
    extends BufferCapabilities {
        public GLXBufferCaps(boolean dblBuf) {
            super(imageCaps, imageCaps, dblBuf ? BufferCapabilities.FlipContents.UNDEFINED : null);
        }
    }

    private static class GLXGetConfigInfo
    implements Runnable {
        private int screen;
        private int visual;
        private long cfginfo;

        private GLXGetConfigInfo(int screen, int visual) {
            this.screen = screen;
            this.visual = visual;
        }

        @Override
        public void run() {
            this.cfginfo = GLXGraphicsConfig.getGLXConfigInfo(this.screen, this.visual);
        }

        public long getConfigInfo() {
            return this.cfginfo;
        }
    }
}

