/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.ThreadMXBean;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.Objects;
import javax.management.ObjectName;
import sun.management.Util;
import sun.management.VMManagement;

class ThreadImpl
implements ThreadMXBean {
    private final VMManagement jvm;
    private boolean contentionMonitoringEnabled = false;
    private boolean cpuTimeEnabled;
    private boolean allocatedMemoryEnabled;

    ThreadImpl(VMManagement vm) {
        this.jvm = vm;
        this.cpuTimeEnabled = this.jvm.isThreadCpuTimeEnabled();
        this.allocatedMemoryEnabled = this.jvm.isThreadAllocatedMemoryEnabled();
    }

    @Override
    public int getThreadCount() {
        return this.jvm.getLiveThreadCount();
    }

    @Override
    public int getPeakThreadCount() {
        return this.jvm.getPeakThreadCount();
    }

    @Override
    public long getTotalStartedThreadCount() {
        return this.jvm.getTotalThreadCount();
    }

    @Override
    public int getDaemonThreadCount() {
        return this.jvm.getDaemonThreadCount();
    }

    @Override
    public boolean isThreadContentionMonitoringSupported() {
        return this.jvm.isThreadContentionMonitoringSupported();
    }

    @Override
    public synchronized boolean isThreadContentionMonitoringEnabled() {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported.");
        }
        return this.contentionMonitoringEnabled;
    }

    @Override
    public boolean isThreadCpuTimeSupported() {
        return this.jvm.isOtherThreadCpuTimeSupported();
    }

    @Override
    public boolean isCurrentThreadCpuTimeSupported() {
        return this.jvm.isCurrentThreadCpuTimeSupported();
    }

    @Override
    public boolean isThreadAllocatedMemorySupported() {
        return this.jvm.isThreadAllocatedMemorySupported();
    }

    @Override
    public boolean isThreadCpuTimeEnabled() {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        return this.cpuTimeEnabled;
    }

    private void ensureThreadAllocatedMemorySupported() {
        if (!this.isThreadAllocatedMemorySupported()) {
            throw new UnsupportedOperationException("Thread allocated memory measurement is not supported.");
        }
    }

    @Override
    public boolean isThreadAllocatedMemoryEnabled() {
        this.ensureThreadAllocatedMemorySupported();
        return this.allocatedMemoryEnabled;
    }

    @Override
    public long[] getAllThreadIds() {
        Util.checkMonitorAccess();
        Thread[] threads = ThreadImpl.getThreads();
        int length = threads.length;
        long[] ids = new long[length];
        for (int i = 0; i < length; ++i) {
            Thread t = threads[i];
            ids[i] = t.getId();
        }
        return ids;
    }

    @Override
    public ThreadInfo getThreadInfo(long id) {
        long[] ids = new long[]{id};
        ThreadInfo[] infos = this.getThreadInfo(ids, 0);
        return infos[0];
    }

    @Override
    public ThreadInfo getThreadInfo(long id, int maxDepth) {
        long[] ids = new long[]{id};
        ThreadInfo[] infos = this.getThreadInfo(ids, maxDepth);
        return infos[0];
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids) {
        return this.getThreadInfo(ids, 0);
    }

    private void verifyThreadId(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + id);
        }
    }

    private void verifyThreadIds(long[] ids) {
        Objects.requireNonNull(ids);
        for (int i = 0; i < ids.length; ++i) {
            this.verifyThreadId(ids[i]);
        }
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids, int maxDepth) {
        this.verifyThreadIds(ids);
        if (maxDepth < 0) {
            throw new IllegalArgumentException("Invalid maxDepth parameter: " + maxDepth);
        }
        if (ids.length == 0) {
            return new ThreadInfo[0];
        }
        Util.checkMonitorAccess();
        ThreadInfo[] infos = new ThreadInfo[ids.length];
        if (maxDepth == Integer.MAX_VALUE) {
            ThreadImpl.getThreadInfo1(ids, -1, infos);
        } else {
            ThreadImpl.getThreadInfo1(ids, maxDepth, infos);
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadContentionMonitoringEnabled(boolean enable) {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException("Thread contention monitoring is not supported");
        }
        Util.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.contentionMonitoringEnabled != enable) {
                if (enable) {
                    ThreadImpl.resetContentionTimes0(0L);
                }
                ThreadImpl.setThreadContentionMonitoringEnabled0(enable);
                this.contentionMonitoringEnabled = enable;
            }
        }
    }

    private boolean verifyCurrentThreadCpuTime() {
        if (!this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Current thread CPU time measurement is not supported.");
        }
        return this.isThreadCpuTimeEnabled();
    }

    @Override
    public long getCurrentThreadCpuTime() {
        if (this.verifyCurrentThreadCpuTime()) {
            return ThreadImpl.getThreadTotalCpuTime0(0L);
        }
        return -1L;
    }

    @Override
    public long getThreadCpuTime(long id) {
        long[] ids = new long[]{id};
        long[] times = this.getThreadCpuTime(ids);
        return times[0];
    }

    private boolean verifyThreadCpuTime(long[] ids) {
        this.verifyThreadIds(ids);
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported.");
        }
        if (!this.isThreadCpuTimeSupported()) {
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] == Thread.currentThread().getId()) continue;
                throw new UnsupportedOperationException("Thread CPU time measurement is only supported for the current thread.");
            }
        }
        return this.isThreadCpuTimeEnabled();
    }

    @Override
    public long[] getThreadCpuTime(long[] ids) {
        boolean verified = this.verifyThreadCpuTime(ids);
        int length = ids.length;
        long[] times = new long[length];
        Arrays.fill(times, -1L);
        if (verified) {
            if (length == 1) {
                long id = ids[0];
                if (id == Thread.currentThread().getId()) {
                    id = 0L;
                }
                times[0] = ThreadImpl.getThreadTotalCpuTime0(id);
            } else {
                ThreadImpl.getThreadTotalCpuTime1(ids, times);
            }
        }
        return times;
    }

    @Override
    public long getCurrentThreadUserTime() {
        if (this.verifyCurrentThreadCpuTime()) {
            return ThreadImpl.getThreadUserCpuTime0(0L);
        }
        return -1L;
    }

    @Override
    public long getThreadUserTime(long id) {
        long[] ids = new long[]{id};
        long[] times = this.getThreadUserTime(ids);
        return times[0];
    }

    @Override
    public long[] getThreadUserTime(long[] ids) {
        boolean verified = this.verifyThreadCpuTime(ids);
        int length = ids.length;
        long[] times = new long[length];
        Arrays.fill(times, -1L);
        if (verified) {
            if (length == 1) {
                long id = ids[0];
                if (id == Thread.currentThread().getId()) {
                    id = 0L;
                }
                times[0] = ThreadImpl.getThreadUserCpuTime0(id);
            } else {
                ThreadImpl.getThreadUserCpuTime1(ids, times);
            }
        }
        return times;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadCpuTimeEnabled(boolean enable) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException("Thread CPU time measurement is not supported");
        }
        Util.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.cpuTimeEnabled != enable) {
                ThreadImpl.setThreadCpuTimeEnabled0(enable);
                this.cpuTimeEnabled = enable;
            }
        }
    }

    @Override
    public long getTotalThreadAllocatedBytes() {
        if (this.isThreadAllocatedMemoryEnabled()) {
            return ThreadImpl.getTotalThreadAllocatedMemory();
        }
        return -1L;
    }

    @Override
    public long getCurrentThreadAllocatedBytes() {
        if (this.isThreadAllocatedMemoryEnabled()) {
            return ThreadImpl.getThreadAllocatedMemory0(0L);
        }
        return -1L;
    }

    private boolean verifyThreadAllocatedMemory(long id) {
        this.verifyThreadId(id);
        return this.isThreadAllocatedMemoryEnabled();
    }

    @Override
    public long getThreadAllocatedBytes(long id) {
        boolean verified = this.verifyThreadAllocatedMemory(id);
        if (verified) {
            return ThreadImpl.getThreadAllocatedMemory0(Thread.currentThread().getId() == id ? 0L : id);
        }
        return -1L;
    }

    private boolean verifyThreadAllocatedMemory(long[] ids) {
        this.verifyThreadIds(ids);
        return this.isThreadAllocatedMemoryEnabled();
    }

    @Override
    public long[] getThreadAllocatedBytes(long[] ids) {
        Objects.requireNonNull(ids);
        if (ids.length == 1) {
            long size = this.getThreadAllocatedBytes(ids[0]);
            return new long[]{size};
        }
        boolean verified = this.verifyThreadAllocatedMemory(ids);
        long[] sizes = new long[ids.length];
        Arrays.fill(sizes, -1L);
        if (verified) {
            ThreadImpl.getThreadAllocatedMemory1(ids, sizes);
        }
        return sizes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadAllocatedMemoryEnabled(boolean enable) {
        this.ensureThreadAllocatedMemorySupported();
        Util.checkControlAccess();
        ThreadImpl threadImpl = this;
        synchronized (threadImpl) {
            if (this.allocatedMemoryEnabled != enable) {
                ThreadImpl.setThreadAllocatedMemoryEnabled0(enable);
                this.allocatedMemoryEnabled = enable;
            }
        }
    }

    @Override
    public long[] findMonitorDeadlockedThreads() {
        Util.checkMonitorAccess();
        Thread[] threads = ThreadImpl.findMonitorDeadlockedThreads0();
        if (threads == null) {
            return null;
        }
        long[] ids = new long[threads.length];
        for (int i = 0; i < threads.length; ++i) {
            Thread t = threads[i];
            ids[i] = t.getId();
        }
        return ids;
    }

    @Override
    public long[] findDeadlockedThreads() {
        if (!this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Synchronizer Usage is not supported.");
        }
        Util.checkMonitorAccess();
        Thread[] threads = ThreadImpl.findDeadlockedThreads0();
        if (threads == null) {
            return null;
        }
        long[] ids = new long[threads.length];
        for (int i = 0; i < threads.length; ++i) {
            Thread t = threads[i];
            ids[i] = t.getId();
        }
        return ids;
    }

    @Override
    public void resetPeakThreadCount() {
        Util.checkControlAccess();
        ThreadImpl.resetPeakThreadCount0();
    }

    @Override
    public boolean isObjectMonitorUsageSupported() {
        return this.jvm.isObjectMonitorUsageSupported();
    }

    @Override
    public boolean isSynchronizerUsageSupported() {
        return this.jvm.isSynchronizerUsageSupported();
    }

    private void verifyDumpThreads(boolean lockedMonitors, boolean lockedSynchronizers) {
        if (lockedMonitors && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Object Monitor Usage is not supported.");
        }
        if (lockedSynchronizers && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException("Monitoring of Synchronizer Usage is not supported.");
        }
        Util.checkMonitorAccess();
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids, boolean lockedMonitors, boolean lockedSynchronizers) {
        return ThreadImpl.dumpThreads0(ids, lockedMonitors, lockedSynchronizers, Integer.MAX_VALUE);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids, boolean lockedMonitors, boolean lockedSynchronizers, int maxDepth) {
        if (maxDepth < 0) {
            throw new IllegalArgumentException("Invalid maxDepth parameter: " + maxDepth);
        }
        this.verifyThreadIds(ids);
        if (ids.length == 0) {
            return new ThreadInfo[0];
        }
        this.verifyDumpThreads(lockedMonitors, lockedSynchronizers);
        return ThreadImpl.dumpThreads0(ids, lockedMonitors, lockedSynchronizers, maxDepth);
    }

    @Override
    public ThreadInfo[] dumpAllThreads(boolean lockedMonitors, boolean lockedSynchronizers) {
        return this.dumpAllThreads(lockedMonitors, lockedSynchronizers, Integer.MAX_VALUE);
    }

    @Override
    public ThreadInfo[] dumpAllThreads(boolean lockedMonitors, boolean lockedSynchronizers, int maxDepth) {
        if (maxDepth < 0) {
            throw new IllegalArgumentException("Invalid maxDepth parameter: " + maxDepth);
        }
        this.verifyDumpThreads(lockedMonitors, lockedSynchronizers);
        return ThreadImpl.dumpThreads0(null, lockedMonitors, lockedSynchronizers, maxDepth);
    }

    private static native Thread[] getThreads();

    private static native void getThreadInfo1(long[] var0, int var1, ThreadInfo[] var2);

    private static native long getThreadTotalCpuTime0(long var0);

    private static native void getThreadTotalCpuTime1(long[] var0, long[] var1);

    private static native long getThreadUserCpuTime0(long var0);

    private static native void getThreadUserCpuTime1(long[] var0, long[] var1);

    private static native long getThreadAllocatedMemory0(long var0);

    private static native void getThreadAllocatedMemory1(long[] var0, long[] var1);

    private static native long getTotalThreadAllocatedMemory();

    private static native void setThreadCpuTimeEnabled0(boolean var0);

    private static native void setThreadAllocatedMemoryEnabled0(boolean var0);

    private static native void setThreadContentionMonitoringEnabled0(boolean var0);

    private static native Thread[] findMonitorDeadlockedThreads0();

    private static native Thread[] findDeadlockedThreads0();

    private static native void resetPeakThreadCount0();

    private static native ThreadInfo[] dumpThreads0(long[] var0, boolean var1, boolean var2, int var3);

    private static native void resetContentionTimes0(long var0);

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=Threading");
    }
}

