/*
 * Decompiled with CFR 0.152.
 */
package sun.net.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLPermission;
import java.security.Permission;

public class URLUtil {
    public static String urlNoFragString(URL url) {
        String file;
        String host;
        StringBuilder strForm = new StringBuilder();
        String protocol = url.getProtocol();
        if (protocol != null) {
            protocol = protocol.toLowerCase();
            strForm.append(protocol);
            strForm.append("://");
        }
        if ((host = url.getHost()) != null) {
            host = host.toLowerCase();
            strForm.append(host);
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            if (port != -1) {
                strForm.append(":").append(port);
            }
        }
        if ((file = url.getFile()) != null) {
            strForm.append(file);
        }
        return strForm.toString();
    }

    public static Permission getConnectPermission(URL url) throws IOException {
        String urlStringLowerCase = url.toString().toLowerCase();
        if (urlStringLowerCase.startsWith("http:") || urlStringLowerCase.startsWith("https:")) {
            return URLUtil.getURLConnectPermission(url);
        }
        if (urlStringLowerCase.startsWith("jar:http:") || urlStringLowerCase.startsWith("jar:https:")) {
            String urlString;
            int bangPos = (urlString = url.toString()).indexOf("!/");
            urlString = urlString.substring(4, bangPos > -1 ? bangPos : urlString.length());
            URL u = new URL(urlString);
            return URLUtil.getURLConnectPermission(u);
        }
        return url.openConnection().getPermission();
    }

    private static Permission getURLConnectPermission(URL url) {
        String urlString = url.getProtocol() + "://" + url.getAuthority() + url.getPath();
        return new URLPermission(urlString);
    }
}

