/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.net.ExtendedOptionsHelper;
import sun.net.NetHooks;
import sun.nio.ch.AsynchronousChannelGroupImpl;
import sun.nio.ch.Cancellable;
import sun.nio.ch.Groupable;
import sun.nio.ch.Net;
import sun.nio.ch.PendingFuture;

abstract class AsynchronousServerSocketChannelImpl
extends AsynchronousServerSocketChannel
implements Cancellable,
Groupable {
    protected final FileDescriptor fd;
    protected volatile InetSocketAddress localAddress = null;
    private final Object stateLock = new Object();
    private ReadWriteLock closeLock = new ReentrantReadWriteLock();
    private volatile boolean open = true;
    private volatile boolean acceptKilled;
    private boolean isReuseAddress;

    AsynchronousServerSocketChannelImpl(AsynchronousChannelGroupImpl group) {
        super(group.provider());
        this.fd = Net.serverSocket(true);
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    final void begin() throws IOException {
        this.closeLock.readLock().lock();
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    final void end() {
        this.closeLock.readLock().unlock();
    }

    abstract void implClose() throws IOException;

    @Override
    public final void close() throws IOException {
        this.closeLock.writeLock().lock();
        try {
            if (!this.open) {
                return;
            }
            this.open = false;
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        this.implClose();
    }

    abstract Future<AsynchronousSocketChannel> implAccept(Object var1, CompletionHandler<AsynchronousSocketChannel, Object> var2);

    @Override
    public final Future<AsynchronousSocketChannel> accept() {
        return this.implAccept(null, null);
    }

    @Override
    public final <A> void accept(A attachment, CompletionHandler<AsynchronousSocketChannel, ? super A> handler) {
        if (handler == null) {
            throw new NullPointerException("'handler' is null");
        }
        this.implAccept(attachment, handler);
    }

    final boolean isAcceptKilled() {
        return this.acceptKilled;
    }

    @Override
    public final void onCancel(PendingFuture<?, ?> task) {
        this.acceptKilled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AsynchronousServerSocketChannel bind(SocketAddress local, int backlog) throws IOException {
        InetSocketAddress isa = local == null ? new InetSocketAddress(0) : Net.checkAddress(local);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkListen(isa.getPort());
        }
        try {
            this.begin();
            Object object = this.stateLock;
            synchronized (object) {
                if (this.localAddress != null) {
                    throw new AlreadyBoundException();
                }
                NetHooks.beforeTcpBind(this.fd, isa.getAddress(), isa.getPort());
                Net.bind(this.fd, isa.getAddress(), isa.getPort());
                Net.listen(this.fd, backlog < 1 ? 50 : backlog);
                this.localAddress = Net.localAddress(this.fd);
            }
        }
        finally {
            this.end();
        }
        return this;
    }

    @Override
    public final SocketAddress getLocalAddress() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return Net.getRevealedLocalAddress(this.localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> AsynchronousServerSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        try {
            this.begin();
            if (name == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind()) {
                this.isReuseAddress = (Boolean)value;
            } else {
                Net.setSocketOption(this.fd, Net.UNSPEC, name, value);
            }
            AsynchronousServerSocketChannelImpl asynchronousServerSocketChannelImpl = this;
            return asynchronousServerSocketChannelImpl;
        }
        finally {
            this.end();
        }
    }

    @Override
    public final <T> T getOption(SocketOption<T> name) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        try {
            this.begin();
            if (name == StandardSocketOptions.SO_REUSEADDR && Net.useExclusiveBind()) {
                Boolean bl = this.isReuseAddress;
                return (T)bl;
            }
            Object object = Net.getSocketOption(this.fd, Net.UNSPEC, name);
            return (T)object;
        }
        finally {
            this.end();
        }
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append('[');
        if (!this.isOpen()) {
            sb.append("closed");
        } else if (this.localAddress == null) {
            sb.append("unbound");
        } else {
            sb.append(Net.getRevealedLocalAddressAsString(this.localAddress));
        }
        sb.append(']');
        return sb.toString();
    }

    private static class DefaultOptionsHolder {
        static final Set<SocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SocketOption<?>> defaultOptions() {
            HashSet set = new HashSet(2);
            set.add(StandardSocketOptions.SO_RCVBUF);
            set.add(StandardSocketOptions.SO_REUSEADDR);
            set.addAll(ExtendedOptionsHelper.keepAliveOptions());
            return Collections.unmodifiableSet(set);
        }
    }
}

