/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import sun.security.krb5.internal.Krb5;

public class SCDynamicStoreConfig {
    private static boolean DEBUG = Krb5.DEBUG;

    private static native void installNotificationCallback();

    private static native Hashtable<String, Object> getKerberosConfig();

    private static Vector<String> unwrapHost(Collection<Hashtable<String, String>> c) {
        Vector<String> vector = new Vector<String>();
        for (Hashtable<String, String> m : c) {
            vector.add(m.get("host"));
        }
        return vector;
    }

    private static Hashtable<String, Object> convertRealmConfigs(Hashtable<String, ?> configs) {
        Hashtable<String, Object> realmsTable = new Hashtable<String, Object>();
        for (String realm : configs.keySet()) {
            Collection kadmin;
            Hashtable map = (Hashtable)configs.get(realm);
            Hashtable<String, Vector<String>> realmMap = new Hashtable<String, Vector<String>>();
            Collection kdc = (Collection)map.get("kdc");
            if (kdc != null) {
                realmMap.put("kdc", SCDynamicStoreConfig.unwrapHost(kdc));
            }
            if ((kadmin = (Collection)map.get("kadmin")) != null) {
                realmMap.put("admin_server", SCDynamicStoreConfig.unwrapHost(kadmin));
            }
            realmsTable.put(realm, realmMap);
        }
        return realmsTable;
    }

    public static Hashtable<String, Object> getConfig() throws IOException {
        Hashtable<String, Object> stanzaTable = SCDynamicStoreConfig.getKerberosConfig();
        if (stanzaTable == null) {
            throw new IOException("Could not load configuration from SCDynamicStore");
        }
        if (DEBUG) {
            System.out.println("Raw map from JNI: " + stanzaTable);
        }
        return SCDynamicStoreConfig.convertNativeConfig(stanzaTable);
    }

    private static Hashtable<String, Object> convertNativeConfig(Hashtable<String, Object> stanzaTable) {
        Hashtable realms = (Hashtable)stanzaTable.get("realms");
        if (realms != null) {
            stanzaTable.remove("realms");
            Hashtable<String, Object> realmsTable = SCDynamicStoreConfig.convertRealmConfigs(realms);
            stanzaTable.put("realms", realmsTable);
        }
        SCDynamicStoreConfig.WrapAllStringInVector(stanzaTable);
        if (DEBUG) {
            System.out.println("stanzaTable : " + stanzaTable);
        }
        return stanzaTable;
    }

    private static void WrapAllStringInVector(Hashtable<String, Object> stanzaTable) {
        for (String s : stanzaTable.keySet()) {
            Object v = stanzaTable.get(s);
            if (v instanceof Hashtable) {
                SCDynamicStoreConfig.WrapAllStringInVector((Hashtable)v);
                continue;
            }
            if (!(v instanceof String)) continue;
            Vector<String> vec = new Vector<String>();
            vec.add((String)v);
            stanzaTable.put(s, vec);
        }
    }

    static {
        boolean isMac = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String osname = System.getProperty("os.name");
                if (osname.contains("OS X")) {
                    System.loadLibrary("osx");
                    return true;
                }
                return false;
            }
        });
        if (isMac) {
            SCDynamicStoreConfig.installNotificationCallback();
        }
    }
}

