/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import sun.nio.ch.FileChannelImpl;

public class FileInputStream
extends InputStream {
    private final FileDescriptor fd;
    private final String path;
    private FileChannel channel = null;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;

    public FileInputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        String name = file != null ? file.getPath() : null;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(name);
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.fd.attach(this);
        this.path = name;
        this.open(name);
    }

    public FileInputStream(FileDescriptor fdObj) {
        SecurityManager security = System.getSecurityManager();
        if (fdObj == null) {
            throw new NullPointerException();
        }
        if (security != null) {
            security.checkRead(fdObj);
        }
        this.fd = fdObj;
        this.path = null;
        this.fd.attach(this);
    }

    private native void open0(String var1) throws FileNotFoundException;

    private void open(String name) throws FileNotFoundException {
        this.open0(name);
    }

    @Override
    public int read() throws IOException {
        return this.read0();
    }

    private native int read0() throws IOException;

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public int read(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.readBytes(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.skip0(n);
    }

    private native long skip0(long var1) throws IOException;

    @Override
    public int available() throws IOException {
        return this.available0();
    }

    private native int available0() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.channel != null) {
            this.channel.close();
        }
        this.fd.closeAll(new Closeable(){

            @Override
            public void close() throws IOException {
                FileInputStream.this.close0();
            }
        });
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, this.path, true, false, this);
            }
            return this.channel;
        }
    }

    private static native void initIDs();

    private native void close0() throws IOException;

    protected void finalize() throws IOException {
        if (this.fd != null && this.fd != FileDescriptor.in) {
            this.close();
        }
    }

    static {
        FileInputStream.initIDs();
    }
}

