/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.DistributionPointName;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.ReasonFlags;

public class IssuingDistributionPointExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.IssuingDistributionPoint";
    public static final String NAME = "IssuingDistributionPoint";
    public static final String POINT = "point";
    public static final String REASONS = "reasons";
    public static final String ONLY_USER_CERTS = "only_user_certs";
    public static final String ONLY_CA_CERTS = "only_ca_certs";
    public static final String ONLY_ATTRIBUTE_CERTS = "only_attribute_certs";
    public static final String INDIRECT_CRL = "indirect_crl";
    private DistributionPointName distributionPoint = null;
    private ReasonFlags revocationReasons = null;
    private boolean hasOnlyUserCerts = false;
    private boolean hasOnlyCACerts = false;
    private boolean hasOnlyAttributeCerts = false;
    private boolean isIndirectCRL = false;
    private static final byte TAG_DISTRIBUTION_POINT = 0;
    private static final byte TAG_ONLY_USER_CERTS = 1;
    private static final byte TAG_ONLY_CA_CERTS = 2;
    private static final byte TAG_ONLY_SOME_REASONS = 3;
    private static final byte TAG_INDIRECT_CRL = 4;
    private static final byte TAG_ONLY_ATTRIBUTE_CERTS = 5;

    public IssuingDistributionPointExtension(DistributionPointName distributionPoint, ReasonFlags revocationReasons, boolean hasOnlyUserCerts, boolean hasOnlyCACerts, boolean hasOnlyAttributeCerts, boolean isIndirectCRL) throws IOException {
        if (hasOnlyUserCerts && (hasOnlyCACerts || hasOnlyAttributeCerts) || hasOnlyCACerts && (hasOnlyUserCerts || hasOnlyAttributeCerts) || hasOnlyAttributeCerts && (hasOnlyUserCerts || hasOnlyCACerts)) {
            throw new IllegalArgumentException("Only one of hasOnlyUserCerts, hasOnlyCACerts, hasOnlyAttributeCerts may be set to true");
        }
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = true;
        this.distributionPoint = distributionPoint;
        this.revocationReasons = revocationReasons;
        this.hasOnlyUserCerts = hasOnlyUserCerts;
        this.hasOnlyCACerts = hasOnlyCACerts;
        this.hasOnlyAttributeCerts = hasOnlyAttributeCerts;
        this.isIndirectCRL = isIndirectCRL;
        this.encodeThis();
    }

    public IssuingDistributionPointExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for IssuingDistributionPointExtension.");
        }
        if (val.data == null || val.data.available() == 0) {
            return;
        }
        DerInputStream in = val.data;
        while (in != null && in.available() != 0) {
            DerValue opt = in.getDerValue();
            if (opt.isContextSpecific((byte)0) && opt.isConstructed()) {
                this.distributionPoint = new DistributionPointName(opt.data.getDerValue());
                continue;
            }
            if (opt.isContextSpecific((byte)1) && !opt.isConstructed()) {
                opt.resetTag((byte)1);
                this.hasOnlyUserCerts = opt.getBoolean();
                continue;
            }
            if (opt.isContextSpecific((byte)2) && !opt.isConstructed()) {
                opt.resetTag((byte)1);
                this.hasOnlyCACerts = opt.getBoolean();
                continue;
            }
            if (opt.isContextSpecific((byte)3) && !opt.isConstructed()) {
                this.revocationReasons = new ReasonFlags(opt);
                continue;
            }
            if (opt.isContextSpecific((byte)4) && !opt.isConstructed()) {
                opt.resetTag((byte)1);
                this.isIndirectCRL = opt.getBoolean();
                continue;
            }
            if (opt.isContextSpecific((byte)5) && !opt.isConstructed()) {
                opt.resetTag((byte)1);
                this.hasOnlyAttributeCerts = opt.getBoolean();
                continue;
            }
            throw new IOException("Invalid encoding of IssuingDistributionPoint");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (name.equalsIgnoreCase(POINT)) {
            if (!(obj instanceof DistributionPointName)) {
                throw new IOException("Attribute value should be of type DistributionPointName.");
            }
            this.distributionPoint = (DistributionPointName)obj;
        } else if (name.equalsIgnoreCase(REASONS)) {
            if (!(obj instanceof ReasonFlags)) {
                throw new IOException("Attribute value should be of type ReasonFlags.");
            }
            this.revocationReasons = (ReasonFlags)obj;
        } else if (name.equalsIgnoreCase(INDIRECT_CRL)) {
            if (!(obj instanceof Boolean)) {
                throw new IOException("Attribute value should be of type Boolean.");
            }
            this.isIndirectCRL = (Boolean)obj;
        } else if (name.equalsIgnoreCase(ONLY_USER_CERTS)) {
            if (!(obj instanceof Boolean)) {
                throw new IOException("Attribute value should be of type Boolean.");
            }
            this.hasOnlyUserCerts = (Boolean)obj;
        } else if (name.equalsIgnoreCase(ONLY_CA_CERTS)) {
            if (!(obj instanceof Boolean)) {
                throw new IOException("Attribute value should be of type Boolean.");
            }
            this.hasOnlyCACerts = (Boolean)obj;
        } else if (name.equalsIgnoreCase(ONLY_ATTRIBUTE_CERTS)) {
            if (!(obj instanceof Boolean)) {
                throw new IOException("Attribute value should be of type Boolean.");
            }
            this.hasOnlyAttributeCerts = (Boolean)obj;
        } else {
            throw new IOException("Attribute name [" + name + "] not recognized by CertAttrSet:IssuingDistributionPointExtension.");
        }
        this.encodeThis();
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(POINT)) {
            return this.distributionPoint;
        }
        if (name.equalsIgnoreCase(INDIRECT_CRL)) {
            return this.isIndirectCRL;
        }
        if (name.equalsIgnoreCase(REASONS)) {
            return this.revocationReasons;
        }
        if (name.equalsIgnoreCase(ONLY_USER_CERTS)) {
            return this.hasOnlyUserCerts;
        }
        if (name.equalsIgnoreCase(ONLY_CA_CERTS)) {
            return this.hasOnlyCACerts;
        }
        if (name.equalsIgnoreCase(ONLY_ATTRIBUTE_CERTS)) {
            return this.hasOnlyAttributeCerts;
        }
        throw new IOException("Attribute name [" + name + "] not recognized by CertAttrSet:IssuingDistributionPointExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (name.equalsIgnoreCase(POINT)) {
            this.distributionPoint = null;
        } else if (name.equalsIgnoreCase(INDIRECT_CRL)) {
            this.isIndirectCRL = false;
        } else if (name.equalsIgnoreCase(REASONS)) {
            this.revocationReasons = null;
        } else if (name.equalsIgnoreCase(ONLY_USER_CERTS)) {
            this.hasOnlyUserCerts = false;
        } else if (name.equalsIgnoreCase(ONLY_CA_CERTS)) {
            this.hasOnlyCACerts = false;
        } else if (name.equalsIgnoreCase(ONLY_ATTRIBUTE_CERTS)) {
            this.hasOnlyAttributeCerts = false;
        } else {
            throw new IOException("Attribute name [" + name + "] not recognized by CertAttrSet:IssuingDistributionPointExtension.");
        }
        this.encodeThis();
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(POINT);
        elements.addElement(REASONS);
        elements.addElement(ONLY_USER_CERTS);
        elements.addElement(ONLY_CA_CERTS);
        elements.addElement(ONLY_ATTRIBUTE_CERTS);
        elements.addElement(INDIRECT_CRL);
        return elements.elements();
    }

    private void encodeThis() throws IOException {
        DerOutputStream tmp;
        if (!(this.distributionPoint != null || this.revocationReasons != null || this.hasOnlyUserCerts || this.hasOnlyCACerts || this.hasOnlyAttributeCerts || this.isIndirectCRL)) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream tagged = new DerOutputStream();
        if (this.distributionPoint != null) {
            tmp = new DerOutputStream();
            this.distributionPoint.encode(tmp);
            tagged.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), tmp);
        }
        if (this.hasOnlyUserCerts) {
            tmp = new DerOutputStream();
            tmp.putBoolean(this.hasOnlyUserCerts);
            tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), tmp);
        }
        if (this.hasOnlyCACerts) {
            tmp = new DerOutputStream();
            tmp.putBoolean(this.hasOnlyCACerts);
            tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)2), tmp);
        }
        if (this.revocationReasons != null) {
            tmp = new DerOutputStream();
            this.revocationReasons.encode(tmp);
            tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)3), tmp);
        }
        if (this.isIndirectCRL) {
            tmp = new DerOutputStream();
            tmp.putBoolean(this.isIndirectCRL);
            tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)4), tmp);
        }
        if (this.hasOnlyAttributeCerts) {
            tmp = new DerOutputStream();
            tmp.putBoolean(this.hasOnlyAttributeCerts);
            tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)5), tmp);
        }
        DerOutputStream seq = new DerOutputStream();
        seq.write((byte)48, tagged);
        this.extensionValue = seq.toByteArray();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("IssuingDistributionPoint [\n  ");
        if (this.distributionPoint != null) {
            sb.append(this.distributionPoint);
        }
        if (this.revocationReasons != null) {
            sb.append(this.revocationReasons);
        }
        sb.append(this.hasOnlyUserCerts ? "  Only contains user certs: true" : "  Only contains user certs: false").append("\n");
        sb.append(this.hasOnlyCACerts ? "  Only contains CA certs: true" : "  Only contains CA certs: false").append("\n");
        sb.append(this.hasOnlyAttributeCerts ? "  Only contains attribute certs: true" : "  Only contains attribute certs: false").append("\n");
        sb.append(this.isIndirectCRL ? "  Indirect CRL: true" : "  Indirect CRL: false").append("\n");
        sb.append("]\n");
        return sb.toString();
    }
}

