/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import com.sun.security.jgss.AuthorizationDataEntry;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import org.ietf.jgss.GSSException;
import sun.security.action.GetPropertyAction;
import sun.security.jgss.krb5.InitialToken;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.KerberosTime;
import sun.security.util.DerValue;

class InitSecContextToken
extends InitialToken {
    private static final boolean ACCEPTOR_USE_INITIATOR_SEQNUM;
    private KrbApReq apReq = null;

    InitSecContextToken(Krb5Context context, Credentials tgt, Credentials serviceTicket) throws KrbException, IOException, GSSException {
        boolean mutualRequired = context.getMutualAuthState();
        boolean useSubkey = true;
        boolean useSequenceNumber = true;
        InitialToken.OverloadedChecksum gssChecksum = new InitialToken.OverloadedChecksum(this, context, tgt, serviceTicket);
        Checksum checksum = gssChecksum.getChecksum();
        context.setTktFlags(serviceTicket.getFlags());
        context.setAuthTime(new KerberosTime(serviceTicket.getAuthTime()).toString());
        this.apReq = new KrbApReq(serviceTicket, mutualRequired, useSubkey, useSequenceNumber, checksum);
        context.resetMySequenceNumber(this.apReq.getSeqNumber());
        EncryptionKey subKey = this.apReq.getSubKey();
        if (subKey != null) {
            context.setKey(1, subKey);
        } else {
            context.setKey(0, serviceTicket.getSessionKey());
        }
        if (!mutualRequired) {
            context.resetPeerSequenceNumber(ACCEPTOR_USE_INITIATOR_SEQNUM ? this.apReq.getSeqNumber() : 0);
        }
    }

    InitSecContextToken(Krb5Context context, Krb5AcceptCredential cred, InputStream is) throws IOException, GSSException, KrbException {
        Integer apReqSeqNumber;
        int tokenId = is.read() << 8 | is.read();
        if (tokenId != 256) {
            throw new GSSException(10, -1, "AP_REQ token id does not match!");
        }
        byte[] apReqBytes = new DerValue(is).toByteArray();
        InetAddress addr = null;
        if (context.getChannelBinding() != null) {
            addr = context.getChannelBinding().getInitiatorAddress();
        }
        this.apReq = new KrbApReq(apReqBytes, cred, addr);
        EncryptionKey sessionKey = this.apReq.getCreds().getSessionKey();
        EncryptionKey subKey = this.apReq.getSubKey();
        if (subKey != null) {
            context.setKey(1, subKey);
        } else {
            context.setKey(0, sessionKey);
        }
        InitialToken.OverloadedChecksum gssChecksum = new InitialToken.OverloadedChecksum(this, context, this.apReq.getChecksum(), sessionKey, subKey);
        gssChecksum.setContextFlags(context);
        Credentials delegCred = gssChecksum.getDelegatedCreds();
        if (delegCred != null) {
            Krb5InitCredential credElement = Krb5InitCredential.getInstance((Krb5NameElement)context.getSrcName(), delegCred);
            context.setDelegCred(credElement);
        }
        int peerSeqNumber = (apReqSeqNumber = this.apReq.getSeqNumber()) != null ? apReqSeqNumber : 0;
        context.resetPeerSequenceNumber(peerSeqNumber);
        if (!context.getMutualAuthState()) {
            context.resetMySequenceNumber(ACCEPTOR_USE_INITIATOR_SEQNUM ? peerSeqNumber : 0);
        }
        context.setAuthTime(new KerberosTime(this.apReq.getCreds().getAuthTime()).toString());
        context.setTktFlags(this.apReq.getCreds().getFlags());
        AuthorizationData ad = this.apReq.getCreds().getAuthzData();
        if (ad == null) {
            context.setAuthzData(null);
        } else {
            AuthorizationDataEntry[] authzData = new AuthorizationDataEntry[ad.count()];
            for (int i = 0; i < ad.count(); ++i) {
                authzData[i] = new AuthorizationDataEntry(ad.item((int)i).adType, ad.item((int)i).adData);
            }
            context.setAuthzData(authzData);
        }
    }

    public final KrbApReq getKrbApReq() {
        return this.apReq;
    }

    @Override
    public final byte[] encode() throws IOException {
        byte[] apReqBytes = this.apReq.getMessage();
        byte[] retVal = new byte[2 + apReqBytes.length];
        InitSecContextToken.writeInt(256, retVal, 0);
        System.arraycopy(apReqBytes, 0, retVal, 2, apReqBytes.length);
        return retVal;
    }

    static {
        String propName = "sun.security.krb5.acceptor.sequence.number.nonmutual";
        String s = GetPropertyAction.privilegedGetProperty(propName, "initiator");
        if (s.equals("initiator")) {
            ACCEPTOR_USE_INITIATOR_SEQNUM = true;
        } else if (s.equals("zero") || s.equals("0")) {
            ACCEPTOR_USE_INITIATOR_SEQNUM = false;
        } else {
            throw new AssertionError((Object)("Unrecognized value for " + propName + ": " + s));
        }
    }
}

