/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.SortKey;

public final class SortControl
extends BasicControl {
    public static final String OID = "1.2.840.113556.1.4.473";
    private static final long serialVersionUID = -1965961680233330744L;

    public SortControl(String sortBy, boolean criticality) throws IOException {
        super(OID, criticality, null);
        this.value = this.setEncodedValue(new SortKey[]{new SortKey(sortBy)});
    }

    public SortControl(String[] sortBy, boolean criticality) throws IOException {
        super(OID, criticality, null);
        SortKey[] sortKeys = new SortKey[sortBy.length];
        for (int i = 0; i < sortBy.length; ++i) {
            sortKeys[i] = new SortKey(sortBy[i]);
        }
        this.value = this.setEncodedValue(sortKeys);
    }

    public SortControl(SortKey[] sortBy, boolean criticality) throws IOException {
        super(OID, criticality, null);
        this.value = this.setEncodedValue(sortBy);
    }

    private byte[] setEncodedValue(SortKey[] sortKeys) throws IOException {
        BerEncoder ber = new BerEncoder(30 * sortKeys.length + 10);
        ber.beginSeq(48);
        for (int i = 0; i < sortKeys.length; ++i) {
            ber.beginSeq(48);
            ber.encodeString(sortKeys[i].getAttributeID(), true);
            String matchingRule = sortKeys[i].getMatchingRuleID();
            if (matchingRule != null) {
                ber.encodeString(matchingRule, 128, true);
            }
            if (!sortKeys[i].isAscending()) {
                ber.encodeBoolean(true, 129);
            }
            ber.endSeq();
        }
        ber.endSeq();
        return ber.getTrimmedBuf();
    }
}

