/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.rmi;

import com.sun.jndi.url.rmi.rmiURLContext;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;

public class rmiURLContextFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object urlInfo, Name name, Context nameCtx, Hashtable<?, ?> env) throws NamingException {
        if (urlInfo == null) {
            return new rmiURLContext(env);
        }
        if (urlInfo instanceof String) {
            return rmiURLContextFactory.getUsingURL((String)urlInfo, env);
        }
        if (urlInfo instanceof String[]) {
            return rmiURLContextFactory.getUsingURLs((String[])urlInfo, env);
        }
        throw new ConfigurationException("rmiURLContextFactory.getObjectInstance: argument must be an RMI URL String or an array of them");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getUsingURL(String url, Hashtable<?, ?> env) throws NamingException {
        try (rmiURLContext urlCtx = new rmiURLContext(env);){
            Object object = urlCtx.lookup(url);
            return object;
        }
    }

    private static Object getUsingURLs(String[] urls, Hashtable<?, ?> env) throws NamingException {
        if (urls.length == 0) {
            throw new ConfigurationException("rmiURLContextFactory: empty URL array");
        }
        try (rmiURLContext urlCtx = new rmiURLContext(env);){
            NamingException ne = null;
            for (int i = 0; i < urls.length; ++i) {
                try {
                    Object object = urlCtx.lookup(urls[i]);
                    return object;
                }
                catch (NamingException e) {
                    ne = e;
                    continue;
                }
            }
            throw ne;
        }
    }
}

