/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.stream.Stream;
import jdk.internal.platform.CgroupSubsystemController;

public final class CgroupUtil {
    public static Stream<String> readFilePrivileged(Path path) throws IOException {
        try {
            PrivilegedExceptionAction<Stream> pea = () -> Files.lines(path);
            return AccessController.doPrivileged(pea);
        }
        catch (PrivilegedActionException e) {
            CgroupUtil.unwrapIOExceptionAndRethrow(e);
            throw new InternalError(e.getCause());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    static void unwrapIOExceptionAndRethrow(PrivilegedActionException pae) throws IOException {
        Throwable x = pae.getCause();
        if (x instanceof IOException) {
            throw (IOException)x;
        }
        if (x instanceof RuntimeException) {
            throw (RuntimeException)x;
        }
        if (x instanceof Error) {
            throw (Error)x;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readStringValue(CgroupSubsystemController controller, String param) throws IOException {
        PrivilegedExceptionAction<BufferedReader> pea = () -> Files.newBufferedReader(Paths.get(controller.path(), param));
        try (BufferedReader bufferedReader = AccessController.doPrivileged(pea);){
            String line;
            String string = line = bufferedReader.readLine();
            return string;
        }
        catch (PrivilegedActionException e) {
            CgroupUtil.unwrapIOExceptionAndRethrow(e);
            throw new InternalError(e.getCause());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static List<String> readAllLinesPrivileged(Path path) throws IOException {
        try {
            PrivilegedExceptionAction<List> pea = () -> Files.readAllLines(path);
            return AccessController.doPrivileged(pea);
        }
        catch (PrivilegedActionException e) {
            CgroupUtil.unwrapIOExceptionAndRethrow(e);
            throw new InternalError(e.getCause());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }
}

