/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import sun.security.util.Debug;
import sun.security.util.PendingException;
import sun.security.util.ResourcesMgr;

public class LoginContext {
    private static final String INIT_METHOD = "initialize";
    private static final String LOGIN_METHOD = "login";
    private static final String COMMIT_METHOD = "commit";
    private static final String ABORT_METHOD = "abort";
    private static final String LOGOUT_METHOD = "logout";
    private static final String OTHER = "other";
    private static final String DEFAULT_HANDLER = "auth.login.defaultCallbackHandler";
    private Subject subject = null;
    private boolean subjectProvided = false;
    private boolean loginSucceeded = false;
    private CallbackHandler callbackHandler;
    private Map<String, ?> state = new HashMap();
    private Configuration config;
    private AccessControlContext creatorAcc = null;
    private ModuleInfo[] moduleStack;
    private ClassLoader contextClassLoader = null;
    private static final Class<?>[] PARAMS = new Class[0];
    private int moduleIndex = 0;
    private LoginException firstError = null;
    private LoginException firstRequiredError = null;
    private boolean success = false;
    private static final Debug debug = Debug.getInstance("logincontext", "\t[LoginContext]");

    private void init(String name) throws LoginException {
        AppConfigurationEntry[] entries;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && this.creatorAcc == null) {
            sm.checkPermission(new AuthPermission("createLoginContext." + name));
        }
        if (name == null) {
            throw new LoginException(ResourcesMgr.getString("Invalid.null.input.name"));
        }
        if (this.config == null) {
            this.config = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

                @Override
                public Configuration run() {
                    return Configuration.getConfiguration();
                }
            });
        }
        if ((entries = this.config.getAppConfigurationEntry(name)) == null) {
            if (sm != null && this.creatorAcc == null) {
                sm.checkPermission(new AuthPermission("createLoginContext.other"));
            }
            if ((entries = this.config.getAppConfigurationEntry(OTHER)) == null) {
                MessageFormat form = new MessageFormat(ResourcesMgr.getString("No.LoginModules.configured.for.name"));
                Object[] source = new Object[]{name};
                throw new LoginException(form.format(source));
            }
        }
        this.moduleStack = new ModuleInfo[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            this.moduleStack[i] = new ModuleInfo(new AppConfigurationEntry(entries[i].getLoginModuleName(), entries[i].getControlFlag(), entries[i].getOptions()), null);
        }
        this.contextClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                return loader;
            }
        });
    }

    private void loadDefaultCallbackHandler() throws LoginException {
        try {
            final ClassLoader finalLoader = this.contextClassLoader;
            this.callbackHandler = AccessController.doPrivileged(new PrivilegedExceptionAction<CallbackHandler>(){

                @Override
                public CallbackHandler run() throws Exception {
                    String defaultHandler = Security.getProperty(LoginContext.DEFAULT_HANDLER);
                    if (defaultHandler == null || defaultHandler.length() == 0) {
                        return null;
                    }
                    Class<CallbackHandler> c = Class.forName(defaultHandler, true, finalLoader).asSubclass(CallbackHandler.class);
                    return c.newInstance();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new LoginException(pae.getException().toString());
        }
        if (this.callbackHandler != null && this.creatorAcc == null) {
            this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), this.callbackHandler);
        }
    }

    public LoginContext(String name) throws LoginException {
        this.init(name);
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String name, Subject subject) throws LoginException {
        this.init(name);
        if (subject == null) {
            throw new LoginException(ResourcesMgr.getString("invalid.null.Subject.provided"));
        }
        this.subject = subject;
        this.subjectProvided = true;
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String name, CallbackHandler callbackHandler) throws LoginException {
        this.init(name);
        if (callbackHandler == null) {
            throw new LoginException(ResourcesMgr.getString("invalid.null.CallbackHandler.provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public LoginContext(String name, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        this(name, subject);
        if (callbackHandler == null) {
            throw new LoginException(ResourcesMgr.getString("invalid.null.CallbackHandler.provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public LoginContext(String name, Subject subject, CallbackHandler callbackHandler, Configuration config) throws LoginException {
        this.config = config;
        if (config != null) {
            this.creatorAcc = AccessController.getContext();
        }
        this.init(name);
        if (subject != null) {
            this.subject = subject;
            this.subjectProvided = true;
        }
        if (callbackHandler == null) {
            this.loadDefaultCallbackHandler();
        } else {
            this.callbackHandler = this.creatorAcc == null ? new SecureCallbackHandler(AccessController.getContext(), callbackHandler) : callbackHandler;
        }
    }

    public void login() throws LoginException {
        this.loginSucceeded = false;
        if (this.subject == null) {
            this.subject = new Subject();
        }
        try {
            this.invokePriv(LOGIN_METHOD);
            this.invokePriv(COMMIT_METHOD);
            this.loginSucceeded = true;
        }
        catch (LoginException le) {
            try {
                this.invokePriv(ABORT_METHOD);
            }
            catch (LoginException le2) {
                throw le;
            }
            throw le;
        }
    }

    public void logout() throws LoginException {
        if (this.subject == null) {
            throw new LoginException(ResourcesMgr.getString("null.subject.logout.called.before.login"));
        }
        this.invokePriv(LOGOUT_METHOD);
    }

    public Subject getSubject() {
        if (!this.loginSucceeded && !this.subjectProvided) {
            return null;
        }
        return this.subject;
    }

    private void clearState() {
        this.moduleIndex = 0;
        this.firstError = null;
        this.firstRequiredError = null;
        this.success = false;
    }

    private void throwException(LoginException originalError, LoginException le) throws LoginException {
        this.clearState();
        LoginException error = originalError != null ? originalError : le;
        throw error;
    }

    private void invokePriv(final String methodName) throws LoginException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws LoginException {
                    LoginContext.this.invoke(methodName);
                    return null;
                }
            }, this.creatorAcc);
        }
        catch (PrivilegedActionException pae) {
            throw (LoginException)pae.getException();
        }
    }

    private void invoke(String methodName) throws LoginException {
        int i = this.moduleIndex;
        while (i < this.moduleStack.length) {
            block38: {
                try {
                    int mIndex = 0;
                    Method[] methods = null;
                    if (this.moduleStack[i].module != null) {
                        methods = this.moduleStack[i].module.getClass().getMethods();
                    } else {
                        Class<?> c = Class.forName(this.moduleStack[i].entry.getLoginModuleName(), true, this.contextClassLoader);
                        Constructor<?> constructor = c.getConstructor(PARAMS);
                        Object[] args = new Object[]{};
                        this.moduleStack[i].module = constructor.newInstance(args);
                        methods = this.moduleStack[i].module.getClass().getMethods();
                        for (mIndex = 0; mIndex < methods.length && !methods[mIndex].getName().equals(INIT_METHOD); ++mIndex) {
                        }
                        Object[] initArgs = new Object[]{this.subject, this.callbackHandler, this.state, this.moduleStack[i].entry.getOptions()};
                        methods[mIndex].invoke(this.moduleStack[i].module, initArgs);
                    }
                    for (mIndex = 0; mIndex < methods.length && !methods[mIndex].getName().equals(methodName); ++mIndex) {
                    }
                    Object[] args = new Object[0];
                    boolean status = (Boolean)methods[mIndex].invoke(this.moduleStack[i].module, args);
                    if (status) {
                        if (!methodName.equals(ABORT_METHOD) && !methodName.equals(LOGOUT_METHOD) && this.moduleStack[i].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT && this.firstRequiredError == null) {
                            this.clearState();
                            if (debug != null) {
                                debug.println(methodName + " SUFFICIENT success");
                            }
                            return;
                        }
                        if (debug != null) {
                            debug.println(methodName + " success");
                        }
                        this.success = true;
                    } else if (debug != null) {
                        debug.println(methodName + " ignored");
                    }
                }
                catch (NoSuchMethodException nsme) {
                    MessageFormat form = new MessageFormat(ResourcesMgr.getString("unable.to.instantiate.LoginModule.module.because.it.does.not.provide.a.no.argument.constructor"));
                    Object[] source = new Object[]{this.moduleStack[i].entry.getLoginModuleName()};
                    this.throwException(null, new LoginException(form.format(source)));
                }
                catch (InstantiationException ie) {
                    this.throwException(null, new LoginException(ResourcesMgr.getString("unable.to.instantiate.LoginModule.") + ie.getMessage()));
                }
                catch (ClassNotFoundException cnfe) {
                    this.throwException(null, new LoginException(ResourcesMgr.getString("unable.to.find.LoginModule.class.") + cnfe.getMessage()));
                }
                catch (IllegalAccessException iae) {
                    this.throwException(null, new LoginException(ResourcesMgr.getString("unable.to.access.LoginModule.") + iae.getMessage()));
                }
                catch (InvocationTargetException ite) {
                    LoginException le;
                    if (ite.getCause() instanceof PendingException && methodName.equals(LOGIN_METHOD)) {
                        throw (PendingException)ite.getCause();
                    }
                    if (ite.getCause() instanceof LoginException) {
                        le = (LoginException)ite.getCause();
                    } else if (ite.getCause() instanceof SecurityException) {
                        le = new LoginException("Security Exception");
                        le.initCause(new SecurityException());
                        if (debug != null) {
                            debug.println("original security exception with detail msg replaced by new exception with empty detail msg");
                            debug.println("original security exception: " + ite.getCause().toString());
                        }
                    } else {
                        StringWriter sw = new StringWriter();
                        ite.getCause().printStackTrace(new PrintWriter(sw));
                        sw.flush();
                        le = new LoginException(sw.toString());
                    }
                    if (this.moduleStack[i].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                        if (debug != null) {
                            debug.println(methodName + " REQUISITE failure");
                        }
                        if (methodName.equals(ABORT_METHOD) || methodName.equals(LOGOUT_METHOD)) {
                            if (this.firstRequiredError == null) {
                                this.firstRequiredError = le;
                            }
                        } else {
                            this.throwException(this.firstRequiredError, le);
                        }
                    }
                    if (this.moduleStack[i].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                        if (debug != null) {
                            debug.println(methodName + " REQUIRED failure");
                        }
                        if (this.firstRequiredError == null) {
                            this.firstRequiredError = le;
                        }
                    }
                    if (debug != null) {
                        debug.println(methodName + " OPTIONAL failure");
                    }
                    if (this.firstError != null) break block38;
                    this.firstError = le;
                }
            }
            ++i;
            ++this.moduleIndex;
        }
        if (this.firstRequiredError != null) {
            this.throwException(this.firstRequiredError, null);
        } else if (!this.success && this.firstError != null) {
            this.throwException(this.firstError, null);
        } else if (!this.success) {
            this.throwException(new LoginException(ResourcesMgr.getString("Login.Failure.all.modules.ignored")), null);
        } else {
            this.clearState();
            return;
        }
    }

    private static class ModuleInfo {
        AppConfigurationEntry entry;
        Object module;

        ModuleInfo(AppConfigurationEntry newEntry, Object newModule) {
            this.entry = newEntry;
            this.module = newModule;
        }
    }

    private static class SecureCallbackHandler
    implements CallbackHandler {
        private final AccessControlContext acc;
        private final CallbackHandler ch;

        SecureCallbackHandler(AccessControlContext acc, CallbackHandler ch) {
            this.acc = acc;
            this.ch = ch;
        }

        @Override
        public void handle(final Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, UnsupportedCallbackException {
                        ch.handle(callbacks);
                        return null;
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException pae) {
                if (pae.getException() instanceof IOException) {
                    throw (IOException)pae.getException();
                }
                throw (UnsupportedCallbackException)pae.getException();
            }
        }
    }
}

