/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.spec.DHParameterSpec;
import javax.net.ssl.SSLProtocolException;
import sun.security.action.GetPropertyAction;
import sun.security.ssl.Alert;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.PredefinedDHParameterSpecs;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SunJSSE;
import sun.security.ssl.Utilities;

final class SupportedGroupsExtension {
    static final HandshakeProducer chNetworkProducer = new CHSupportedGroupsProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHSupportedGroupsConsumer();
    static final SSLStringizer sgsStringizer = new SupportedGroupsStringizer();
    static final HandshakeProducer eeNetworkProducer = new EESupportedGroupsProducer();
    static final SSLExtension.ExtensionConsumer eeOnLoadConsumer = new EESupportedGroupsConsumer();

    SupportedGroupsExtension() {
    }

    private static final class EESupportedGroupsConsumer
    implements SSLExtension.ExtensionConsumer {
        private EESupportedGroupsConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message, ByteBuffer buffer) throws IOException {
            SupportedGroupsSpec spec;
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            if (!chc.sslConfig.isAvailable(SSLExtension.EE_SUPPORTED_GROUPS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable supported_groups extension", new Object[0]);
                }
                return;
            }
            try {
                spec = new SupportedGroupsSpec(buffer);
            }
            catch (IOException ioe) {
                throw chc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, ioe);
            }
            ArrayList<NamedGroup> knownNamedGroups = new ArrayList<NamedGroup>(spec.namedGroupsIds.length);
            for (int id : spec.namedGroupsIds) {
                NamedGroup ng = NamedGroup.valueOf(id);
                if (ng == null) continue;
                knownNamedGroups.add(ng);
            }
            chc.conContext.serverRequestedNamedGroups = knownNamedGroups;
            chc.handshakeExtensions.put(SSLExtension.EE_SUPPORTED_GROUPS, spec);
        }
    }

    private static final class EESupportedGroupsProducer
    extends SupportedGroups
    implements HandshakeProducer {
        private EESupportedGroupsProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            if (!shc.sslConfig.isAvailable(SSLExtension.EE_SUPPORTED_GROUPS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable supported_groups extension", new Object[0]);
                }
                return null;
            }
            ArrayList<Object> namedGroups = new ArrayList<Object>(SupportedGroups.supportedNamedGroups.length);
            for (NamedGroup ng : SupportedGroups.supportedNamedGroups) {
                if (!SupportedGroups.enableFFDHE && ng.type == NamedGroupType.NAMED_GROUP_FFDHE) continue;
                if (ng.isAvailable(shc.activeProtocols) && ng.isSupported(shc.activeCipherSuites) && shc.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), ng.algorithm, (AlgorithmParameters)namedGroupParams.get((Object)ng))) {
                    namedGroups.add((Object)ng);
                    continue;
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.fine("Ignore inactive or disabled named group: " + ng.name, new Object[0]);
            }
            if (namedGroups.isEmpty()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("no available named group", new Object[0]);
                }
                return null;
            }
            int vectorLen = namedGroups.size() << 1;
            byte[] extData = new byte[vectorLen + 2];
            ByteBuffer m = ByteBuffer.wrap(extData);
            Record.putInt16(m, vectorLen);
            for (NamedGroup namedGroup : namedGroups) {
                Record.putInt16(m, namedGroup.id);
            }
            shc.conContext.serverRequestedNamedGroups = Collections.unmodifiableList(namedGroups);
            SupportedGroupsSpec spec = new SupportedGroupsSpec(namedGroups);
            shc.handshakeExtensions.put(SSLExtension.EE_SUPPORTED_GROUPS, spec);
            return extData;
        }
    }

    private static final class CHSupportedGroupsConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHSupportedGroupsConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, SSLHandshake.HandshakeMessage message, ByteBuffer buffer) throws IOException {
            SupportedGroupsSpec spec;
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            if (!shc.sslConfig.isAvailable(SSLExtension.CH_SUPPORTED_GROUPS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable supported_groups extension", new Object[0]);
                }
                return;
            }
            try {
                spec = new SupportedGroupsSpec(buffer);
            }
            catch (IOException ioe) {
                throw shc.conContext.fatal(Alert.UNEXPECTED_MESSAGE, ioe);
            }
            LinkedList<NamedGroup> knownNamedGroups = new LinkedList<NamedGroup>();
            for (int id : spec.namedGroupsIds) {
                NamedGroup ng = NamedGroup.valueOf(id);
                if (ng == null) continue;
                knownNamedGroups.add(ng);
            }
            shc.clientRequestedNamedGroups = knownNamedGroups;
            shc.handshakeExtensions.put(SSLExtension.CH_SUPPORTED_GROUPS, spec);
        }
    }

    private static final class CHSupportedGroupsProducer
    extends SupportedGroups
    implements HandshakeProducer {
        private CHSupportedGroupsProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            if (!chc.sslConfig.isAvailable(SSLExtension.CH_SUPPORTED_GROUPS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable supported_groups extension", new Object[0]);
                }
                return null;
            }
            ArrayList<NamedGroup> namedGroups = new ArrayList<NamedGroup>(SupportedGroups.supportedNamedGroups.length);
            for (NamedGroup ng : SupportedGroups.supportedNamedGroups) {
                if (!SupportedGroups.enableFFDHE && ng.type == NamedGroupType.NAMED_GROUP_FFDHE) continue;
                if (ng.isAvailable(chc.activeProtocols) && ng.isSupported(chc.activeCipherSuites) && chc.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), ng.algorithm, (AlgorithmParameters)namedGroupParams.get((Object)ng))) {
                    namedGroups.add(ng);
                    continue;
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) continue;
                SSLLogger.fine("Ignore inactive or disabled named group: " + ng.name, new Object[0]);
            }
            if (namedGroups.isEmpty()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("no available named group", new Object[0]);
                }
                return null;
            }
            int vectorLen = namedGroups.size() << 1;
            byte[] extData = new byte[vectorLen + 2];
            ByteBuffer m = ByteBuffer.wrap(extData);
            Record.putInt16(m, vectorLen);
            for (NamedGroup namedGroup : namedGroups) {
                Record.putInt16(m, namedGroup.id);
            }
            chc.clientRequestedNamedGroups = Collections.unmodifiableList(namedGroups);
            chc.handshakeExtensions.put(SSLExtension.CH_SUPPORTED_GROUPS, new SupportedGroupsSpec(namedGroups));
            return extData;
        }
    }

    static class SupportedGroups {
        static final boolean enableFFDHE;
        static final Map<NamedGroup, AlgorithmParameters> namedGroupParams;
        static final NamedGroup[] supportedNamedGroups;

        SupportedGroups() {
        }

        private static boolean isAvailableGroup(NamedGroup namedGroup) {
            AlgorithmParameters params = null;
            AlgorithmParameterSpec spec = null;
            if (namedGroup.type == NamedGroupType.NAMED_GROUP_ECDHE) {
                if (namedGroup.oid != null) {
                    try {
                        params = JsseJce.getAlgorithmParameters("EC");
                        spec = new ECGenParameterSpec(namedGroup.oid);
                    }
                    catch (NoSuchAlgorithmException e) {
                        return false;
                    }
                }
            } else if (namedGroup.type == NamedGroupType.NAMED_GROUP_FFDHE) {
                try {
                    params = JsseJce.getAlgorithmParameters("DiffieHellman");
                    spec = SupportedGroups.getFFDHEDHParameterSpec(namedGroup);
                }
                catch (NoSuchAlgorithmException e) {
                    return false;
                }
            }
            if (params != null && spec != null) {
                try {
                    params.init(spec);
                }
                catch (InvalidParameterSpecException e) {
                    return false;
                }
                namedGroupParams.put(namedGroup, params);
                return true;
            }
            return false;
        }

        private static DHParameterSpec getFFDHEDHParameterSpec(NamedGroup namedGroup) {
            DHParameterSpec spec = null;
            switch (namedGroup) {
                case FFDHE_2048: {
                    spec = PredefinedDHParameterSpecs.ffdheParams.get(2048);
                    break;
                }
                case FFDHE_3072: {
                    spec = PredefinedDHParameterSpecs.ffdheParams.get(3072);
                    break;
                }
                case FFDHE_4096: {
                    spec = PredefinedDHParameterSpecs.ffdheParams.get(4096);
                    break;
                }
                case FFDHE_6144: {
                    spec = PredefinedDHParameterSpecs.ffdheParams.get(6144);
                    break;
                }
                case FFDHE_8192: {
                    spec = PredefinedDHParameterSpecs.ffdheParams.get(8192);
                }
            }
            return spec;
        }

        private static DHParameterSpec getPredefinedDHParameterSpec(NamedGroup namedGroup) {
            DHParameterSpec spec = null;
            switch (namedGroup) {
                case FFDHE_2048: {
                    spec = PredefinedDHParameterSpecs.definedParams.get(2048);
                    break;
                }
                case FFDHE_3072: {
                    spec = PredefinedDHParameterSpecs.definedParams.get(3072);
                    break;
                }
                case FFDHE_4096: {
                    spec = PredefinedDHParameterSpecs.definedParams.get(4096);
                    break;
                }
                case FFDHE_6144: {
                    spec = PredefinedDHParameterSpecs.definedParams.get(6144);
                    break;
                }
                case FFDHE_8192: {
                    spec = PredefinedDHParameterSpecs.definedParams.get(8192);
                }
            }
            return spec;
        }

        static ECGenParameterSpec getECGenParamSpec(NamedGroup namedGroup) {
            if (namedGroup.type != NamedGroupType.NAMED_GROUP_ECDHE) {
                throw new RuntimeException("Not a named EC group: " + (Object)((Object)namedGroup));
            }
            AlgorithmParameters params = namedGroupParams.get((Object)namedGroup);
            if (params == null) {
                throw new RuntimeException("Not a supported EC named group: " + (Object)((Object)namedGroup));
            }
            try {
                return params.getParameterSpec(ECGenParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                return new ECGenParameterSpec(namedGroup.oid);
            }
        }

        static DHParameterSpec getDHParameterSpec(NamedGroup namedGroup) {
            if (namedGroup.type != NamedGroupType.NAMED_GROUP_FFDHE) {
                throw new RuntimeException("Not a named DH group: " + (Object)((Object)namedGroup));
            }
            AlgorithmParameters params = namedGroupParams.get((Object)namedGroup);
            if (params == null) {
                throw new RuntimeException("Not a supported DH named group: " + (Object)((Object)namedGroup));
            }
            try {
                return params.getParameterSpec(DHParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                return SupportedGroups.getPredefinedDHParameterSpec(namedGroup);
            }
        }

        static boolean isActivatable(AlgorithmConstraints constraints, NamedGroupType type) {
            boolean hasFFDHEGroups = false;
            for (NamedGroup namedGroup : supportedNamedGroups) {
                if (namedGroup.type != type) continue;
                if (constraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroup.algorithm, namedGroupParams.get((Object)namedGroup))) {
                    return true;
                }
                if (hasFFDHEGroups || type != NamedGroupType.NAMED_GROUP_FFDHE) continue;
                hasFFDHEGroups = true;
            }
            return !hasFFDHEGroups && type == NamedGroupType.NAMED_GROUP_FFDHE;
        }

        static boolean isActivatable(AlgorithmConstraints constraints, NamedGroup namedGroup) {
            if (!SupportedGroups.isSupported(namedGroup)) {
                return false;
            }
            return constraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroup.algorithm, namedGroupParams.get((Object)namedGroup));
        }

        static boolean isSupported(NamedGroup namedGroup) {
            for (NamedGroup group : supportedNamedGroups) {
                if (namedGroup.id != group.id) continue;
                return true;
            }
            return false;
        }

        static NamedGroup getPreferredGroup(ProtocolVersion negotiatedProtocol, AlgorithmConstraints constraints, NamedGroupType type, List<NamedGroup> requestedNamedGroups) {
            for (NamedGroup namedGroup : requestedNamedGroups) {
                if (namedGroup.type != type || !namedGroup.isAvailable(negotiatedProtocol) || !SupportedGroups.isSupported(namedGroup) || !constraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroup.algorithm, namedGroupParams.get((Object)namedGroup))) continue;
                return namedGroup;
            }
            return null;
        }

        static NamedGroup getPreferredGroup(ProtocolVersion negotiatedProtocol, AlgorithmConstraints constraints, NamedGroupType type) {
            for (NamedGroup namedGroup : supportedNamedGroups) {
                if (namedGroup.type != type || !namedGroup.isAvailable(negotiatedProtocol) || !constraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), namedGroup.algorithm, namedGroupParams.get((Object)namedGroup))) continue;
                return namedGroup;
            }
            return null;
        }

        static {
            ArrayList<Object> groupList;
            Object[] groups;
            enableFFDHE = Utilities.getBooleanProperty("jsse.enableFFDHE", true);
            namedGroupParams = new HashMap<NamedGroup, AlgorithmParameters>();
            boolean requireFips = SunJSSE.isFIPS();
            String property = GetPropertyAction.privilegedGetProperty("jdk.tls.namedGroups");
            if (property != null && !property.isEmpty() && property.length() > 1 && property.charAt(0) == '\"' && property.charAt(property.length() - 1) == '\"') {
                property = property.substring(1, property.length() - 1);
            }
            if (property != null && !property.isEmpty()) {
                groups = property.split(",");
                groupList = new ArrayList<Object>(groups.length);
                for (String string : groups) {
                    NamedGroup namedGroup;
                    String string2 = string.trim();
                    if (string2.isEmpty() || (namedGroup = NamedGroup.nameOf(string2)) == null || requireFips && !namedGroup.isFips || !SupportedGroups.isAvailableGroup(namedGroup)) continue;
                    groupList.add((Object)namedGroup);
                }
                if (groupList.isEmpty()) {
                    throw new IllegalArgumentException("System property jdk.tls.namedGroups(" + property + ") contains no supported named groups");
                }
            } else {
                groups = requireFips ? new NamedGroup[]{NamedGroup.SECP256_R1, NamedGroup.SECP384_R1, NamedGroup.SECP521_R1, NamedGroup.FFDHE_2048, NamedGroup.FFDHE_3072, NamedGroup.FFDHE_4096, NamedGroup.FFDHE_6144, NamedGroup.FFDHE_8192} : new NamedGroup[]{NamedGroup.SECP256_R1, NamedGroup.SECP384_R1, NamedGroup.SECP521_R1, NamedGroup.FFDHE_2048, NamedGroup.FFDHE_3072, NamedGroup.FFDHE_4096, NamedGroup.FFDHE_6144, NamedGroup.FFDHE_8192};
                groupList = new ArrayList(groups.length);
                for (String string : groups) {
                    if (!SupportedGroups.isAvailableGroup((NamedGroup)((Object)string))) continue;
                    groupList.add(string);
                }
                if (groupList.isEmpty() && SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.warning("No default named groups", new Object[0]);
                }
            }
            supportedNamedGroups = new NamedGroup[groupList.size()];
            int i = 0;
            for (NamedGroup namedGroup : groupList) {
                SupportedGroups.supportedNamedGroups[i++] = namedGroup;
            }
        }
    }

    static enum NamedGroup {
        SECT163_K1(1, "sect163k1", "1.3.132.0.1", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT163_R1(2, "sect163r1", "1.3.132.0.2", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECT163_R2(3, "sect163r2", "1.3.132.0.15", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT193_R1(4, "sect193r1", "1.3.132.0.24", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECT193_R2(5, "sect193r2", "1.3.132.0.25", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECT233_K1(6, "sect233k1", "1.3.132.0.26", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT233_R1(7, "sect233r1", "1.3.132.0.27", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT239_K1(8, "sect239k1", "1.3.132.0.3", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECT283_K1(9, "sect283k1", "1.3.132.0.16", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT283_R1(10, "sect283r1", "1.3.132.0.17", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT409_K1(11, "sect409k1", "1.3.132.0.36", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT409_R1(12, "sect409r1", "1.3.132.0.37", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT571_K1(13, "sect571k1", "1.3.132.0.38", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECT571_R1(14, "sect571r1", "1.3.132.0.39", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECP160_K1(15, "secp160k1", "1.3.132.0.9", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECP160_R1(16, "secp160r1", "1.3.132.0.8", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECP160_R2(17, "secp160r2", "1.3.132.0.30", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECP192_K1(18, "secp192k1", "1.3.132.0.31", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECP192_R1(19, "secp192r1", "1.2.840.10045.3.1.1", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECP224_K1(20, "secp224k1", "1.3.132.0.32", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECP224_R1(21, "secp224r1", "1.3.132.0.33", true, ProtocolVersion.PROTOCOLS_TO_12),
        SECP256_K1(22, "secp256k1", "1.3.132.0.10", false, ProtocolVersion.PROTOCOLS_TO_12),
        SECP256_R1(23, "secp256r1", "1.2.840.10045.3.1.7", true, ProtocolVersion.PROTOCOLS_TO_13),
        SECP384_R1(24, "secp384r1", "1.3.132.0.34", true, ProtocolVersion.PROTOCOLS_TO_13),
        SECP521_R1(25, "secp521r1", "1.3.132.0.35", true, ProtocolVersion.PROTOCOLS_TO_13),
        X25519(29, "x25519", true, "x25519", ProtocolVersion.PROTOCOLS_TO_13),
        X448(30, "x448", true, "x448", ProtocolVersion.PROTOCOLS_TO_13),
        FFDHE_2048(256, "ffdhe2048", true, ProtocolVersion.PROTOCOLS_TO_13),
        FFDHE_3072(257, "ffdhe3072", true, ProtocolVersion.PROTOCOLS_TO_13),
        FFDHE_4096(258, "ffdhe4096", true, ProtocolVersion.PROTOCOLS_TO_13),
        FFDHE_6144(259, "ffdhe6144", true, ProtocolVersion.PROTOCOLS_TO_13),
        FFDHE_8192(260, "ffdhe8192", true, ProtocolVersion.PROTOCOLS_TO_13),
        ARBITRARY_PRIME(65281, "arbitrary_explicit_prime_curves", ProtocolVersion.PROTOCOLS_TO_12),
        ARBITRARY_CHAR2(65282, "arbitrary_explicit_char2_curves", ProtocolVersion.PROTOCOLS_TO_12);

        final int id;
        final NamedGroupType type;
        final String name;
        final String oid;
        final String algorithm;
        final boolean isFips;
        final ProtocolVersion[] supportedProtocols;
        final boolean isEcAvailable;

        private NamedGroup(int id, String name, String oid, boolean isFips, ProtocolVersion[] supportedProtocols) {
            this.id = id;
            this.type = NamedGroupType.NAMED_GROUP_ECDHE;
            this.name = name;
            this.oid = oid;
            this.algorithm = "EC";
            this.isFips = isFips;
            this.supportedProtocols = supportedProtocols;
            this.isEcAvailable = JsseJce.isEcAvailable();
        }

        private NamedGroup(int id, String name, boolean isFips, String algorithm, ProtocolVersion[] supportedProtocols) {
            this.id = id;
            this.type = NamedGroupType.NAMED_GROUP_XDH;
            this.name = name;
            this.oid = null;
            this.algorithm = algorithm;
            this.isFips = isFips;
            this.supportedProtocols = supportedProtocols;
            this.isEcAvailable = true;
        }

        private NamedGroup(int id, String name, boolean isFips, ProtocolVersion[] supportedProtocols) {
            this.id = id;
            this.type = NamedGroupType.NAMED_GROUP_FFDHE;
            this.name = name;
            this.oid = null;
            this.algorithm = "DiffieHellman";
            this.isFips = isFips;
            this.supportedProtocols = supportedProtocols;
            this.isEcAvailable = true;
        }

        private NamedGroup(int id, String name, ProtocolVersion[] supportedProtocols) {
            this.id = id;
            this.type = NamedGroupType.NAMED_GROUP_ARBITRARY;
            this.name = name;
            this.oid = null;
            this.algorithm = "EC";
            this.isFips = false;
            this.supportedProtocols = supportedProtocols;
            this.isEcAvailable = true;
        }

        static NamedGroup valueOf(int id) {
            for (NamedGroup group : NamedGroup.values()) {
                if (group.id != id) continue;
                return group;
            }
            return null;
        }

        static NamedGroup valueOf(ECParameterSpec params) {
            String oid = JsseJce.getNamedCurveOid(params);
            if (oid != null && !oid.isEmpty()) {
                for (NamedGroup group : NamedGroup.values()) {
                    if (group.type != NamedGroupType.NAMED_GROUP_ECDHE || !oid.equals(group.oid)) continue;
                    return group;
                }
            }
            return null;
        }

        static NamedGroup valueOf(DHParameterSpec params) {
            for (Map.Entry<NamedGroup, AlgorithmParameters> me : SupportedGroups.namedGroupParams.entrySet()) {
                NamedGroup ng = me.getKey();
                if (ng.type != NamedGroupType.NAMED_GROUP_FFDHE) continue;
                DHParameterSpec ngParams = null;
                AlgorithmParameters aps = me.getValue();
                try {
                    ngParams = aps.getParameterSpec(DHParameterSpec.class);
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    // empty catch block
                }
                if (ngParams == null || !ngParams.getP().equals(params.getP()) || !ngParams.getG().equals(params.getG())) continue;
                return ng;
            }
            return null;
        }

        static NamedGroup nameOf(String name) {
            for (NamedGroup group : NamedGroup.values()) {
                if (!group.name.equals(name)) continue;
                return group;
            }
            return null;
        }

        static String nameOf(int id) {
            for (NamedGroup group : NamedGroup.values()) {
                if (group.id != id) continue;
                return group.name;
            }
            return "UNDEFINED-NAMED-GROUP(" + id + ")";
        }

        boolean isAvailable(List<ProtocolVersion> protocolVersions) {
            if (this.isEcAvailable) {
                for (ProtocolVersion pv : this.supportedProtocols) {
                    if (!protocolVersions.contains((Object)pv)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isAvailable(ProtocolVersion protocolVersion) {
            if (this.isEcAvailable) {
                for (ProtocolVersion pv : this.supportedProtocols) {
                    if (protocolVersion != pv) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isSupported(List<CipherSuite> cipherSuites) {
            for (CipherSuite cs : cipherSuites) {
                boolean isMatch = this.isAvailable(cs.supportedProtocols);
                if (!isMatch || cs.keyExchange != null && cs.keyExchange.groupType != this.type) continue;
                return true;
            }
            return false;
        }

        AlgorithmParameters getParameters() {
            return SupportedGroups.namedGroupParams.get((Object)this);
        }

        AlgorithmParameterSpec getParameterSpec() {
            if (this.type == NamedGroupType.NAMED_GROUP_ECDHE) {
                return SupportedGroups.getECGenParamSpec(this);
            }
            if (this.type == NamedGroupType.NAMED_GROUP_FFDHE) {
                return SupportedGroups.getDHParameterSpec(this);
            }
            return null;
        }
    }

    static enum NamedGroupType {
        NAMED_GROUP_ECDHE,
        NAMED_GROUP_FFDHE,
        NAMED_GROUP_XDH,
        NAMED_GROUP_ARBITRARY,
        NAMED_GROUP_NONE;


        boolean isSupported(List<CipherSuite> cipherSuites) {
            for (CipherSuite cs : cipherSuites) {
                if (cs.keyExchange != null && cs.keyExchange.groupType != this) continue;
                return true;
            }
            return false;
        }
    }

    private static final class SupportedGroupsStringizer
    implements SSLStringizer {
        private SupportedGroupsStringizer() {
        }

        @Override
        public String toString(ByteBuffer buffer) {
            try {
                return new SupportedGroupsSpec(buffer).toString();
            }
            catch (IOException ioe) {
                return ioe.getMessage();
            }
        }
    }

    static final class SupportedGroupsSpec
    implements SSLExtension.SSLExtensionSpec {
        final int[] namedGroupsIds;

        private SupportedGroupsSpec(int[] namedGroupsIds) {
            this.namedGroupsIds = namedGroupsIds;
        }

        private SupportedGroupsSpec(List<NamedGroup> namedGroups) {
            this.namedGroupsIds = new int[namedGroups.size()];
            int i = 0;
            for (NamedGroup ng : namedGroups) {
                this.namedGroupsIds[i++] = ng.id;
            }
        }

        private SupportedGroupsSpec(ByteBuffer m) throws IOException {
            if (m.remaining() < 2) {
                throw new SSLProtocolException("Invalid supported_groups extension: insufficient data");
            }
            byte[] ngs = Record.getBytes16(m);
            if (m.hasRemaining()) {
                throw new SSLProtocolException("Invalid supported_groups extension: unknown extra data");
            }
            if (ngs == null || ngs.length == 0 || ngs.length % 2 != 0) {
                throw new SSLProtocolException("Invalid supported_groups extension: incomplete data");
            }
            int[] ids = new int[ngs.length / 2];
            int i = 0;
            int j = 0;
            while (i < ngs.length) {
                ids[j++] = (ngs[i++] & 0xFF) << 8 | ngs[i++] & 0xFF;
            }
            this.namedGroupsIds = ids;
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"versions\": '['{0}']'", Locale.ENGLISH);
            if (this.namedGroupsIds == null || this.namedGroupsIds.length == 0) {
                Object[] messageFields = new Object[]{"<no supported named group specified>"};
                return messageFormat.format(messageFields);
            }
            StringBuilder builder = new StringBuilder(512);
            boolean isFirst = true;
            for (int ngid : this.namedGroupsIds) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.append(", ");
                }
                builder.append(NamedGroup.nameOf(ngid));
            }
            Object[] messageFields = new Object[]{builder.toString()};
            return messageFormat.format(messageFields);
        }
    }
}

