/*
 * Decompiled with CFR 0.152.
 */
package sun.net.spi.nameservice.dns;

import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.NamingManager;
import sun.net.dns.ResolverConfiguration;
import sun.net.spi.nameservice.NameService;
import sun.net.util.IPAddressUtil;
import sun.security.action.GetPropertyAction;

public final class DNSNameService
implements NameService {
    private LinkedList<String> domainList = null;
    private String nameProviderUrl = null;
    private static ThreadLocal<SoftReference<ThreadContext>> contextRef = new ThreadLocal();

    private DirContext getTemporaryContext() throws NamingException {
        SoftReference<ThreadContext> ref = contextRef.get();
        ThreadContext thrCtxt = null;
        List<String> nsList = null;
        if (this.nameProviderUrl == null) {
            nsList = ResolverConfiguration.open().nameservers();
        }
        if (ref != null && (thrCtxt = ref.get()) != null && this.nameProviderUrl == null && !thrCtxt.nameservers().equals(nsList)) {
            thrCtxt = null;
        }
        if (thrCtxt == null) {
            DirContext dirCtxt;
            final Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            String provUrl = this.nameProviderUrl;
            if (provUrl == null && (provUrl = DNSNameService.createProviderURL(nsList)).length() == 0) {
                throw new RuntimeException("bad nameserver configuration");
            }
            env.put("java.naming.provider.url", provUrl);
            try {
                dirCtxt = AccessController.doPrivileged(new PrivilegedExceptionAction<DirContext>(){

                    @Override
                    public DirContext run() throws NamingException {
                        Context ctx = NamingManager.getInitialContext(env);
                        if (!(ctx instanceof DirContext)) {
                            return null;
                        }
                        return (DirContext)ctx;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (NamingException)pae.getException();
            }
            thrCtxt = new ThreadContext(dirCtxt, nsList);
            contextRef.set(new SoftReference<ThreadContext>(thrCtxt));
        }
        return thrCtxt.dirContext();
    }

    private ArrayList<String> resolve(final DirContext ctx, final String name, final String[] ids, int depth) throws UnknownHostException {
        Attributes attrs;
        ArrayList<String> results = new ArrayList<String>();
        try {
            attrs = AccessController.doPrivileged(new PrivilegedExceptionAction<Attributes>(){

                @Override
                public Attributes run() throws NamingException {
                    return ctx.getAttributes(name, ids);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new UnknownHostException(pae.getException().getMessage());
        }
        NamingEnumeration<? extends Attribute> ne = attrs.getAll();
        if (!ne.hasMoreElements()) {
            throw new UnknownHostException("DNS record not found");
        }
        UnknownHostException uhe = null;
        try {
            while (ne.hasMoreElements()) {
                Attribute attr = ne.next();
                String attrID = attr.getID();
                NamingEnumeration<?> e = attr.getAll();
                while (e.hasMoreElements()) {
                    String addr = (String)e.next();
                    if (attrID.equals("CNAME")) {
                        if (depth > 4) {
                            throw new UnknownHostException(name + ": possible CNAME loop");
                        }
                        try {
                            results.addAll(this.resolve(ctx, addr, ids, depth + 1));
                        }
                        catch (UnknownHostException x) {
                            if (uhe != null) continue;
                            uhe = x;
                        }
                        continue;
                    }
                    results.add(addr);
                }
            }
        }
        catch (NamingException nx) {
            throw new UnknownHostException(nx.getMessage());
        }
        if (results.isEmpty() && uhe != null) {
            throw uhe;
        }
        return results;
    }

    public DNSNameService() throws Exception {
        String nameservers;
        String domain = AccessController.doPrivileged(new GetPropertyAction("sun.net.spi.nameservice.domain"));
        if (domain != null && domain.length() > 0) {
            this.domainList = new LinkedList();
            this.domainList.add(domain);
        }
        if ((nameservers = AccessController.doPrivileged(new GetPropertyAction("sun.net.spi.nameservice.nameservers"))) != null && nameservers.length() > 0) {
            this.nameProviderUrl = DNSNameService.createProviderURL(nameservers);
            if (this.nameProviderUrl.length() == 0) {
                throw new RuntimeException("malformed nameservers property");
            }
        } else {
            List<String> nsList = ResolverConfiguration.open().nameservers();
            if (nsList.isEmpty()) {
                throw new RuntimeException("no nameservers provided");
            }
            boolean found = false;
            for (String addr : nsList) {
                if (!IPAddressUtil.isIPv4LiteralAddress(addr) && !IPAddressUtil.isIPv6LiteralAddress(addr)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new RuntimeException("bad nameserver configuration");
            }
        }
    }

    public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
        DirContext ctx;
        String[] ids = new String[]{"A", "AAAA", "CNAME"};
        try {
            ctx = this.getTemporaryContext();
        }
        catch (NamingException nx) {
            throw new Error(nx);
        }
        ArrayList<String> results = null;
        UnknownHostException uhe = null;
        if (host.indexOf(46) >= 0) {
            try {
                results = this.resolve(ctx, host, ids, 0);
            }
            catch (UnknownHostException x) {
                uhe = x;
            }
        }
        if (results == null) {
            Iterator<Object> i;
            List<String> searchList = null;
            boolean usingSearchList = false;
            if (this.domainList != null) {
                i = this.domainList.iterator();
            } else {
                searchList = ResolverConfiguration.open().searchlist();
                if (searchList.size() > 1) {
                    usingSearchList = true;
                }
                i = searchList.iterator();
            }
            while (i.hasNext()) {
                String parentDomain = (String)i.next();
                int start = 0;
                while ((start = parentDomain.indexOf(".")) != -1 && start < parentDomain.length() - 1) {
                    try {
                        results = this.resolve(ctx, host + "." + parentDomain, ids, 0);
                        break;
                    }
                    catch (UnknownHostException x) {
                        uhe = x;
                        if (usingSearchList) break;
                        parentDomain = parentDomain.substring(start + 1);
                    }
                }
                if (results == null) continue;
                break;
            }
        }
        if (results == null && host.indexOf(46) < 0) {
            results = this.resolve(ctx, host, ids, 0);
        }
        if (results == null) {
            assert (uhe != null);
            throw uhe;
        }
        assert (results.size() > 0);
        InetAddress[] addrs = new InetAddress[results.size()];
        int count = 0;
        for (int i = 0; i < results.size(); ++i) {
            String addrString = results.get(i);
            byte[] addr = null;
            try {
                addr = IPAddressUtil.validateNumericFormatV4(addrString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (addr == null) {
                addr = IPAddressUtil.textToNumericFormatV6(addrString);
            }
            if (addr == null) continue;
            addrs[count++] = InetAddress.getByAddress(host, addr);
        }
        if (count == 0) {
            throw new UnknownHostException(host + ": no valid DNS records");
        }
        if (count < results.size()) {
            InetAddress[] tmp = new InetAddress[count];
            for (int i = 0; i < count; ++i) {
                tmp[i] = addrs[i];
            }
            addrs = tmp;
        }
        return addrs;
    }

    public String getHostByAddr(byte[] addr) throws UnknownHostException {
        String host;
        block12: {
            host = null;
            try {
                DirContext ctx;
                String literalip = "";
                String[] ids = new String[]{"PTR"};
                ArrayList<String> results = null;
                try {
                    ctx = this.getTemporaryContext();
                }
                catch (NamingException nx) {
                    throw new Error(nx);
                }
                if (addr.length == 4) {
                    for (int i = addr.length - 1; i >= 0; --i) {
                        literalip = literalip + (addr[i] & 0xFF) + ".";
                    }
                    literalip = literalip + "IN-ADDR.ARPA.";
                    results = this.resolve(ctx, literalip, ids, 0);
                    host = results.get(0);
                    break block12;
                }
                if (addr.length != 16) break block12;
                for (int i = addr.length - 1; i >= 0; --i) {
                    literalip = literalip + Integer.toHexString(addr[i] & 0xF) + "." + Integer.toHexString((addr[i] & 0xF0) >> 4) + ".";
                }
                String ip6lit = literalip + "IP6.ARPA.";
                try {
                    results = this.resolve(ctx, ip6lit, ids, 0);
                    host = results.get(0);
                }
                catch (UnknownHostException e) {
                    host = null;
                }
                if (host == null) {
                    ip6lit = literalip + "IP6.INT.";
                    results = this.resolve(ctx, ip6lit, ids, 0);
                    host = results.get(0);
                }
            }
            catch (Exception e) {
                throw new UnknownHostException(e.getMessage());
            }
        }
        if (host == null) {
            throw new UnknownHostException();
        }
        if (host.endsWith(".")) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    private static void appendIfLiteralAddress(String addr, StringBuffer sb) {
        if (IPAddressUtil.isIPv4LiteralAddress(addr)) {
            sb.append("dns://" + addr + " ");
        } else if (IPAddressUtil.isIPv6LiteralAddress(addr)) {
            sb.append("dns://[" + addr + "] ");
        }
    }

    private static String createProviderURL(List<String> nsList) {
        StringBuffer sb = new StringBuffer();
        for (String s : nsList) {
            DNSNameService.appendIfLiteralAddress(s, sb);
        }
        return sb.toString();
    }

    private static String createProviderURL(String str) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            DNSNameService.appendIfLiteralAddress(st.nextToken(), sb);
        }
        return sb.toString();
    }

    private static class ThreadContext {
        private DirContext dirCtxt;
        private List<String> nsList;

        public ThreadContext(DirContext dirCtxt, List<String> nsList) {
            this.dirCtxt = dirCtxt;
            this.nsList = nsList;
        }

        public DirContext dirContext() {
            return this.dirCtxt;
        }

        public List<String> nameservers() {
            return this.nsList;
        }
    }
}

