/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHPrivateKey;
import com.sun.crypto.provider.DHPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public final class DHKeyFactory
extends KeyFactorySpi {
    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DHPublicKeySpec) {
                DHPublicKeySpec dhPubKeySpec = (DHPublicKeySpec)keySpec;
                return new DHPublicKey(dhPubKeySpec.getY(), dhPubKeySpec.getP(), dhPubKeySpec.getG());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new DHPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Inappropriate key specification", e);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DHPrivateKeySpec) {
                DHPrivateKeySpec dhPrivKeySpec = (DHPrivateKeySpec)keySpec;
                return new DHPrivateKey(dhPrivKeySpec.getX(), dhPrivKeySpec.getP(), dhPrivKeySpec.getG());
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new DHPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Inappropriate key specification", e);
        }
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        if (key instanceof javax.crypto.interfaces.DHPublicKey) {
            if (keySpec.isAssignableFrom(DHPublicKeySpec.class)) {
                javax.crypto.interfaces.DHPublicKey dhPubKey = (javax.crypto.interfaces.DHPublicKey)key;
                DHParameterSpec params = dhPubKey.getParams();
                return (T)((KeySpec)keySpec.cast(new DHPublicKeySpec(dhPubKey.getY(), params.getP(), params.getG())));
            }
            if (keySpec.isAssignableFrom(X509EncodedKeySpec.class)) {
                return (T)((KeySpec)keySpec.cast(new X509EncodedKeySpec(key.getEncoded())));
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        if (key instanceof javax.crypto.interfaces.DHPrivateKey) {
            if (keySpec.isAssignableFrom(DHPrivateKeySpec.class)) {
                javax.crypto.interfaces.DHPrivateKey dhPrivKey = (javax.crypto.interfaces.DHPrivateKey)key;
                DHParameterSpec params = dhPrivKey.getParams();
                return (T)((KeySpec)keySpec.cast(new DHPrivateKeySpec(dhPrivKey.getX(), params.getP(), params.getG())));
            }
            if (keySpec.isAssignableFrom(PKCS8EncodedKeySpec.class)) {
                return (T)((KeySpec)keySpec.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        throw new InvalidKeySpecException("Inappropriate key type");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof javax.crypto.interfaces.DHPublicKey) {
                if (key instanceof DHPublicKey) {
                    return key;
                }
                DHPublicKeySpec dhPubKeySpec = this.engineGetKeySpec(key, DHPublicKeySpec.class);
                return this.engineGeneratePublic(dhPubKeySpec);
            }
            if (key instanceof javax.crypto.interfaces.DHPrivateKey) {
                if (key instanceof DHPrivateKey) {
                    return key;
                }
                DHPrivateKeySpec dhPrivKeySpec = this.engineGetKeySpec(key, DHPrivateKeySpec.class);
                return this.engineGeneratePrivate(dhPrivKeySpec);
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key", e);
        }
    }
}

