/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHPrivateKey;
import com.sun.crypto.provider.DHPublicKey;
import com.sun.crypto.provider.SunJCE;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import sun.security.provider.ParameterCache;
import sun.security.util.SecurityProviderConstants;

public final class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private DHParameterSpec params;
    private int pSize;
    private SecureRandom random;

    public DHKeyPairGenerator() {
        this.initialize(SecurityProviderConstants.DEF_DH_KEY_SIZE, null);
    }

    static void checkKeySize(int keysize, int expSize) throws InvalidParameterException {
        if (keysize < 512 || keysize > 8192 || (keysize & 0x3F) != 0) {
            throw new InvalidParameterException("DH key size must be multiple of 64, and can only range from 512 to 8192 (inclusive). The specific key size " + keysize + " is not supported");
        }
        if (expSize < 0 || expSize > keysize) {
            throw new InvalidParameterException("Exponent size must be positive and no larger than modulus size");
        }
    }

    @Override
    public void initialize(int keysize, SecureRandom random) {
        DHKeyPairGenerator.checkKeySize(keysize, 0);
        try {
            this.params = ParameterCache.getDHParameterSpec(keysize, random);
        }
        catch (GeneralSecurityException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        this.pSize = keysize;
        this.random = random;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algParams, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(algParams instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        this.params = (DHParameterSpec)algParams;
        this.pSize = this.params.getP().bitLength();
        try {
            DHKeyPairGenerator.checkKeySize(this.pSize, this.params.getL());
        }
        catch (InvalidParameterException ipe) {
            throw new InvalidAlgorithmParameterException(ipe.getMessage());
        }
        this.random = random;
    }

    @Override
    public KeyPair generateKeyPair() {
        BigInteger x;
        if (this.random == null) {
            this.random = SunJCE.getRandom();
        }
        BigInteger p = this.params.getP();
        BigInteger g = this.params.getG();
        int lSize = this.params.getL();
        if (lSize == 0) {
            lSize = SecurityProviderConstants.getDefDHPrivateExpSize(this.params);
        }
        BigInteger pMinus2 = p.subtract(BigInteger.valueOf(2L));
        while ((x = new BigInteger(lSize, this.random)).compareTo(BigInteger.ONE) < 0 || x.compareTo(pMinus2) > 0 || x.bitLength() != lSize) {
        }
        BigInteger y = g.modPow(x, p);
        DHPublicKey pubKey = new DHPublicKey(y, p, g, lSize);
        DHPrivateKey privKey = new DHPrivateKey(x, p, g, lSize);
        return new KeyPair(pubKey, privKey);
    }
}

