/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHKeyPairGenerator;
import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import sun.security.util.SecurityProviderConstants;

public final class DHParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int primeSize = SecurityProviderConstants.DEF_DH_KEY_SIZE;
    private int exponentSize = 0;
    private SecureRandom random = null;

    private static void checkSupport(int keysize, int exponentSize) throws InvalidParameterException {
        boolean supported;
        boolean bl = supported = keysize == 2048 || keysize == 3072 || keysize >= 512 && keysize <= 1024 && (keysize & 0x3F) == 0;
        if (!supported) {
            throw new InvalidParameterException("Supported DH key size must be multiple of 64 and range from 512 to 1024 (inclusive), or 2048, 3072. The specified key size " + keysize + " is not supported");
        }
        if (exponentSize != 0) {
            DHKeyPairGenerator.checkKeySize(keysize, exponentSize);
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        DHParameterGenerator.checkSupport(keysize, 0);
        this.primeSize = keysize;
        this.random = random;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(genParamSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        DHGenParameterSpec dhParamSpec = (DHGenParameterSpec)genParamSpec;
        int primeSize = dhParamSpec.getPrimeSize();
        int exponentSize = dhParamSpec.getExponentSize();
        try {
            DHParameterGenerator.checkSupport(primeSize, exponentSize);
        }
        catch (InvalidParameterException ipe) {
            throw new InvalidAlgorithmParameterException(ipe.getMessage());
        }
        this.primeSize = primeSize;
        this.exponentSize = exponentSize;
        this.random = random;
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        if (this.exponentSize == 0) {
            this.exponentSize = this.primeSize - 1;
        }
        if (this.random == null) {
            this.random = SunJCE.getRandom();
        }
        Object paramP = null;
        Object paramG = null;
        try {
            AlgorithmParameterGenerator dsaParamGen = AlgorithmParameterGenerator.getInstance("DSA");
            dsaParamGen.init(this.primeSize, this.random);
            AlgorithmParameters dsaParams = dsaParamGen.generateParameters();
            DSAParameterSpec dsaParamSpec = dsaParams.getParameterSpec(DSAParameterSpec.class);
            DHParameterSpec dhParamSpec = this.exponentSize > 0 ? new DHParameterSpec(dsaParamSpec.getP(), dsaParamSpec.getG(), this.exponentSize) : new DHParameterSpec(dsaParamSpec.getP(), dsaParamSpec.getG());
            AlgorithmParameters algParams = AlgorithmParameters.getInstance("DH", SunJCE.getInstance());
            algParams.init(dhParamSpec);
            return algParams;
        }
        catch (Exception ex) {
            throw new ProviderException("Unexpected exception", ex);
        }
    }
}

