/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.GCTR;
import com.sun.crypto.provider.GHASH;
import com.sun.crypto.provider.RangeUtil;
import com.sun.crypto.provider.SymmetricCipher;
import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import javax.crypto.AEADBadTagException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

final class GaloisCounterMode
extends FeedbackCipher {
    static int DEFAULT_TAG_LEN = 16;
    static int DEFAULT_IV_LEN = 12;
    private static final int MAX_BUF_SIZE = Integer.MAX_VALUE;
    private static final int TRIGGERLEN = 65536;
    private ByteArrayOutputStream aadBuffer = new ByteArrayOutputStream();
    private int sizeOfAAD = 0;
    private ByteArrayOutputStream ibuffer = null;
    private int tagLenBytes = DEFAULT_TAG_LEN;
    private byte[] subkeyH = null;
    private byte[] preCounterBlock = null;
    private GCTR gctrPAndC = null;
    private GHASH ghashAllToS = null;
    private int processed = 0;
    private byte[] aadBufferSave = null;
    private int sizeOfAADSave = 0;
    private byte[] ibufferSave = null;
    private int processedSave = 0;

    static void increment32(byte[] value) {
        if (value.length != 16) {
            throw new ProviderException("Illegal counter block length");
        }
        int n = value.length - 1;
        while (n >= value.length - 4) {
            int n2 = n--;
            value[n2] = (byte)(value[n2] + 1);
            if (value[n2] == 0) continue;
        }
    }

    private static byte[] getLengthBlock(int ivLenInBytes) {
        long ivLen = (long)ivLenInBytes << 3;
        byte[] out = new byte[16];
        out[8] = (byte)(ivLen >>> 56);
        out[9] = (byte)(ivLen >>> 48);
        out[10] = (byte)(ivLen >>> 40);
        out[11] = (byte)(ivLen >>> 32);
        out[12] = (byte)(ivLen >>> 24);
        out[13] = (byte)(ivLen >>> 16);
        out[14] = (byte)(ivLen >>> 8);
        out[15] = (byte)ivLen;
        return out;
    }

    private static byte[] getLengthBlock(int aLenInBytes, int cLenInBytes) {
        long aLen = (long)aLenInBytes << 3;
        long cLen = (long)cLenInBytes << 3;
        byte[] out = new byte[]{(byte)(aLen >>> 56), (byte)(aLen >>> 48), (byte)(aLen >>> 40), (byte)(aLen >>> 32), (byte)(aLen >>> 24), (byte)(aLen >>> 16), (byte)(aLen >>> 8), (byte)aLen, (byte)(cLen >>> 56), (byte)(cLen >>> 48), (byte)(cLen >>> 40), (byte)(cLen >>> 32), (byte)(cLen >>> 24), (byte)(cLen >>> 16), (byte)(cLen >>> 8), (byte)cLen};
        return out;
    }

    private static byte[] expandToOneBlock(byte[] in, int inOfs, int len) {
        if (len > 16) {
            throw new ProviderException("input " + len + " too long");
        }
        if (len == 16 && inOfs == 0) {
            return in;
        }
        byte[] paddedIn = new byte[16];
        System.arraycopy(in, inOfs, paddedIn, 0, len);
        return paddedIn;
    }

    private static byte[] getJ0(byte[] iv, byte[] subkeyH) {
        byte[] j0;
        if (iv.length == 12) {
            j0 = GaloisCounterMode.expandToOneBlock(iv, 0, iv.length);
            j0[15] = 1;
        } else {
            GHASH g = new GHASH(subkeyH);
            int lastLen = iv.length % 16;
            if (lastLen != 0) {
                g.update(iv, 0, iv.length - lastLen);
                byte[] padded = GaloisCounterMode.expandToOneBlock(iv, iv.length - lastLen, lastLen);
                g.update(padded);
            } else {
                g.update(iv);
            }
            byte[] lengthBlock = GaloisCounterMode.getLengthBlock(iv.length);
            g.update(lengthBlock);
            j0 = g.digest();
        }
        return j0;
    }

    private static void checkDataLength(int processed, int len) {
        if (processed > Integer.MAX_VALUE - len) {
            throw new ProviderException("SunJCE provider only supports input size up to 2147483647 bytes");
        }
    }

    GaloisCounterMode(SymmetricCipher embeddedCipher) {
        super(embeddedCipher);
        this.aadBuffer = new ByteArrayOutputStream();
    }

    @Override
    String getFeedback() {
        return "GCM";
    }

    @Override
    void reset() {
        if (this.aadBuffer == null) {
            this.aadBuffer = new ByteArrayOutputStream();
        } else {
            this.aadBuffer.reset();
        }
        if (this.gctrPAndC != null) {
            this.gctrPAndC.reset();
        }
        if (this.ghashAllToS != null) {
            this.ghashAllToS.reset();
        }
        this.processed = 0;
        this.sizeOfAAD = 0;
        if (this.ibuffer != null) {
            this.ibuffer.reset();
        }
    }

    @Override
    void save() {
        this.processedSave = this.processed;
        this.sizeOfAADSave = this.sizeOfAAD;
        byte[] byArray = this.aadBufferSave = this.aadBuffer == null || this.aadBuffer.size() == 0 ? null : this.aadBuffer.toByteArray();
        if (this.gctrPAndC != null) {
            this.gctrPAndC.save();
        }
        if (this.ghashAllToS != null) {
            this.ghashAllToS.save();
        }
        if (this.ibuffer != null) {
            this.ibufferSave = this.ibuffer.toByteArray();
        }
    }

    @Override
    void restore() {
        this.processed = this.processedSave;
        this.sizeOfAAD = this.sizeOfAADSave;
        if (this.aadBuffer != null) {
            this.aadBuffer.reset();
            if (this.aadBufferSave != null) {
                this.aadBuffer.write(this.aadBufferSave, 0, this.aadBufferSave.length);
            }
        }
        if (this.gctrPAndC != null) {
            this.gctrPAndC.restore();
        }
        if (this.ghashAllToS != null) {
            this.ghashAllToS.restore();
        }
        if (this.ibuffer != null) {
            this.ibuffer.reset();
            this.ibuffer.write(this.ibufferSave, 0, this.ibufferSave.length);
        }
    }

    @Override
    void init(boolean decrypting, String algorithm, byte[] key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(decrypting, algorithm, key, iv, DEFAULT_TAG_LEN);
    }

    void init(boolean decrypting, String algorithm, byte[] keyValue, byte[] ivValue, int tagLenBytes) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (keyValue == null) {
            throw new InvalidKeyException("Internal error");
        }
        if (ivValue == null) {
            throw new InvalidAlgorithmParameterException("Internal error");
        }
        if (ivValue.length == 0) {
            throw new InvalidAlgorithmParameterException("IV is empty");
        }
        this.embeddedCipher.init(false, algorithm, keyValue);
        this.subkeyH = new byte[16];
        this.embeddedCipher.encryptBlock(new byte[16], 0, this.subkeyH, 0);
        this.iv = (byte[])ivValue.clone();
        this.preCounterBlock = GaloisCounterMode.getJ0(this.iv, this.subkeyH);
        byte[] j0Plus1 = (byte[])this.preCounterBlock.clone();
        GaloisCounterMode.increment32(j0Plus1);
        this.gctrPAndC = new GCTR(this.embeddedCipher, j0Plus1);
        this.ghashAllToS = new GHASH(this.subkeyH);
        this.tagLenBytes = tagLenBytes;
        if (this.aadBuffer == null) {
            this.aadBuffer = new ByteArrayOutputStream();
        } else {
            this.aadBuffer.reset();
        }
        this.processed = 0;
        this.sizeOfAAD = 0;
        if (decrypting) {
            this.ibuffer = new ByteArrayOutputStream();
        }
    }

    @Override
    void updateAAD(byte[] src, int offset, int len) {
        if (this.aadBuffer == null) {
            throw new IllegalStateException("Update has been called; no more AAD data");
        }
        this.aadBuffer.write(src, offset, len);
    }

    void processAAD() {
        if (this.aadBuffer != null) {
            if (this.aadBuffer.size() > 0) {
                byte[] aad = this.aadBuffer.toByteArray();
                this.sizeOfAAD = aad.length;
                int lastLen = aad.length % 16;
                if (lastLen != 0) {
                    this.ghashAllToS.update(aad, 0, aad.length - lastLen);
                    byte[] padded = GaloisCounterMode.expandToOneBlock(aad, aad.length - lastLen, lastLen);
                    this.ghashAllToS.update(padded);
                } else {
                    this.ghashAllToS.update(aad);
                }
            }
            this.aadBuffer = null;
        }
    }

    void doLastBlock(byte[] in, int inOfs, int len, byte[] out, int outOfs, boolean isEncrypt) throws IllegalBlockSizeException {
        int ctOfs;
        byte[] ct;
        int ilen = len;
        if (isEncrypt) {
            ct = out;
            ctOfs = outOfs;
        } else {
            ct = in;
            ctOfs = inOfs;
        }
        if (len > 65536) {
            int plen = 96;
            int count = len / 1024;
            for (int i = 0; count > i; ++i) {
                int tlen = this.gctrPAndC.update(in, inOfs, 96, out, outOfs);
                this.ghashAllToS.update(ct, ctOfs, tlen);
                inOfs += tlen;
                outOfs += tlen;
                ctOfs += tlen;
            }
            ilen -= count * 96;
            this.processed += count * 96;
        }
        this.gctrPAndC.doFinal(in, inOfs, ilen, out, outOfs);
        this.processed += ilen;
        int lastLen = ilen % 16;
        if (lastLen != 0) {
            this.ghashAllToS.update(ct, ctOfs, ilen - lastLen);
            this.ghashAllToS.update(GaloisCounterMode.expandToOneBlock(ct, ctOfs + ilen - lastLen, lastLen));
        } else {
            this.ghashAllToS.update(ct, ctOfs, ilen);
        }
    }

    @Override
    int encrypt(byte[] in, int inOfs, int len, byte[] out, int outOfs) {
        GaloisCounterMode.checkDataLength(this.processed, len);
        RangeUtil.blockSizeCheck(len, this.blockSize);
        this.processAAD();
        if (len > 0) {
            RangeUtil.nullAndBoundsCheck(in, inOfs, len);
            RangeUtil.nullAndBoundsCheck(out, outOfs, len);
            this.gctrPAndC.update(in, inOfs, len, out, outOfs);
            this.processed += len;
            this.ghashAllToS.update(out, outOfs, len);
        }
        return len;
    }

    @Override
    int encryptFinal(byte[] in, int inOfs, int len, byte[] out, int outOfs) throws IllegalBlockSizeException, ShortBufferException {
        if (len > Integer.MAX_VALUE - this.tagLenBytes) {
            throw new ShortBufferException("Can't fit both data and tag into one buffer");
        }
        try {
            RangeUtil.nullAndBoundsCheck(out, outOfs, len + this.tagLenBytes);
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            throw new ShortBufferException("Output buffer too small");
        }
        GaloisCounterMode.checkDataLength(this.processed, len);
        this.processAAD();
        if (len > 0) {
            RangeUtil.nullAndBoundsCheck(in, inOfs, len);
            this.doLastBlock(in, inOfs, len, out, outOfs, true);
        }
        byte[] lengthBlock = GaloisCounterMode.getLengthBlock(this.sizeOfAAD, this.processed);
        this.ghashAllToS.update(lengthBlock);
        byte[] s = this.ghashAllToS.digest();
        byte[] sOut = new byte[s.length];
        GCTR gctrForSToTag = new GCTR(this.embeddedCipher, this.preCounterBlock);
        gctrForSToTag.doFinal(s, 0, s.length, sOut, 0);
        System.arraycopy(sOut, 0, out, outOfs + len, this.tagLenBytes);
        return len + this.tagLenBytes;
    }

    @Override
    int decrypt(byte[] in, int inOfs, int len, byte[] out, int outOfs) {
        GaloisCounterMode.checkDataLength(this.ibuffer.size(), len);
        RangeUtil.blockSizeCheck(len, this.blockSize);
        this.processAAD();
        if (len > 0) {
            RangeUtil.nullAndBoundsCheck(in, inOfs, len);
            this.ibuffer.write(in, inOfs, len);
        }
        return 0;
    }

    @Override
    int decryptFinal(byte[] in, int inOfs, int len, byte[] out, int outOfs) throws IllegalBlockSizeException, AEADBadTagException, ShortBufferException {
        if (len < this.tagLenBytes) {
            throw new AEADBadTagException("Input too short - need tag");
        }
        GaloisCounterMode.checkDataLength(this.ibuffer.size(), len - this.tagLenBytes);
        try {
            RangeUtil.nullAndBoundsCheck(out, outOfs, this.ibuffer.size() + len - this.tagLenBytes);
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            throw new ShortBufferException("Output buffer too small");
        }
        this.processAAD();
        RangeUtil.nullAndBoundsCheck(in, inOfs, len);
        byte[] tag = new byte[this.tagLenBytes];
        System.arraycopy(in, inOfs + len - this.tagLenBytes, tag, 0, this.tagLenBytes);
        len -= this.tagLenBytes;
        if (in == out || this.ibuffer.size() > 0) {
            if (len > 0) {
                this.ibuffer.write(in, inOfs, len);
            }
            in = this.ibuffer.toByteArray();
            inOfs = 0;
            len = in.length;
            this.ibuffer.reset();
        }
        if (len > 0) {
            this.doLastBlock(in, inOfs, len, out, outOfs, false);
        }
        byte[] lengthBlock = GaloisCounterMode.getLengthBlock(this.sizeOfAAD, this.processed);
        this.ghashAllToS.update(lengthBlock);
        byte[] s = this.ghashAllToS.digest();
        byte[] sOut = new byte[s.length];
        GCTR gctrForSToTag = new GCTR(this.embeddedCipher, this.preCounterBlock);
        gctrForSToTag.doFinal(s, 0, s.length, sOut, 0);
        int mismatch = 0;
        for (int i = 0; i < this.tagLenBytes; ++i) {
            mismatch |= tag[i] ^ sOut[i];
        }
        if (mismatch != 0) {
            throw new AEADBadTagException("Tag mismatch!");
        }
        return len;
    }

    int getTagLen() {
        return this.tagLenBytes;
    }

    @Override
    int getBufferedLength() {
        if (this.ibuffer == null) {
            return 0;
        }
        return this.ibuffer.size();
    }
}

