/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public final class OAEPParameters
extends AlgorithmParametersSpi {
    private String mdName;
    private MGF1ParameterSpec mgfSpec;
    private byte[] p;
    private static ObjectIdentifier OID_MGF1;
    private static ObjectIdentifier OID_PSpecified;

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof OAEPParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        OAEPParameterSpec spec = (OAEPParameterSpec)paramSpec;
        this.mdName = spec.getDigestAlgorithm();
        String mgfName = spec.getMGFAlgorithm();
        if (!mgfName.equalsIgnoreCase("MGF1")) {
            throw new InvalidParameterSpecException("Unsupported mgf " + mgfName + "; MGF1 only");
        }
        AlgorithmParameterSpec mgfSpec = spec.getMGFParameters();
        if (!(mgfSpec instanceof MGF1ParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate mgf parameters; non-null MGF1ParameterSpec only");
        }
        this.mgfSpec = (MGF1ParameterSpec)mgfSpec;
        PSource pSrc = spec.getPSource();
        if (!pSrc.getAlgorithm().equals("PSpecified")) {
            throw new InvalidParameterSpecException("Unsupported pSource " + pSrc.getAlgorithm() + "; PSpecified only");
        }
        this.p = ((PSource.PSpecified)pSrc).getValue();
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        DerInputStream der = new DerInputStream(encoded);
        this.mdName = "SHA-1";
        this.mgfSpec = MGF1ParameterSpec.SHA1;
        this.p = new byte[0];
        DerValue[] datum = der.getSequence(3);
        for (int i = 0; i < datum.length; ++i) {
            byte[] encodedParams;
            AlgorithmId val;
            DerValue data = datum[i];
            if (data.isContextSpecific((byte)0)) {
                this.mdName = AlgorithmId.parse(data.data.getDerValue()).getName();
                continue;
            }
            if (data.isContextSpecific((byte)1)) {
                val = AlgorithmId.parse(data.data.getDerValue());
                if (!val.getOID().equals(OID_MGF1)) {
                    throw new IOException("Only MGF1 mgf is supported");
                }
                encodedParams = val.getEncodedParams();
                if (encodedParams == null) {
                    throw new IOException("Missing MGF1 parameters");
                }
                AlgorithmId params = AlgorithmId.parse(new DerValue(encodedParams));
                String mgfDigestName = params.getName();
                if (mgfDigestName.equals("SHA-1")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA1;
                    continue;
                }
                if (mgfDigestName.equals("SHA-224")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA224;
                    continue;
                }
                if (mgfDigestName.equals("SHA-256")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA256;
                    continue;
                }
                if (mgfDigestName.equals("SHA-384")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA384;
                    continue;
                }
                if (mgfDigestName.equals("SHA-512")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA512;
                    continue;
                }
                if (mgfDigestName.equals("SHA-512/224")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA512_224;
                    continue;
                }
                if (mgfDigestName.equals("SHA-512/256")) {
                    this.mgfSpec = MGF1ParameterSpec.SHA512_256;
                    continue;
                }
                throw new IOException("Unrecognized message digest algorithm");
            }
            if (data.isContextSpecific((byte)2)) {
                val = AlgorithmId.parse(data.data.getDerValue());
                if (!val.getOID().equals(OID_PSpecified)) {
                    throw new IOException("Wrong OID for pSpecified");
                }
                encodedParams = val.getEncodedParams();
                if (encodedParams == null) {
                    throw new IOException("Missing pSpecified label");
                }
                DerInputStream dis = new DerInputStream(encodedParams);
                this.p = dis.getOctetString();
                if (dis.available() == 0) continue;
                throw new IOException("Extra data for pSpecified");
            }
            throw new IOException("Invalid encoded OAEPParameters");
        }
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        if (decodingMethod != null && !decodingMethod.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        this.engineInit(encoded);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (OAEPParameterSpec.class.isAssignableFrom(paramSpec)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(new OAEPParameterSpec(this.mdName, "MGF1", this.mgfSpec, new PSource.PSpecified(this.p))));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        AlgorithmId mgfDigestId;
        AlgorithmId mdAlgId;
        DerOutputStream tmp = new DerOutputStream();
        try {
            mdAlgId = AlgorithmId.get(this.mdName);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IOException("AlgorithmId " + this.mdName + " impl not found");
        }
        DerOutputStream tmp2 = new DerOutputStream();
        mdAlgId.derEncode(tmp2);
        tmp.write(DerValue.createTag((byte)-128, true, (byte)0), tmp2);
        tmp2 = new DerOutputStream();
        tmp2.putOID(OID_MGF1);
        try {
            mgfDigestId = AlgorithmId.get(this.mgfSpec.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException nase) {
            throw new IOException("AlgorithmId " + this.mgfSpec.getDigestAlgorithm() + " impl not found");
        }
        mgfDigestId.encode(tmp2);
        DerOutputStream tmp3 = new DerOutputStream();
        tmp3.write((byte)48, tmp2);
        tmp.write(DerValue.createTag((byte)-128, true, (byte)1), tmp3);
        tmp2 = new DerOutputStream();
        tmp2.putOID(OID_PSpecified);
        tmp2.putOctetString(this.p);
        tmp3 = new DerOutputStream();
        tmp3.write((byte)48, tmp2);
        tmp.write(DerValue.createTag((byte)-128, true, (byte)2), tmp3);
        DerOutputStream out = new DerOutputStream();
        out.write((byte)48, tmp);
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        if (encodingMethod != null && !encodingMethod.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MD: " + this.mdName + "\n");
        sb.append("MGF: MGF1" + this.mgfSpec.getDigestAlgorithm() + "\n");
        sb.append("PSource: PSpecified " + (this.p.length == 0 ? "" : Debug.toHexString(new BigInteger(this.p))) + "\n");
        return sb.toString();
    }

    static {
        try {
            OID_MGF1 = new ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 1, 8});
        }
        catch (IOException ioe) {
            OID_MGF1 = null;
        }
        try {
            OID_PSpecified = new ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 1, 9});
        }
        catch (IOException ioe) {
            OID_PSpecified = null;
        }
    }
}

