/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

abstract class PBES2Parameters
extends AlgorithmParametersSpi {
    private static final int[] pkcs5PBKDF2 = new int[]{1, 2, 840, 113549, 1, 5, 12};
    private static final int[] pkcs5PBES2 = new int[]{1, 2, 840, 113549, 1, 5, 13};
    private static final int[] hmacWithSHA1 = new int[]{1, 2, 840, 113549, 2, 7};
    private static final int[] hmacWithSHA224 = new int[]{1, 2, 840, 113549, 2, 8};
    private static final int[] hmacWithSHA256 = new int[]{1, 2, 840, 113549, 2, 9};
    private static final int[] hmacWithSHA384 = new int[]{1, 2, 840, 113549, 2, 10};
    private static final int[] hmacWithSHA512 = new int[]{1, 2, 840, 113549, 2, 11};
    private static final int[] aes128CBC = new int[]{2, 16, 840, 1, 101, 3, 4, 1, 2};
    private static final int[] aes192CBC = new int[]{2, 16, 840, 1, 101, 3, 4, 1, 22};
    private static final int[] aes256CBC = new int[]{2, 16, 840, 1, 101, 3, 4, 1, 42};
    private static ObjectIdentifier pkcs5PBKDF2_OID;
    private static ObjectIdentifier pkcs5PBES2_OID;
    private static ObjectIdentifier hmacWithSHA1_OID;
    private static ObjectIdentifier hmacWithSHA224_OID;
    private static ObjectIdentifier hmacWithSHA256_OID;
    private static ObjectIdentifier hmacWithSHA384_OID;
    private static ObjectIdentifier hmacWithSHA512_OID;
    private static ObjectIdentifier aes128CBC_OID;
    private static ObjectIdentifier aes192CBC_OID;
    private static ObjectIdentifier aes256CBC_OID;
    private String pbes2AlgorithmName;
    private byte[] salt;
    private int iCount;
    private AlgorithmParameterSpec cipherParam;
    private ObjectIdentifier kdfAlgo_OID;
    private ObjectIdentifier cipherAlgo_OID;
    private int keysize;

    PBES2Parameters() {
        this.pbes2AlgorithmName = null;
        this.salt = null;
        this.iCount = 0;
        this.cipherParam = null;
        this.kdfAlgo_OID = hmacWithSHA1_OID;
        this.cipherAlgo_OID = null;
        this.keysize = -1;
    }

    PBES2Parameters(String pbes2AlgorithmName) throws NoSuchAlgorithmException {
        block22: {
            String cipherAlgo;
            block21: {
                int and;
                this.pbes2AlgorithmName = null;
                this.salt = null;
                this.iCount = 0;
                this.cipherParam = null;
                this.kdfAlgo_OID = hmacWithSHA1_OID;
                this.cipherAlgo_OID = null;
                this.keysize = -1;
                String kdfAlgo = null;
                cipherAlgo = null;
                this.pbes2AlgorithmName = pbes2AlgorithmName;
                if (pbes2AlgorithmName.startsWith("PBEWith") && (and = pbes2AlgorithmName.indexOf("And", 8)) > 0) {
                    kdfAlgo = pbes2AlgorithmName.substring(7, and);
                    cipherAlgo = pbes2AlgorithmName.substring(and + 3);
                    int underscore = cipherAlgo.indexOf(95);
                    if (underscore > 0) {
                        int slash = cipherAlgo.indexOf(47, underscore + 1);
                        this.keysize = slash > 0 ? Integer.parseInt(cipherAlgo.substring(underscore + 1, slash)) : Integer.parseInt(cipherAlgo.substring(underscore + 1));
                        cipherAlgo = cipherAlgo.substring(0, underscore);
                    }
                } else {
                    throw new NoSuchAlgorithmException("No crypto implementation for " + pbes2AlgorithmName);
                }
                switch (kdfAlgo) {
                    case "HmacSHA1": {
                        this.kdfAlgo_OID = hmacWithSHA1_OID;
                        break;
                    }
                    case "HmacSHA224": {
                        this.kdfAlgo_OID = hmacWithSHA224_OID;
                        break;
                    }
                    case "HmacSHA256": {
                        this.kdfAlgo_OID = hmacWithSHA256_OID;
                        break;
                    }
                    case "HmacSHA384": {
                        this.kdfAlgo_OID = hmacWithSHA384_OID;
                        break;
                    }
                    case "HmacSHA512": {
                        this.kdfAlgo_OID = hmacWithSHA512_OID;
                        break;
                    }
                    default: {
                        throw new NoSuchAlgorithmException("No crypto implementation for " + kdfAlgo);
                    }
                }
                if (!cipherAlgo.equals("AES")) break block21;
                this.keysize = this.keysize;
                switch (this.keysize) {
                    case 128: {
                        this.cipherAlgo_OID = aes128CBC_OID;
                        break block22;
                    }
                    case 256: {
                        this.cipherAlgo_OID = aes256CBC_OID;
                        break block22;
                    }
                    default: {
                        throw new NoSuchAlgorithmException("No Cipher implementation for " + this.keysize + "-bit " + cipherAlgo);
                    }
                }
            }
            throw new NoSuchAlgorithmException("No Cipher implementation for " + cipherAlgo);
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.salt = (byte[])((PBEParameterSpec)paramSpec).getSalt().clone();
        this.iCount = ((PBEParameterSpec)paramSpec).getIterationCount();
        this.cipherParam = ((PBEParameterSpec)paramSpec).getParameterSpec();
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        String kdfAlgo = null;
        String cipherAlgo = null;
        DerValue pBES2_params = new DerValue(encoded);
        if (pBES2_params.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        DerValue kdf = pBES2_params.data.getDerValue();
        if (kdf.getTag() == 6) {
            pBES2_params = pBES2_params.data.getDerValue();
            kdf = pBES2_params.data.getDerValue();
        }
        kdfAlgo = this.parseKDF(kdf);
        if (pBES2_params.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        cipherAlgo = this.parseES(pBES2_params.data.getDerValue());
        this.pbes2AlgorithmName = "PBEWith" + kdfAlgo + "And" + cipherAlgo;
    }

    private String parseKDF(DerValue keyDerivationFunc) throws IOException {
        if (!pkcs5PBKDF2_OID.equals(keyDerivationFunc.data.getOID())) {
            throw new IOException("PBE parameter parsing error: expecting the object identifier for PBKDF2");
        }
        if (keyDerivationFunc.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        DerValue pBKDF2_params = keyDerivationFunc.data.getDerValue();
        if (pBKDF2_params.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        DerValue specified = pBKDF2_params.data.getDerValue();
        if (specified.tag != 4) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 OCTET STRING tag");
        }
        this.salt = specified.getOctetString();
        this.iCount = pBKDF2_params.data.getInteger();
        DerValue prf = null;
        if (pBKDF2_params.data.available() > 0) {
            DerValue keyLength = pBKDF2_params.data.getDerValue();
            if (keyLength.tag == 2) {
                this.keysize = keyLength.getInteger() * 8;
            } else {
                prf = keyLength;
            }
        }
        String kdfAlgo = "HmacSHA1";
        if (prf == null && pBKDF2_params.data.available() > 0) {
            prf = pBKDF2_params.data.getDerValue();
        }
        if (prf != null) {
            this.kdfAlgo_OID = prf.data.getOID();
            if (hmacWithSHA1_OID.equals(this.kdfAlgo_OID)) {
                kdfAlgo = "HmacSHA1";
            } else if (hmacWithSHA224_OID.equals(this.kdfAlgo_OID)) {
                kdfAlgo = "HmacSHA224";
            } else if (hmacWithSHA256_OID.equals(this.kdfAlgo_OID)) {
                kdfAlgo = "HmacSHA256";
            } else if (hmacWithSHA384_OID.equals(this.kdfAlgo_OID)) {
                kdfAlgo = "HmacSHA384";
            } else if (hmacWithSHA512_OID.equals(this.kdfAlgo_OID)) {
                kdfAlgo = "HmacSHA512";
            } else {
                throw new IOException("PBE parameter parsing error: expecting the object identifier for a HmacSHA key derivation function");
            }
            if (prf.data.available() != 0) {
                DerValue parameter = prf.data.getDerValue();
                if (parameter.tag != 5) {
                    throw new IOException("PBE parameter parsing error: not an ASN.1 NULL tag");
                }
            }
        }
        return kdfAlgo;
    }

    private String parseES(DerValue encryptionScheme) throws IOException {
        String cipherAlgo = null;
        this.cipherAlgo_OID = encryptionScheme.data.getOID();
        if (aes128CBC_OID.equals(this.cipherAlgo_OID)) {
            cipherAlgo = "AES_128";
            this.cipherParam = new IvParameterSpec(encryptionScheme.data.getOctetString());
            this.keysize = 128;
        } else if (aes256CBC_OID.equals(this.cipherAlgo_OID)) {
            cipherAlgo = "AES_256";
            this.cipherParam = new IvParameterSpec(encryptionScheme.data.getOctetString());
            this.keysize = 256;
        } else {
            throw new IOException("PBE parameter parsing error: expecting the object identifier for AES cipher");
        }
        return cipherAlgo;
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        this.engineInit(encoded);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (PBEParameterSpec.class.isAssignableFrom(paramSpec)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(new PBEParameterSpec(this.salt, this.iCount, this.cipherParam)));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream pBES2_params = new DerOutputStream();
        DerOutputStream keyDerivationFunc = new DerOutputStream();
        keyDerivationFunc.putOID(pkcs5PBKDF2_OID);
        DerOutputStream pBKDF2_params = new DerOutputStream();
        pBKDF2_params.putOctetString(this.salt);
        pBKDF2_params.putInteger(this.iCount);
        if (this.keysize > 0) {
            pBKDF2_params.putInteger(this.keysize / 8);
        }
        DerOutputStream prf = new DerOutputStream();
        prf.putOID(this.kdfAlgo_OID);
        prf.putNull();
        pBKDF2_params.write((byte)48, prf);
        keyDerivationFunc.write((byte)48, pBKDF2_params);
        pBES2_params.write((byte)48, keyDerivationFunc);
        DerOutputStream encryptionScheme = new DerOutputStream();
        encryptionScheme.putOID(this.cipherAlgo_OID);
        if (this.cipherParam == null || !(this.cipherParam instanceof IvParameterSpec)) {
            throw new IOException("Wrong parameter type: IV expected");
        }
        encryptionScheme.putOctetString(((IvParameterSpec)this.cipherParam).getIV());
        pBES2_params.write((byte)48, encryptionScheme);
        out.write((byte)48, pBES2_params);
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        return this.pbes2AlgorithmName;
    }

    static {
        try {
            pkcs5PBKDF2_OID = new ObjectIdentifier(pkcs5PBKDF2);
            pkcs5PBES2_OID = new ObjectIdentifier(pkcs5PBES2);
            hmacWithSHA1_OID = new ObjectIdentifier(hmacWithSHA1);
            hmacWithSHA224_OID = new ObjectIdentifier(hmacWithSHA224);
            hmacWithSHA256_OID = new ObjectIdentifier(hmacWithSHA256);
            hmacWithSHA384_OID = new ObjectIdentifier(hmacWithSHA384);
            hmacWithSHA512_OID = new ObjectIdentifier(hmacWithSHA512);
            aes128CBC_OID = new ObjectIdentifier(aes128CBC);
            aes192CBC_OID = new ObjectIdentifier(aes192CBC);
            aes256CBC_OID = new ObjectIdentifier(aes256CBC);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final class HmacSHA512AndAES_256
    extends PBES2Parameters {
        public HmacSHA512AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA512AndAES_256");
        }
    }

    public static final class HmacSHA384AndAES_256
    extends PBES2Parameters {
        public HmacSHA384AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA384AndAES_256");
        }
    }

    public static final class HmacSHA256AndAES_256
    extends PBES2Parameters {
        public HmacSHA256AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA256AndAES_256");
        }
    }

    public static final class HmacSHA224AndAES_256
    extends PBES2Parameters {
        public HmacSHA224AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA224AndAES_256");
        }
    }

    public static final class HmacSHA1AndAES_256
    extends PBES2Parameters {
        public HmacSHA1AndAES_256() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA1AndAES_256");
        }
    }

    public static final class HmacSHA512AndAES_128
    extends PBES2Parameters {
        public HmacSHA512AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA512AndAES_128");
        }
    }

    public static final class HmacSHA384AndAES_128
    extends PBES2Parameters {
        public HmacSHA384AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA384AndAES_128");
        }
    }

    public static final class HmacSHA256AndAES_128
    extends PBES2Parameters {
        public HmacSHA256AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA256AndAES_128");
        }
    }

    public static final class HmacSHA224AndAES_128
    extends PBES2Parameters {
        public HmacSHA224AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA224AndAES_128");
        }
    }

    public static final class HmacSHA1AndAES_128
    extends PBES2Parameters {
        public HmacSHA1AndAES_128() throws NoSuchAlgorithmException {
            super("PBEWithHmacSHA1AndAES_128");
        }
    }

    public static final class General
    extends PBES2Parameters {
    }
}

