/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.ConstructKeys;
import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.jca.Providers;
import sun.security.rsa.RSACore;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPadding;
import sun.security.util.KeyUtil;

public final class RSACipher
extends CipherSpi {
    private static final byte[] B0 = new byte[0];
    private static final int MODE_ENCRYPT = 1;
    private static final int MODE_DECRYPT = 2;
    private static final int MODE_SIGN = 3;
    private static final int MODE_VERIFY = 4;
    private static final String PAD_NONE = "NoPadding";
    private static final String PAD_PKCS1 = "PKCS1Padding";
    private static final String PAD_OAEP_MGF1 = "OAEP";
    private int mode;
    private String paddingType = "PKCS1Padding";
    private RSAPadding padding;
    private AlgorithmParameterSpec spec = null;
    private boolean forTlsPremasterSecret = false;
    private byte[] buffer;
    private int bufOfs;
    private int outputSize;
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;
    private String oaepHashAlgorithm = "SHA-1";
    private SecureRandom random;

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String paddingName) throws NoSuchPaddingException {
        if (paddingName.equalsIgnoreCase(PAD_NONE)) {
            this.paddingType = PAD_NONE;
        } else if (paddingName.equalsIgnoreCase(PAD_PKCS1)) {
            this.paddingType = PAD_PKCS1;
        } else {
            String lowerPadding = paddingName.toLowerCase(Locale.ENGLISH);
            if (lowerPadding.equals("oaeppadding")) {
                this.paddingType = PAD_OAEP_MGF1;
            } else if (lowerPadding.startsWith("oaepwith") && lowerPadding.endsWith("andmgf1padding")) {
                this.paddingType = PAD_OAEP_MGF1;
                this.oaepHashAlgorithm = paddingName.substring(8, paddingName.length() - 14);
                if (Providers.getProviderList().getService("MessageDigest", this.oaepHashAlgorithm) == null) {
                    throw new NoSuchPaddingException("MessageDigest not available for " + paddingName);
                }
            } else {
                throw new NoSuchPaddingException("Padding " + paddingName + " not supported");
            }
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.outputSize;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.spec != null && this.spec instanceof OAEPParameterSpec) {
            try {
                AlgorithmParameters params = AlgorithmParameters.getInstance(PAD_OAEP_MGF1, SunJCE.getInstance());
                params.init(this.spec);
                return params;
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("Cannot find OAEP  AlgorithmParameters implementation in SunJCE provider");
            }
            catch (InvalidParameterSpecException ipse) {
                throw new RuntimeException("OAEPParameterSpec not supported");
            }
        }
        return null;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.init(opmode, key, random, null);
        }
        catch (InvalidAlgorithmParameterException iape) {
            InvalidKeyException ike = new InvalidKeyException("Wrong parameters");
            ike.initCause(iape);
            throw ike;
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key, random, params);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params == null) {
            this.init(opmode, key, random, null);
        } else {
            try {
                OAEPParameterSpec spec = params.getParameterSpec(OAEPParameterSpec.class);
                this.init(opmode, key, random, spec);
            }
            catch (InvalidParameterSpecException ipse) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Wrong parameter");
                iape.initCause(ipse);
                throw iape;
            }
        }
    }

    private void init(int opmode, Key key, SecureRandom random, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int n;
        boolean encrypt;
        switch (opmode) {
            case 1: 
            case 3: {
                encrypt = true;
                break;
            }
            case 2: 
            case 4: {
                encrypt = false;
                break;
            }
            default: {
                throw new InvalidKeyException("Unknown mode: " + opmode);
            }
        }
        RSAKey rsaKey = RSAKeyFactory.toRSAKey(key);
        if (key instanceof RSAPublicKey) {
            this.mode = encrypt ? 1 : 4;
            this.publicKey = (RSAPublicKey)key;
            this.privateKey = null;
        } else {
            this.mode = encrypt ? 3 : 2;
            this.privateKey = (RSAPrivateKey)key;
            this.publicKey = null;
        }
        this.outputSize = n = RSACore.getByteLength(rsaKey.getModulus());
        this.bufOfs = 0;
        if (this.paddingType == PAD_NONE) {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Parameters not supported");
            }
            this.padding = RSAPadding.getInstance(3, n, random);
            this.buffer = new byte[n];
        } else if (this.paddingType == PAD_PKCS1) {
            if (params != null) {
                if (!(params instanceof TlsRsaPremasterSecretParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Parameters not supported");
                }
                this.spec = params;
                this.forTlsPremasterSecret = true;
                this.random = random;
            }
            int blockType = this.mode <= 2 ? 2 : 1;
            this.padding = RSAPadding.getInstance(blockType, n, random);
            if (encrypt) {
                int k = this.padding.getMaxDataSize();
                this.buffer = new byte[k];
            } else {
                this.buffer = new byte[n];
            }
        } else {
            if (this.mode == 3 || this.mode == 4) {
                throw new InvalidKeyException("OAEP cannot be used to sign or verify signatures");
            }
            if (params != null) {
                if (!(params instanceof OAEPParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Wrong Parameters for OAEP Padding");
                }
                this.spec = params;
            } else {
                this.spec = new OAEPParameterSpec(this.oaepHashAlgorithm, "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
            }
            this.padding = RSAPadding.getInstance(4, n, random, (OAEPParameterSpec)this.spec);
            if (encrypt) {
                int k = this.padding.getMaxDataSize();
                this.buffer = new byte[k];
            } else {
                this.buffer = new byte[n];
            }
        }
    }

    private void update(byte[] in, int inOfs, int inLen) {
        if (inLen == 0 || in == null) {
            return;
        }
        if (inLen > this.buffer.length - this.bufOfs) {
            this.bufOfs = this.buffer.length + 1;
            return;
        }
        System.arraycopy(in, inOfs, this.buffer, this.bufOfs, inLen);
        this.bufOfs += inLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
        if (this.bufOfs > this.buffer.length) {
            throw new IllegalBlockSizeException("Data must not be longer than " + this.buffer.length + " bytes");
        }
        byte[] paddingCopy = null;
        byte[] result = null;
        try {
            switch (this.mode) {
                case 3: {
                    paddingCopy = this.padding.pad(this.buffer, 0, this.bufOfs);
                    if (paddingCopy != null) {
                        result = RSACore.rsa(paddingCopy, this.privateKey, true);
                        break;
                    }
                    throw new BadPaddingException("Padding error in signing");
                }
                case 4: {
                    byte[] verifyBuffer = RSACore.convert(this.buffer, 0, this.bufOfs);
                    paddingCopy = RSACore.rsa(verifyBuffer, this.publicKey);
                    result = this.padding.unpad(paddingCopy);
                    if (result != null) break;
                    throw new BadPaddingException("Padding error in verification");
                }
                case 1: {
                    paddingCopy = this.padding.pad(this.buffer, 0, this.bufOfs);
                    if (paddingCopy != null) {
                        result = RSACore.rsa(paddingCopy, this.publicKey);
                        break;
                    }
                    throw new BadPaddingException("Padding error in encryption");
                }
                case 2: {
                    byte[] decryptBuffer = RSACore.convert(this.buffer, 0, this.bufOfs);
                    paddingCopy = RSACore.rsa(decryptBuffer, this.privateKey, false);
                    result = this.padding.unpad(paddingCopy);
                    if (result != null || this.forTlsPremasterSecret) break;
                    throw new BadPaddingException("Padding error in decryption");
                }
                default: {
                    throw new AssertionError((Object)"Internal error");
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            Arrays.fill(this.buffer, 0, this.bufOfs, (byte)0);
            this.bufOfs = 0;
            if (paddingCopy != null && paddingCopy != this.buffer && paddingCopy != result) {
                Arrays.fill(paddingCopy, (byte)0);
            }
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOfs, int inLen) {
        this.update(in, inOfs, inLen);
        return B0;
    }

    @Override
    protected int engineUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) {
        this.update(in, inOfs, inLen);
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] in, int inOfs, int inLen) throws BadPaddingException, IllegalBlockSizeException {
        this.update(in, inOfs, inLen);
        return this.doFinal();
    }

    @Override
    protected int engineDoFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException, BadPaddingException, IllegalBlockSizeException {
        if (this.outputSize > out.length - outOfs) {
            throw new ShortBufferException("Need " + this.outputSize + " bytes for output");
        }
        this.update(in, inOfs, inLen);
        byte[] result = this.doFinal();
        int n = result.length;
        System.arraycopy(result, 0, out, outOfs, n);
        Arrays.fill(result, (byte)0);
        return n;
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] encoded = key.getEncoded();
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("Could not obtain encoded key");
        }
        try {
            if (encoded.length > this.buffer.length) {
                throw new InvalidKeyException("Key is too long for wrapping");
            }
            this.update(encoded, 0, encoded.length);
            try {
                byte[] byArray = this.doFinal();
                return byArray;
            }
            catch (BadPaddingException e) {
                throw new InvalidKeyException("Wrapping failed", e);
            }
        }
        finally {
            Arrays.fill(encoded, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String algorithm, int type) throws InvalidKeyException, NoSuchAlgorithmException {
        if (wrappedKey.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for unwrapping");
        }
        boolean isTlsRsaPremasterSecret = algorithm.equals("TlsRsaPremasterSecret");
        byte[] encoded = null;
        this.update(wrappedKey, 0, wrappedKey.length);
        try {
            encoded = this.doFinal();
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidKeyException("Unwrapping failed", e);
        }
        try {
            if (isTlsRsaPremasterSecret) {
                if (!this.forTlsPremasterSecret) {
                    throw new IllegalStateException("No TlsRsaPremasterSecretParameterSpec specified");
                }
                encoded = KeyUtil.checkTlsPreMasterSecretKey(((TlsRsaPremasterSecretParameterSpec)this.spec).getClientVersion(), ((TlsRsaPremasterSecretParameterSpec)this.spec).getServerVersion(), this.random, encoded, encoded == null);
            }
            Key key = ConstructKeys.constructKey(encoded, algorithm, type);
            return key;
        }
        finally {
            if (encoded != null) {
                Arrays.fill(encoded, (byte)0);
            }
        }
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        RSAKey rsaKey = RSAKeyFactory.toRSAKey(key);
        return rsaKey.getModulus().bitLength();
    }
}

