/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.MessageDigestSpi;
import java.security.ProviderException;
import javax.crypto.SecretKey;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.MessageDigestSpi2;

final class P11Digest
extends MessageDigestSpi
implements Cloneable,
MessageDigestSpi2 {
    private static final int S_BLANK = 1;
    private static final int S_BUFFERED = 2;
    private static final int S_INIT = 3;
    private static final int BUFFER_SIZE = 96;
    private final Token token;
    private final String algorithm;
    private final CK_MECHANISM mechanism;
    private final int digestLength;
    private Session session;
    private int state;
    private byte[] buffer;
    private int bufOfs;

    P11Digest(Token token, String algorithm, long mechanism) {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = new CK_MECHANISM(mechanism);
        switch ((int)mechanism) {
            case 512: 
            case 528: {
                this.digestLength = 16;
                break;
            }
            case 544: {
                this.digestLength = 20;
                break;
            }
            case 72: 
            case 597: {
                this.digestLength = 28;
                break;
            }
            case 76: 
            case 592: {
                this.digestLength = 32;
                break;
            }
            case 608: {
                this.digestLength = 48;
                break;
            }
            case 624: {
                this.digestLength = 64;
                break;
            }
            default: {
                throw new ProviderException("Unknown mechanism: " + mechanism);
            }
        }
        this.buffer = new byte[96];
        this.state = 1;
    }

    @Override
    protected int engineGetDigestLength() {
        return this.digestLength;
    }

    private void fetchSession() {
        this.token.ensureValid();
        if (this.state == 1) {
            try {
                this.session = this.token.getOpSession();
                this.state = 2;
            }
            catch (PKCS11Exception e) {
                throw new ProviderException("No more session available", e);
            }
        }
    }

    @Override
    protected void engineReset() {
        this.token.ensureValid();
        if (this.session != null) {
            this.session = this.state == 3 && this.token.explicitCancel && !this.session.hasObjects() ? this.token.killSession(this.session) : this.token.releaseSession(this.session);
        }
        this.state = 1;
        this.bufOfs = 0;
    }

    @Override
    protected byte[] engineDigest() {
        try {
            byte[] digest = new byte[this.digestLength];
            int n = this.engineDigest(digest, 0, this.digestLength);
            return digest;
        }
        catch (DigestException e) {
            throw new ProviderException("internal error", e);
        }
    }

    @Override
    protected int engineDigest(byte[] digest, int ofs, int len) throws DigestException {
        if (len < this.digestLength) {
            throw new DigestException("Length must be at least " + this.digestLength);
        }
        this.fetchSession();
        try {
            int n;
            if (this.state == 2) {
                n = this.token.p11.C_DigestSingle(this.session.id(), this.mechanism, this.buffer, 0, this.bufOfs, digest, ofs, len);
                this.bufOfs = 0;
            } else {
                if (this.bufOfs != 0) {
                    this.token.p11.C_DigestUpdate(this.session.id(), 0L, this.buffer, 0, this.bufOfs);
                    this.bufOfs = 0;
                }
                n = this.token.p11.C_DigestFinal(this.session.id(), digest, ofs, len);
            }
            if (n != this.digestLength) {
                throw new ProviderException("internal digest length error");
            }
            int n2 = n;
            return n2;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("digest() failed", e);
        }
        finally {
            this.engineReset();
        }
    }

    @Override
    protected void engineUpdate(byte in) {
        byte[] temp = new byte[]{in};
        this.engineUpdate(temp, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] in, int ofs, int len) {
        if (len <= 0) {
            return;
        }
        this.fetchSession();
        try {
            if (this.state == 2) {
                this.token.p11.C_DigestInit(this.session.id(), this.mechanism);
                this.state = 3;
            }
            if (this.bufOfs != 0 && this.bufOfs + len > this.buffer.length) {
                this.token.p11.C_DigestUpdate(this.session.id(), 0L, this.buffer, 0, this.bufOfs);
                this.bufOfs = 0;
            }
            if (this.bufOfs + len > this.buffer.length) {
                this.token.p11.C_DigestUpdate(this.session.id(), 0L, in, ofs, len);
            } else {
                System.arraycopy(in, ofs, this.buffer, this.bufOfs, len);
                this.bufOfs += len;
            }
        }
        catch (PKCS11Exception e) {
            this.engineReset();
            throw new ProviderException("update() failed", e);
        }
    }

    @Override
    public void engineUpdate(SecretKey key) throws InvalidKeyException {
        if (!(key instanceof P11Key)) {
            throw new InvalidKeyException("Not a P11Key: " + key);
        }
        P11Key p11Key = (P11Key)((Object)key);
        if (p11Key.token != this.token) {
            throw new InvalidKeyException("Not a P11Key of this provider: " + key);
        }
        this.fetchSession();
        long p11KeyID = p11Key.getKeyID();
        try {
            if (this.state == 2) {
                this.token.p11.C_DigestInit(this.session.id(), this.mechanism);
                this.state = 3;
            }
            if (this.bufOfs != 0) {
                this.token.p11.C_DigestUpdate(this.session.id(), 0L, this.buffer, 0, this.bufOfs);
                this.bufOfs = 0;
            }
            this.token.p11.C_DigestKey(this.session.id(), p11KeyID);
        }
        catch (PKCS11Exception e) {
            this.engineReset();
            throw new ProviderException("update(SecretKey) failed", e);
        }
        finally {
            p11Key.releaseKeyID();
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        int len = byteBuffer.remaining();
        if (len <= 0) {
            return;
        }
        if (!(byteBuffer instanceof DirectBuffer)) {
            super.engineUpdate(byteBuffer);
            return;
        }
        this.fetchSession();
        long addr = ((DirectBuffer)((Object)byteBuffer)).address();
        int ofs = byteBuffer.position();
        try {
            if (this.state == 2) {
                this.token.p11.C_DigestInit(this.session.id(), this.mechanism);
                this.state = 3;
            }
            if (this.bufOfs != 0) {
                this.token.p11.C_DigestUpdate(this.session.id(), 0L, this.buffer, 0, this.bufOfs);
                this.bufOfs = 0;
            }
            this.token.p11.C_DigestUpdate(this.session.id(), addr + (long)ofs, null, 0, len);
            byteBuffer.position(ofs + len);
        }
        catch (PKCS11Exception e) {
            this.engineReset();
            throw new ProviderException("update() failed", e);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        P11Digest copy = (P11Digest)super.clone();
        copy.buffer = (byte[])this.buffer.clone();
        try {
            if (this.session != null) {
                copy.session = copy.token.getOpSession();
            }
            if (this.state == 3) {
                byte[] stateValues = this.token.p11.C_GetOperationState(this.session.id());
                this.token.p11.C_SetOperationState(copy.session.id(), stateValues, 0L, 0L);
            }
        }
        catch (PKCS11Exception e) {
            throw (CloneNotSupportedException)new CloneNotSupportedException(this.algorithm).initCause(e);
        }
        return copy;
    }
}

