/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import sun.security.pkcs11.P11ECKeyFactory;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_ECDH1_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11ECDHKeyAgreement
extends KeyAgreementSpi {
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private P11Key privateKey;
    private byte[] publicValue;
    private int secretLen;

    P11ECDHKeyAgreement(Token token, String algorithm, long mechanism) {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Key must be instance of PrivateKey");
        }
        this.privateKey = P11KeyFactory.convertKey(this.token, key, "EC");
        this.publicValue = null;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.engineInit(key, random);
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.publicValue != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!lastPhase) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Key must be a PublicKey with algorithm EC");
        }
        ECPublicKey ecKey = (ECPublicKey)key;
        int keyLenBits = ecKey.getParams().getCurve().getField().getFieldSize();
        this.secretLen = keyLenBits + 7 >> 3;
        this.publicValue = P11ECKeyFactory.getEncodedPublicValue(ecKey);
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.privateKey == null || this.publicValue == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        Session session = null;
        long privKeyID = this.privateKey.getKeyID();
        try {
            session = this.token.getOpSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, 16L)};
            CK_ECDH1_DERIVE_PARAMS ckParams = new CK_ECDH1_DERIVE_PARAMS(1L, null, this.publicValue);
            attributes = this.token.getAttributes("generate", 4L, 16L, attributes);
            long keyID = this.token.p11.C_DeriveKey(session.id(), new CK_MECHANISM(this.mechanism, ckParams), privKeyID, attributes);
            attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
            this.token.p11.C_GetAttributeValue(session.id(), keyID, attributes);
            byte[] secret = attributes[0].getByteArray();
            this.token.p11.C_DestroyObject(session.id(), keyID);
            byte[] byArray = secret;
            return byArray;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("Could not derive key", e);
        }
        finally {
            this.privateKey.releaseKeyID();
            this.publicValue = null;
            this.token.releaseSession(session);
        }
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (offset + this.secretLen > sharedSecret.length) {
            throw new ShortBufferException("Need " + this.secretLen + " bytes, only " + (sharedSecret.length - offset) + " available");
        }
        byte[] secret = this.engineGenerateSecret();
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (!algorithm.equals("TlsPremasterSecret")) {
            throw new NoSuchAlgorithmException("Only supported for algorithm TlsPremasterSecret");
        }
        return this.nativeGenerateSecret(algorithm);
    }

    private SecretKey nativeGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (this.privateKey == null || this.publicValue == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        long keyType = 16L;
        Session session = null;
        long privKeyID = this.privateKey.getKeyID();
        try {
            SecretKey key;
            session = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, keyType)};
            CK_ECDH1_DERIVE_PARAMS ckParams = new CK_ECDH1_DERIVE_PARAMS(1L, null, this.publicValue);
            attributes = this.token.getAttributes("generate", 4L, keyType, attributes);
            long keyID = this.token.p11.C_DeriveKey(session.id(), new CK_MECHANISM(this.mechanism, ckParams), privKeyID, attributes);
            CK_ATTRIBUTE[] lenAttributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(353L)};
            this.token.p11.C_GetAttributeValue(session.id(), keyID, lenAttributes);
            int keyLen = (int)lenAttributes[0].getLong();
            SecretKey secretKey = key = P11Key.secretKey(session, keyID, algorithm, keyLen << 3, attributes);
            return secretKey;
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not derive key", e);
        }
        finally {
            this.privateKey.releaseKeyID();
            this.publicValue = null;
            this.token.releaseSession(session);
        }
    }
}

