/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11.wrapper;

import java.math.BigInteger;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.wrapper.CK_AES_CTR_PARAMS;
import sun.security.pkcs11.wrapper.CK_CCM_PARAMS;
import sun.security.pkcs11.wrapper.CK_ECDH1_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_GCM_PARAMS;
import sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_KEY_MAT_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_MASTER_KEY_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_TLS12_KEY_MAT_PARAMS;
import sun.security.pkcs11.wrapper.CK_TLS12_MASTER_KEY_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_TLS_MAC_PARAMS;
import sun.security.pkcs11.wrapper.CK_TLS_PRF_PARAMS;
import sun.security.pkcs11.wrapper.CK_VERSION;
import sun.security.pkcs11.wrapper.Constants;
import sun.security.pkcs11.wrapper.PKCS11;

public class CK_MECHANISM {
    public long mechanism;
    public Object pParameter = null;
    private long pHandle = 0L;

    public CK_MECHANISM(long mechanism) {
        this.mechanism = mechanism;
    }

    public CK_MECHANISM(long mechanism, byte[] pParameter) {
        this.init(mechanism, pParameter);
    }

    public CK_MECHANISM(long mechanism, BigInteger b) {
        this.init(mechanism, P11Util.getMagnitude(b));
    }

    public CK_MECHANISM(long mechanism, CK_VERSION version) {
        this.init(mechanism, version);
    }

    public CK_MECHANISM(long mechanism, CK_SSL3_MASTER_KEY_DERIVE_PARAMS params) {
        this.init(mechanism, params);
    }

    public CK_MECHANISM(long mechanism, CK_TLS12_MASTER_KEY_DERIVE_PARAMS params) {
        this.init(mechanism, params);
    }

    public CK_MECHANISM(long mechanism, CK_SSL3_KEY_MAT_PARAMS params) {
        this.init(mechanism, params);
    }

    public CK_MECHANISM(long mechanism, CK_TLS12_KEY_MAT_PARAMS params) {
        this.init(mechanism, params);
    }

    public CK_MECHANISM(long mechanism, CK_TLS_PRF_PARAMS params) {
        this.init(mechanism, params);
    }

    public CK_MECHANISM(long mechanism, CK_TLS_MAC_PARAMS params) {
        this.init(mechanism, params);
    }

    public CK_MECHANISM(long mechanism, CK_ECDH1_DERIVE_PARAMS params) {
        this.init(mechanism, params);
    }

    public CK_MECHANISM(long mechanism, Long params) {
        this.init(mechanism, params);
    }

    public CK_MECHANISM(long mechanism, CK_AES_CTR_PARAMS params) {
        this.init(mechanism, params);
    }

    public CK_MECHANISM(long mechanism, CK_GCM_PARAMS params) {
        this.init(mechanism, params);
    }

    public CK_MECHANISM(long mechanism, CK_CCM_PARAMS params) {
        this.init(mechanism, params);
    }

    public void setParameter(CK_RSA_PKCS_PSS_PARAMS params) {
        assert (this.mechanism == 13L);
        assert (params != null);
        if (this.pParameter != null && this.pParameter.equals(params)) {
            return;
        }
        this.freeHandle();
        this.pParameter = params;
    }

    public void freeHandle() {
        if (this.pHandle != 0L) {
            this.pHandle = PKCS11.freeMechanism(this.pHandle);
        }
    }

    private void init(long mechanism, Object pParameter) {
        this.mechanism = mechanism;
        this.pParameter = pParameter;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  ");
        buffer.append("mechanism: ");
        buffer.append(this.mechanism);
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("pParameter: ");
        buffer.append(this.pParameter.toString());
        buffer.append(Constants.NEWLINE);
        if (this.pHandle != 0L) {
            buffer.append("  ");
            buffer.append("pHandle: ");
            buffer.append(this.pHandle);
            buffer.append(Constants.NEWLINE);
        }
        return buffer.toString();
    }
}

