/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11.wrapper;

import java.security.ProviderException;
import sun.security.pkcs11.wrapper.Constants;
import sun.security.pkcs11.wrapper.Functions;

public class CK_RSA_PKCS_PSS_PARAMS {
    private final long hashAlg;
    private final long mgf;
    private final long sLen;

    public CK_RSA_PKCS_PSS_PARAMS(String hashAlg, String mgfAlg, String mgfHash, int sLen) {
        this.hashAlg = Functions.getHashMechId(hashAlg);
        if (!mgfAlg.equals("MGF1")) {
            throw new ProviderException("Only MGF1 is supported");
        }
        this.mgf = Functions.getMGFId("CKG_MGF1_" + hashAlg.replaceFirst("-", ""));
        this.sLen = sLen;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CK_RSA_PKCS_PSS_PARAMS)) {
            return false;
        }
        CK_RSA_PKCS_PSS_PARAMS other = (CK_RSA_PKCS_PSS_PARAMS)o;
        return other.hashAlg == this.hashAlg && other.mgf == this.mgf && other.sLen == this.sLen;
    }

    public int hashCode() {
        return (int)(this.hashAlg << (int)(2L + this.mgf) << (int)(1L + this.sLen));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  ");
        buffer.append("hashAlg: ");
        buffer.append(Functions.toFullHexString(this.hashAlg));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("mgf: ");
        buffer.append(Functions.toFullHexString(this.mgf));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("sLen(in bytes): ");
        buffer.append(this.sLen);
        return buffer.toString();
    }
}

