/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11.wrapper;

import java.util.HashMap;
import java.util.Map;
import sun.security.pkcs11.wrapper.Functions;

public class PKCS11Exception
extends Exception {
    private static final long serialVersionUID = 4877072363729195L;
    protected long errorCode_;
    private static final Map<Long, String> errorMap;

    public PKCS11Exception(long errorCode) {
        this.errorCode_ = errorCode;
    }

    @Override
    public String getMessage() {
        String message = errorMap.get(this.errorCode_);
        if (message == null) {
            message = "0x" + Functions.toFullHexString((int)this.errorCode_);
        }
        return message;
    }

    public long getErrorCode() {
        return this.errorCode_;
    }

    static {
        long[] errorCodes = new long[]{0L, 1L, 2L, 3L, 5L, 6L, 7L, 8L, 9L, 10L, 16L, 17L, 18L, 19L, 27L, 32L, 33L, 48L, 49L, 50L, 64L, 65L, 66L, 80L, 81L, 84L, 96L, 98L, 99L, 100L, 101L, 102L, 103L, 104L, 105L, 106L, 112L, 113L, 130L, 144L, 145L, 160L, 161L, 162L, 163L, 164L, 176L, 177L, 179L, 180L, 181L, 182L, 183L, 184L, 192L, 193L, 208L, 209L, 224L, 225L, 226L, 240L, 241L, 242L, 256L, 257L, 258L, 259L, 260L, 261L, 272L, 274L, 275L, 276L, 277L, 288L, 289L, 304L, 320L, 336L, 352L, 368L, 384L, 400L, 401L, 416L, 417L, 432L, 433L, 437L, 438L, 439L, 440L, 441L, 512L, 513L, 514L, 0x80000000L};
        String[] errorMessages = new String[]{"CKR_OK", "CKR_CANCEL", "CKR_HOST_MEMORY", "CKR_SLOT_ID_INVALID", "CKR_GENERAL_ERROR", "CKR_FUNCTION_FAILED", "CKR_ARGUMENTS_BAD", "CKR_NO_EVENT", "CKR_NEED_TO_CREATE_THREADS", "CKR_CANT_LOCK", "CKR_ATTRIBUTE_READ_ONLY", "CKR_ATTRIBUTE_SENSITIVE", "CKR_ATTRIBUTE_TYPE_INVALID", "CKR_ATTRIBUTE_VALUE_INVALID", "CKR_ACTION_PROHIBITED", "CKR_DATA_INVALID", "CKR_DATA_LEN_RANGE", "CKR_DEVICE_ERROR", "CKR_DEVICE_MEMORY", "CKR_DEVICE_REMOVED", "CKR_ENCRYPTED_DATA_INVALID", "CKR_ENCRYPTED_DATA_LEN_RANGE", "CKR_AEAD_DECRYPT_FAILED", "CKR_FUNCTION_CANCELED", "CKR_FUNCTION_NOT_PARALLEL", "CKR_FUNCTION_NOT_SUPPORTED", "CKR_KEY_HANDLE_INVALID", "CKR_KEY_SIZE_RANGE", "CKR_KEY_TYPE_INCONSISTENT", "CKR_KEY_NOT_NEEDED", "CKR_KEY_CHANGED", "CKR_KEY_NEEDED", "CKR_KEY_INDIGESTIBLE", "CKR_KEY_FUNCTION_NOT_PERMITTED", "CKR_KEY_NOT_WRAPPABLE", "CKR_KEY_UNEXTRACTABLE", "CKR_MECHANISM_INVALID", "CKR_MECHANISM_PARAM_INVALID", "CKR_OBJECT_HANDLE_INVALID", "CKR_OPERATION_ACTIVE", "CKR_OPERATION_NOT_INITIALIZED", "CKR_PIN_INCORRECT", "CKR_PIN_INVALID", "CKR_PIN_LEN_RANGE", "CKR_PIN_EXPIRED", "CKR_PIN_LOCKED", "CKR_SESSION_CLOSED", "CKR_SESSION_COUNT", "CKR_SESSION_HANDLE_INVALID", "CKR_SESSION_PARALLEL_NOT_SUPPORTED", "CKR_SESSION_READ_ONLY", "CKR_SESSION_EXISTS", "CKR_SESSION_READ_ONLY_EXISTS", "CKR_SESSION_READ_WRITE_SO_EXISTS", "CKR_SIGNATURE_INVALID", "CKR_SIGNATURE_LEN_RANGE", "CKR_TEMPLATE_INCOMPLETE", "CKR_TEMPLATE_INCONSISTENT", "CKR_TOKEN_NOT_PRESENT", "CKR_TOKEN_NOT_RECOGNIZED", "CKR_TOKEN_WRITE_PROTECTED", "CKR_UNWRAPPING_KEY_HANDLE_INVALID", "CKR_UNWRAPPING_KEY_SIZE_RANGE", "CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT", "CKR_USER_ALREADY_LOGGED_IN", "CKR_USER_NOT_LOGGED_IN", "CKR_USER_PIN_NOT_INITIALIZED", "CKR_USER_TYPE_INVALID", "CKR_USER_ANOTHER_ALREADY_LOGGED_IN", "CKR_USER_TOO_MANY_TYPES", "CKR_WRAPPED_KEY_INVALID", "CKR_WRAPPED_KEY_LEN_RANGE", "CKR_WRAPPING_KEY_HANDLE_INVALID", "CKR_WRAPPING_KEY_SIZE_RANGE", "CKR_WRAPPING_KEY_TYPE_INCONSISTENT", "CKR_RANDOM_SEED_NOT_SUPPORTED", "CKR_RANDOM_NO_RNG", "CKR_DOMAIN_PARAMS_INVALID", "CKR_CURVE_NOT_SUPPORTED", "CKR_BUFFER_TOO_SMALL", "CKR_SAVED_STATE_INVALID", "CKR_INFORMATION_SENSITIVE", "CKR_STATE_UNSAVEABLE", "CKR_CRYPTOKI_NOT_INITIALIZED", "CKR_CRYPTOKI_ALREADY_INITIALIZED", "CKR_MUTEX_BAD", "CKR_MUTEX_NOT_LOCKED", "CKR_NEW_PIN_MODE", "CKR_NEXT_OTP", "CKR_EXCEEDED_MAX_ITERATIONS", "CKR_FIPS_SELF_TEST_FAILED", "CKR_LIBRARY_LOAD_FAILED", "CKR_PIN_TOO_WEAK", "CKR_PUBLIC_KEY_INVALID", "CKR_FUNCTION_REJECTED", "CKR_TOKEN_RESOURCE_EXCEEDED", "CKR_OPERATION_CANCEL_FAILED", "CKR_VENDOR_DEFINED"};
        errorMap = new HashMap<Long, String>();
        for (int i = 0; i < errorCodes.length; ++i) {
            errorMap.put(errorCodes[i], errorMessages[i]);
        }
    }
}

