/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.util.List;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedClass;
import jdk.jfr.consumer.RecordedClassLoader;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedMethod;
import jdk.jfr.consumer.RecordedStackTrace;
import jdk.jfr.consumer.RecordedThread;
import jdk.jfr.consumer.RecordedThreadGroup;
import jdk.jfr.consumer.TimeConverter;
import jdk.jfr.internal.Type;

abstract class ObjectFactory<T> {
    static final String TYPE_PREFIX_VERSION_1 = "com.oracle.jfr.types.";
    static final String TYPE_PREFIX_VERSION_2 = "jdk.types.";
    static final String STACK_FRAME_VERSION_1 = "com.oracle.jfr.types.StackFrame";
    static final String STACK_FRAME_VERSION_2 = "jdk.types.StackFrame";
    private final List<ValueDescriptor> valueDescriptors;

    public static ObjectFactory<?> create(Type type, TimeConverter timeConverter) {
        switch (type.getName()) {
            case "java.lang.Thread": {
                return RecordedThread.createFactory(type, timeConverter);
            }
            case "com.oracle.jfr.types.StackFrame": 
            case "jdk.types.StackFrame": {
                return RecordedFrame.createFactory(type, timeConverter);
            }
            case "com.oracle.jfr.types.Method": 
            case "jdk.types.Method": {
                return RecordedMethod.createFactory(type, timeConverter);
            }
            case "com.oracle.jfr.types.ThreadGroup": 
            case "jdk.types.ThreadGroup": {
                return RecordedThreadGroup.createFactory(type, timeConverter);
            }
            case "com.oracle.jfr.types.StackTrace": 
            case "jdk.types.StackTrace": {
                return RecordedStackTrace.createFactory(type, timeConverter);
            }
            case "com.oracle.jfr.types.ClassLoader": 
            case "jdk.types.ClassLoader": {
                return RecordedClassLoader.createFactory(type, timeConverter);
            }
            case "java.lang.Class": {
                return RecordedClass.createFactory(type, timeConverter);
            }
        }
        return null;
    }

    ObjectFactory(Type type) {
        this.valueDescriptors = type.getFields();
    }

    T createObject(long id, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            return this.createTyped(this.valueDescriptors, id, (Object[])value);
        }
        throw new InternalError("Object factory must have struct type");
    }

    abstract T createTyped(List<ValueDescriptor> var1, long var2, Object[] var4);
}

