/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import jdk.internal.org.objectweb.asm.commons.GeneratorAdapter;
import jdk.internal.org.objectweb.asm.commons.Method;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Event;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.ASMToolkit;
import jdk.jfr.internal.SecuritySupport;

public final class EventClassBuilder {
    private static final Type TYPE_EVENT = Type.getType(Event.class);
    private static final Type TYPE_IOBE = Type.getType(IndexOutOfBoundsException.class);
    private static final Method DEFAULT_CONSTRUCTOR = Method.getMethod("void <init> ()");
    private static final Method SET_METHOD = Method.getMethod("void set (int, java.lang.Object)");
    private static final AtomicLong idCounter = new AtomicLong();
    private final ClassWriter classWriter = new ClassWriter(3);
    private final String fullClassName = "jdk.jfr.DynamicEvent" + idCounter.incrementAndGet();
    private final Type type = Type.getType(this.fullClassName.replace(".", "/"));
    private final List<ValueDescriptor> fields;
    private final List<AnnotationElement> annotationElements;

    public EventClassBuilder(List<AnnotationElement> annotationElements, List<ValueDescriptor> fields) {
        this.fields = fields;
        this.annotationElements = annotationElements;
    }

    public Class<? extends Event> build() {
        this.buildClassInfo();
        this.buildConstructor();
        this.buildFields();
        this.buildSetMethod();
        this.endClass();
        byte[] bytes = this.classWriter.toByteArray();
        ASMToolkit.logASM(this.fullClassName, bytes);
        return SecuritySupport.defineClass(this.type.getInternalName(), bytes, Event.class.getClassLoader()).asSubclass(Event.class);
    }

    private void endClass() {
        this.classWriter.visitEnd();
    }

    private void buildSetMethod() {
        GeneratorAdapter ga = new GeneratorAdapter(1, SET_METHOD, null, null, this.classWriter);
        int index = 0;
        for (ValueDescriptor v : this.fields) {
            ga.loadArg(0);
            ga.visitLdcInsn(index);
            Label notEqual = new Label();
            ga.ifICmp(154, notEqual);
            ga.loadThis();
            ga.loadArg(1);
            Type fieldType = ASMToolkit.toType(v);
            ga.unbox(ASMToolkit.toType(v));
            ga.putField(this.type, v.getName(), fieldType);
            ga.visitInsn(177);
            ga.visitLabel(notEqual);
            ++index;
        }
        ga.throwException(TYPE_IOBE, "Index must between 0 and " + this.fields.size());
        ga.endMethod();
    }

    private void buildConstructor() {
        MethodVisitor mv = this.classWriter.visitMethod(1, DEFAULT_CONSTRUCTOR.getName(), DEFAULT_CONSTRUCTOR.getDescriptor(), null, null);
        mv.visitIntInsn(25, 0);
        ASMToolkit.invokeSpecial(mv, TYPE_EVENT.getInternalName(), DEFAULT_CONSTRUCTOR);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }

    private void buildClassInfo() {
        String internalSuperName = ASMToolkit.getInternalName(Event.class.getName());
        String internalClassName = this.type.getInternalName();
        this.classWriter.visit(52, 49, internalClassName, null, internalSuperName, null);
        for (AnnotationElement a : this.annotationElements) {
            String descriptor = ASMToolkit.getDescriptor(a.getTypeName());
            AnnotationVisitor av = this.classWriter.visitAnnotation(descriptor, true);
            for (ValueDescriptor v : a.getValueDescriptors()) {
                Object value = a.getValue(v.getName());
                String name = v.getName();
                if (v.isArray()) {
                    AnnotationVisitor arrayVisitor = av.visitArray(name);
                    Object[] array = (Object[])value;
                    for (int i = 0; i < array.length; ++i) {
                        arrayVisitor.visit(null, array[i]);
                    }
                    arrayVisitor.visitEnd();
                    continue;
                }
                av.visit(name, value);
            }
            av.visitEnd();
        }
    }

    private void buildFields() {
        for (ValueDescriptor v : this.fields) {
            String internal = ASMToolkit.getDescriptor(v.getTypeName());
            this.classWriter.visitField(2, v.getName(), internal, null, null);
        }
    }
}

