/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import jdk.jfr.internal.JVM;
import jdk.jfr.internal.SecuritySupport;
import sun.misc.Unsafe;

public final class Options {
    private static final JVM jvm = JVM.getJVM();
    private static final long WAIT_INTERVAL = 1000L;
    private static final long MIN_MAX_CHUNKSIZE = 0x100000L;
    private static final long DEFAULT_GLOBAL_BUFFER_COUNT = 20L;
    private static final long DEFAULT_GLOBAL_BUFFER_SIZE = 524288L;
    private static final long DEFAULT_MEMORY_SIZE = 0xA00000L;
    private static long DEFAULT_THREAD_BUFFER_SIZE;
    private static final int DEFAULT_STACK_DEPTH = 64;
    private static final boolean DEFAULT_SAMPLE_THREADS = true;
    private static final long DEFAULT_MAX_CHUNK_SIZE = 0xC00000L;
    private static final SecuritySupport.SafePath DEFAULT_DUMP_PATH;
    private static long memorySize;
    private static long globalBufferSize;
    private static long globalBufferCount;
    private static long threadBufferSize;
    private static int stackDepth;
    private static boolean sampleThreads;
    private static long maxChunkSize;
    private static SecuritySupport.SafePath dumpPath;

    public static synchronized void setMaxChunkSize(long max) {
        if (max < 0x100000L) {
            throw new IllegalArgumentException("Max chunk size must be at least 1048576");
        }
        jvm.setFileNotification(max);
        maxChunkSize = max;
    }

    public static synchronized long getMaxChunkSize() {
        return maxChunkSize;
    }

    public static synchronized void setMemorySize(long memSize) {
        jvm.setMemorySize(memSize);
        memorySize = memSize;
    }

    public static synchronized long getMemorySize() {
        return memorySize;
    }

    public static synchronized void setThreadBufferSize(long threadBufSize) {
        jvm.setThreadBufferSize(threadBufSize);
        threadBufferSize = threadBufSize;
    }

    public static synchronized long getThreadBufferSize() {
        return threadBufferSize;
    }

    public static synchronized long getGlobalBufferSize() {
        return globalBufferSize;
    }

    public static synchronized void setGlobalBufferCount(long globalBufCount) {
        jvm.setGlobalBufferCount(globalBufCount);
        globalBufferCount = globalBufCount;
    }

    public static synchronized long getGlobalBufferCount() {
        return globalBufferCount;
    }

    public static synchronized void setGlobalBufferSize(long globalBufsize) {
        jvm.setGlobalBufferSize(globalBufsize);
        globalBufferSize = globalBufsize;
    }

    public static synchronized void setDumpPath(SecuritySupport.SafePath path) {
        dumpPath = path;
    }

    public static synchronized SecuritySupport.SafePath getDumpPath() {
        return dumpPath;
    }

    public static synchronized void setStackDepth(Integer stackTraceDepth) {
        jvm.setStackDepth(stackTraceDepth);
        stackDepth = stackTraceDepth;
    }

    public static synchronized int getStackDepth() {
        return stackDepth;
    }

    public static synchronized void setSampleThreads(Boolean sample) {
        jvm.setSampleThreads(sample);
        sampleThreads = sample;
    }

    public static synchronized boolean getSampleThreads() {
        return sampleThreads;
    }

    private static synchronized void reset() {
        Options.setMaxChunkSize(0xC00000L);
        Options.setMemorySize(0xA00000L);
        Options.setGlobalBufferSize(524288L);
        Options.setGlobalBufferCount(20L);
        Options.setDumpPath(DEFAULT_DUMP_PATH);
        Options.setSampleThreads(true);
        Options.setStackDepth(64);
        Options.setThreadBufferSize(DEFAULT_THREAD_BUFFER_SIZE);
    }

    static synchronized long getWaitInterval() {
        return 1000L;
    }

    static void ensureInitialized() {
    }

    static {
        DEFAULT_DUMP_PATH = SecuritySupport.USER_HOME;
        long pageSize = Unsafe.getUnsafe().pageSize();
        DEFAULT_THREAD_BUFFER_SIZE = pageSize > 8192L ? pageSize : 8192L;
        Options.reset();
    }
}

