/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

public final class PlatformEventType
extends Type {
    private final boolean isJVM;
    private final boolean isJDK;
    private final boolean isMethodSampling;
    private final List<SettingDescriptor> settings = new ArrayList<SettingDescriptor>(5);
    private final boolean dynamicSettings;
    private final int stackTraceOffset;
    private boolean enabled = false;
    private boolean stackTraceEnabled = true;
    private long thresholdTicks = 0L;
    private long period = 0L;
    private boolean hasHook;
    private boolean beginChunk;
    private boolean endChunk;
    private boolean hasStackTrace = true;
    private boolean hasDuration = true;
    private boolean hasPeriod = true;
    private boolean hasCutoff = false;
    private boolean isInstrumented;
    private boolean markForInstrumentation;
    private boolean registered = true;
    private boolean commitable = this.enabled && this.registered;

    PlatformEventType(String name, long id, boolean isJDK, boolean dynamicSettings) {
        super(name, Type.SUPER_TYPE_EVENT, id);
        this.dynamicSettings = dynamicSettings;
        this.isJVM = Type.isDefinedByJVM(id);
        this.isMethodSampling = name.equals("jdk.ExecutionSample") || name.equals("jdk.NativeMethodSample");
        this.isJDK = isJDK;
        this.stackTraceOffset = PlatformEventType.stackTraceOffset(name, isJDK);
    }

    private static int stackTraceOffset(String name, boolean isJDK) {
        if (isJDK) {
            if (name.equals("jdk.JavaExceptionThrow")) {
                return 5;
            }
            if (name.equals("jdk.JavaErrorThrow")) {
                return 5;
            }
        }
        return 4;
    }

    public void add(SettingDescriptor settingDescriptor) {
        Objects.requireNonNull(settingDescriptor);
        this.settings.add(settingDescriptor);
    }

    public List<SettingDescriptor> getSettings() {
        if (this.dynamicSettings) {
            ArrayList<SettingDescriptor> list = new ArrayList<SettingDescriptor>(this.settings.size());
            for (SettingDescriptor s : this.settings) {
                if (!Utils.isSettingVisible(s.getTypeId(), this.hasHook)) continue;
                list.add(s);
            }
            return list;
        }
        return this.settings;
    }

    public List<SettingDescriptor> getAllSettings() {
        return this.settings;
    }

    public void setHasStackTrace(boolean hasStackTrace) {
        this.hasStackTrace = hasStackTrace;
    }

    public void setHasDuration(boolean hasDuration) {
        this.hasDuration = hasDuration;
    }

    public void setHasCutoff(boolean hasCutoff) {
        this.hasCutoff = hasCutoff;
    }

    public void setCutoff(long cutoffNanos) {
        if (this.isJVM) {
            long cutoffTicks = Utils.nanosToTicks(cutoffNanos);
            JVM.getJVM().setCutoff(this.getId(), cutoffTicks);
        }
    }

    public void setHasPeriod(boolean hasPeriod) {
        this.hasPeriod = hasPeriod;
    }

    public boolean hasStackTrace() {
        return this.hasStackTrace;
    }

    public boolean hasDuration() {
        return this.hasDuration;
    }

    public boolean hasPeriod() {
        return this.hasPeriod;
    }

    public boolean hasCutoff() {
        return this.hasCutoff;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isJVM() {
        return this.isJVM;
    }

    public boolean isJDK() {
        return this.isJDK;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateCommitable();
        if (this.isJVM) {
            if (this.isMethodSampling) {
                long p = enabled ? this.period : 0L;
                JVM.getJVM().setMethodSamplingInterval(this.getId(), p);
            } else {
                JVM.getJVM().setEnabled(this.getId(), enabled);
            }
        }
    }

    public void setPeriod(long periodMillis, boolean beginChunk, boolean endChunk) {
        if (this.isMethodSampling) {
            long p = this.enabled ? periodMillis : 0L;
            JVM.getJVM().setMethodSamplingInterval(this.getId(), p);
        }
        this.beginChunk = beginChunk;
        this.endChunk = endChunk;
        this.period = periodMillis;
    }

    public void setStackTraceEnabled(boolean stackTraceEnabled) {
        this.stackTraceEnabled = stackTraceEnabled;
        if (this.isJVM) {
            JVM.getJVM().setStackTraceEnabled(this.getId(), stackTraceEnabled);
        }
    }

    public void setThreshold(long thresholdNanos) {
        this.thresholdTicks = Utils.nanosToTicks(thresholdNanos);
        if (this.isJVM) {
            JVM.getJVM().setThreshold(this.getId(), this.thresholdTicks);
        }
    }

    public boolean isEveryChunk() {
        return this.period == 0L;
    }

    public boolean getStackTraceEnabled() {
        return this.stackTraceEnabled;
    }

    public long getThresholdTicks() {
        return this.thresholdTicks;
    }

    public long getPeriod() {
        return this.period;
    }

    public boolean hasEventHook() {
        return this.hasHook;
    }

    public void setEventHook(boolean hasHook) {
        this.hasHook = hasHook;
    }

    public boolean isBeginChunk() {
        return this.beginChunk;
    }

    public boolean isEndChunk() {
        return this.endChunk;
    }

    public boolean isInstrumented() {
        return this.isInstrumented;
    }

    public void setInstrumented() {
        this.isInstrumented = true;
    }

    public void markForInstrumentation(boolean markForInstrumentation) {
        this.markForInstrumentation = markForInstrumentation;
    }

    public boolean isMarkedForInstrumentation() {
        return this.markForInstrumentation;
    }

    public boolean setRegistered(boolean registered) {
        if (this.registered != registered) {
            LogTag logTag;
            this.registered = registered;
            this.updateCommitable();
            LogTag logTag2 = logTag = this.isJVM() || this.isJDK() ? LogTag.JFR_SYSTEM_EVENT : LogTag.JFR_EVENT;
            if (registered) {
                Logger.log(logTag, LogLevel.INFO, "Registered " + this.getLogName());
            } else {
                Logger.log(logTag, LogLevel.INFO, "Unregistered " + this.getLogName());
            }
            if (!registered) {
                MetadataRepository.getInstance().setUnregistered();
            }
            return true;
        }
        return false;
    }

    private void updateCommitable() {
        this.commitable = this.enabled && this.registered;
    }

    public final boolean isRegistered() {
        return this.registered;
    }

    public boolean isCommitable() {
        return this.commitable;
    }

    public int getStackTraceOffset() {
        return this.stackTraceOffset;
    }
}

