/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Event;
import jdk.jfr.SettingControl;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.AnnotationConstruct;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.PlatformEventType;

public class Type
implements Comparable<Type> {
    public static final String SUPER_TYPE_ANNOTATION = Annotation.class.getName();
    public static final String SUPER_TYPE_SETTING = SettingControl.class.getName();
    public static final String SUPER_TYPE_EVENT = Event.class.getName();
    public static final String EVENT_NAME_PREFIX = "jdk.";
    public static final String TYPES_PREFIX = "jdk.types.";
    public static final String SETTINGS_PREFIX = "jdk.settings.";
    private static final Map<Type, Class<?>> knownTypes = new HashMap();
    static final Type BOOLEAN = Type.register(Boolean.TYPE, new Type("boolean", null, 4L));
    static final Type CHAR = Type.register(Character.TYPE, new Type("char", null, 5L));
    static final Type FLOAT = Type.register(Float.TYPE, new Type("float", null, 6L));
    static final Type DOUBLE = Type.register(Double.TYPE, new Type("double", null, 7L));
    static final Type BYTE = Type.register(Byte.TYPE, new Type("byte", null, 8L));
    static final Type SHORT = Type.register(Short.TYPE, new Type("short", null, 9L));
    static final Type INT = Type.register(Integer.TYPE, new Type("int", null, 10L));
    static final Type LONG = Type.register(Long.TYPE, new Type("long", null, 11L));
    static final Type CLASS = Type.register(Class.class, new Type("java.lang.Class", null, 20L));
    static final Type STRING = Type.register(String.class, new Type("java.lang.String", null, 21L));
    static final Type THREAD = Type.register(Thread.class, new Type("java.lang.Thread", null, 22L));
    static final Type STACK_TRACE = Type.register(null, new Type("jdk.types.StackTrace", null, 23L));
    private final AnnotationConstruct annos = new AnnotationConstruct();
    private final String name;
    private final String superType;
    private final boolean constantPool;
    private final long id;
    private List<ValueDescriptor> fields = new ArrayList<ValueDescriptor>();
    private Boolean simpleType;
    private boolean remove = true;

    public Type(String javaTypeName, String superType, long typeId) {
        this(javaTypeName, superType, typeId, false);
    }

    Type(String javaTypeName, String superType, long typeId, boolean contantPool) {
        this(javaTypeName, superType, typeId, contantPool, null);
    }

    Type(String javaTypeName, String superType, long typeId, boolean contantPool, Boolean simpleType) {
        Objects.requireNonNull(javaTypeName);
        if (!Type.isValidJavaIdentifier(javaTypeName)) {
            throw new IllegalArgumentException(javaTypeName + " is not a valid Java identifier");
        }
        this.constantPool = contantPool;
        this.superType = superType;
        this.name = javaTypeName;
        this.id = typeId;
        this.simpleType = simpleType;
    }

    static boolean isDefinedByJVM(long id) {
        return id < 400L;
    }

    public static long getTypeId(Class<?> clazz) {
        Type type = Type.getKnownType(clazz);
        return type == null ? JVM.getJVM().getTypeId(clazz) : type.getId();
    }

    static Collection<Type> getKnownTypes() {
        return knownTypes.keySet();
    }

    public static boolean isValidJavaIdentifier(String identifier) {
        if (identifier.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            return false;
        }
        for (int i = 1; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaFieldType(String name) {
        for (Map.Entry<Type, Class<?>> entry : knownTypes.entrySet()) {
            Class<?> clazz = entry.getValue();
            if (clazz == null || !name.equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public static Type getKnownType(String typeName) {
        for (Type type : knownTypes.keySet()) {
            if (!type.getName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    static boolean isKnownType(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        return type.equals(Class.class) || type.equals(Thread.class) || type.equals(String.class);
    }

    public static Type getKnownType(Class<?> clazz) {
        for (Map.Entry<Type, Class<?>> entry : knownTypes.entrySet()) {
            if (clazz == null || !clazz.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getLogName() {
        return this.getName() + "(" + this.getId() + ")";
    }

    public List<ValueDescriptor> getFields() {
        if (this.fields instanceof ArrayList) {
            ((ArrayList)this.fields).trimToSize();
            this.fields = Collections.unmodifiableList(this.fields);
        }
        return this.fields;
    }

    public boolean isSimpleType() {
        if (this.simpleType == null) {
            this.simpleType = this.calculateSimpleType();
        }
        return this.simpleType;
    }

    private boolean calculateSimpleType() {
        if (this.fields.size() != 1) {
            return false;
        }
        return this.superType == null;
    }

    public boolean isDefinedByJVM() {
        return this.id < 400L;
    }

    private static Type register(Class<?> clazz, Type type) {
        knownTypes.put(type, clazz);
        return type;
    }

    public void add(ValueDescriptor valueDescriptor) {
        Objects.requireNonNull(valueDescriptor);
        this.fields.add(valueDescriptor);
    }

    void trimFields() {
        this.getFields();
    }

    void setAnnotations(List<AnnotationElement> annotations) {
        this.annos.setAnnotationElements(annotations);
    }

    public String getSuperType() {
        return this.superType;
    }

    public long getId() {
        return this.id;
    }

    public boolean isConstantPool() {
        return this.constantPool;
    }

    public String getLabel() {
        return this.annos.getLabel();
    }

    public List<AnnotationElement> getAnnotationElements() {
        return this.annos.getUnmodifiableAnnotationElements();
    }

    public <T> T getAnnotation(Class<? extends Annotation> clazz) {
        return this.annos.getAnnotation(clazz);
    }

    public String getDescription() {
        return this.annos.getDescription();
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object object) {
        if (object instanceof Type) {
            Type that = (Type)object;
            return that.id == this.id;
        }
        return false;
    }

    @Override
    public int compareTo(Type that) {
        return Long.compare(this.id, that.id);
    }

    void log(String action, LogTag logTag, LogLevel level) {
        if (Logger.shouldLog(logTag, level) && !this.isSimpleType()) {
            Logger.log(logTag, LogLevel.TRACE, action + " " + this.typeText() + " " + this.getLogName() + " {");
            for (ValueDescriptor v : this.getFields()) {
                String array = v.isArray() ? "[]" : "";
                Logger.log(logTag, LogLevel.TRACE, "  " + v.getTypeName() + array + " " + v.getName() + ";");
            }
            Logger.log(logTag, LogLevel.TRACE, "}");
        } else if (Logger.shouldLog(logTag, LogLevel.INFO) && !this.isSimpleType()) {
            Logger.log(logTag, LogLevel.INFO, action + " " + this.typeText() + " " + this.getLogName());
        }
    }

    private String typeText() {
        if (this instanceof PlatformEventType) {
            return "event type";
        }
        if (SUPER_TYPE_SETTING.equals(this.superType)) {
            return "setting type";
        }
        if (SUPER_TYPE_ANNOTATION.equals(this.superType)) {
            return "annotation type";
        }
        return "type";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLogName());
        if (!this.getFields().isEmpty()) {
            sb.append(" {\n");
            for (ValueDescriptor td : this.getFields()) {
                sb.append("  type=" + td.getTypeName() + "(" + td.getTypeId() + ") name=" + td.getName() + "\n");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean getRemove() {
        return this.remove;
    }
}

