/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.consumer;

import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;

public final class RecordingInput
implements DataInput,
AutoCloseable {
    public static final byte STRING_ENCODING_NULL = 0;
    public static final byte STRING_ENCODING_EMPTY_STRING = 1;
    public static final byte STRING_ENCODING_CONSTANT_POOL = 2;
    public static final byte STRING_ENCODING_UTF8_BYTE_ARRAY = 3;
    public static final byte STRING_ENCODING_CHAR_ARRAY = 4;
    public static final byte STRING_ENCODING_LATIN1_BYTE_ARRAY = 5;
    private static final int DEFAULT_BLOCK_SIZE = 0x1000000;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Charset LATIN1 = Charset.forName("ISO-8859-1");
    private final RandomAccessFile file;
    private final long size;
    private Block currentBlock = new Block();
    private Block previousBlock = new Block();
    private long position;
    private final int blockSize;

    private RecordingInput(File f, int blockSize) throws IOException {
        this.size = f.length();
        this.blockSize = blockSize;
        this.file = new RandomAccessFile(f, "r");
        if (this.size < 8L) {
            throw new IOException("Not a valid Flight Recorder file. File length is only " + this.size + " bytes.");
        }
    }

    public RecordingInput(File f) throws IOException {
        this(f, 0x1000000);
    }

    @Override
    public final byte readByte() throws IOException {
        if (!this.currentBlock.contains(this.position)) {
            this.position(this.position);
        }
        return this.currentBlock.get(this.position++);
    }

    @Override
    public final void readFully(byte[] dest, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            dest[i + offset] = this.readByte();
        }
    }

    @Override
    public final void readFully(byte[] dst) throws IOException {
        this.readFully(dst, 0, dst.length);
    }

    public final short readRawShort() throws IOException {
        byte b0 = this.readByte();
        byte b1 = this.readByte();
        return (short)((b1 & 0xFF) + (b0 << 8));
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readRawInt());
    }

    public final int readRawInt() throws IOException {
        byte b0 = this.readByte();
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        return (b3 & 0xFF) + ((b2 & 0xFF) << 8) + ((b1 & 0xFF) << 16) + (b0 << 24);
    }

    public final long readRawLong() throws IOException {
        byte b0 = this.readByte();
        byte b1 = this.readByte();
        byte b2 = this.readByte();
        byte b3 = this.readByte();
        byte b4 = this.readByte();
        byte b5 = this.readByte();
        byte b6 = this.readByte();
        byte b7 = this.readByte();
        return ((long)b7 & 0xFFL) + (((long)b6 & 0xFFL) << 8) + (((long)b5 & 0xFFL) << 16) + (((long)b4 & 0xFFL) << 24) + (((long)b3 & 0xFFL) << 32) + (((long)b2 & 0xFFL) << 40) + (((long)b1 & 0xFFL) << 48) + ((long)b0 << 56);
    }

    public final long position() throws IOException {
        return this.position;
    }

    public final void position(long newPosition) throws IOException {
        if (!this.currentBlock.contains(newPosition)) {
            if (!this.previousBlock.contains(newPosition)) {
                if (newPosition > this.size()) {
                    throw new EOFException("Trying to read at " + newPosition + ", but file is only " + this.size() + " bytes.");
                }
                long blockStart = this.trimToFileSize(this.calculateBlockStart(newPosition));
                this.file.seek(blockStart);
                long amount = Math.min(this.size() - blockStart, (long)this.blockSize);
                this.previousBlock.read(this.file, (int)amount);
            }
            Block tmp = this.currentBlock;
            this.currentBlock = this.previousBlock;
            this.previousBlock = tmp;
        }
        this.position = newPosition;
    }

    private final long trimToFileSize(long position) throws IOException {
        return Math.min(this.size(), Math.max(0L, position));
    }

    private final long calculateBlockStart(long newPosition) {
        if (this.currentBlock.contains(newPosition - (long)this.blockSize)) {
            return this.currentBlock.blockPosition + (long)this.currentBlock.bytes.length;
        }
        if (this.currentBlock.contains(newPosition + (long)this.blockSize)) {
            return this.currentBlock.blockPosition - (long)this.blockSize;
        }
        return newPosition - (long)(this.blockSize / 2);
    }

    public final long size() throws IOException {
        return this.size;
    }

    @Override
    public final void close() throws IOException {
        this.file.close();
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        long position = this.position();
        this.position(position + (long)n);
        return (int)(this.position() - position);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public final String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return this.readEncodedString(this.readByte());
    }

    public String readEncodedString(byte encoding) throws IOException {
        if (encoding == 0) {
            return null;
        }
        if (encoding == 1) {
            return "";
        }
        int size = this.readInt();
        this.require(size, "String size %d exceeds available data");
        if (encoding == 4) {
            char[] c = new char[size];
            for (int i = 0; i < size; ++i) {
                c[i] = this.readChar();
            }
            return new String(c);
        }
        byte[] bytes = new byte[size];
        this.readFully(bytes);
        if (encoding == 3) {
            return new String(bytes, UTF8);
        }
        if (encoding == 5) {
            return new String(bytes, LATIN1);
        }
        throw new IOException("Unknown string encoding " + encoding);
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readLong();
    }

    @Override
    public int readInt() throws IOException {
        return (int)this.readLong();
    }

    @Override
    public long readLong() throws IOException {
        byte b0 = this.readByte();
        long ret = (long)b0 & 0x7FL;
        if (b0 >= 0) {
            return ret;
        }
        byte b1 = this.readByte();
        ret += ((long)b1 & 0x7FL) << 7;
        if (b1 >= 0) {
            return ret;
        }
        byte b2 = this.readByte();
        ret += ((long)b2 & 0x7FL) << 14;
        if (b2 >= 0) {
            return ret;
        }
        byte b3 = this.readByte();
        ret += ((long)b3 & 0x7FL) << 21;
        if (b3 >= 0) {
            return ret;
        }
        byte b4 = this.readByte();
        ret += ((long)b4 & 0x7FL) << 28;
        if (b4 >= 0) {
            return ret;
        }
        byte b5 = this.readByte();
        ret += ((long)b5 & 0x7FL) << 35;
        if (b5 >= 0) {
            return ret;
        }
        byte b6 = this.readByte();
        ret += ((long)b6 & 0x7FL) << 42;
        if (b6 >= 0) {
            return ret;
        }
        byte b7 = this.readByte();
        ret += ((long)b7 & 0x7FL) << 49;
        if (b7 >= 0) {
            return ret;
        }
        byte b8 = this.readByte();
        return ret + ((long)(b8 & 0xFF) << 56);
    }

    public void require(int minimumBytes, String errorMessage) throws IOException {
        if (this.position + (long)minimumBytes > this.size) {
            throw new IOException(String.format(errorMessage, minimumBytes));
        }
    }

    private static final class Block {
        private byte[] bytes = new byte[0];
        private long blockPosition;

        private Block() {
        }

        boolean contains(long position) {
            return position >= this.blockPosition && position < this.blockPosition + (long)this.bytes.length;
        }

        public void read(RandomAccessFile file, int amount) throws IOException {
            this.blockPosition = file.getFilePointer();
            if (amount != this.bytes.length) {
                this.bytes = new byte[amount];
            }
            file.readFully(this.bytes);
        }

        public byte get(long position) {
            return this.bytes[(int)(position - this.blockPosition)];
        }
    }
}

