/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import jdk.jfr.internal.instrument.ConstructorWriter;

final class ConstructorTracerWriter
extends ClassVisitor {
    private ConstructorWriter useInputParameter;
    private ConstructorWriter noUseInputParameter;

    static byte[] generateBytes(Class<?> clz, byte[] oldBytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(oldBytes);
        ClassReader cr = new ClassReader(in);
        ClassWriter cw = new ClassWriter(1);
        ConstructorTracerWriter ctw = new ConstructorTracerWriter(cw, clz);
        cr.accept(ctw, 0);
        return cw.toByteArray();
    }

    private ConstructorTracerWriter(ClassVisitor cv, Class<?> classToChange) {
        super(327680, cv);
        this.useInputParameter = new ConstructorWriter(classToChange, true);
        this.noUseInputParameter = new ConstructorWriter(classToChange, false);
    }

    private boolean isConstructor(String name) {
        return name.equals("<init>");
    }

    private boolean takesStringParameter(String desc) {
        Type[] types = Type.getArgumentTypes(desc);
        return types.length > 0 && types[0].getClassName().equals(String.class.getName());
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.isConstructor(name)) {
            if (this.takesStringParameter(desc)) {
                this.useInputParameter.setMethodVisitor(mv);
                return this.useInputParameter;
            }
            this.noUseInputParameter.setMethodVisitor(mv);
            return this.noUseInputParameter;
        }
        return mv;
    }
}

