/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import jdk.jfr.EventType;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.consumer.ChunkHeader;
import jdk.jfr.internal.consumer.RecordingInput;
import jdk.jfr.internal.tool.Command;
import jdk.jfr.internal.tool.UserDataException;
import jdk.jfr.internal.tool.UserSyntaxException;

final class Summary
extends Command {
    private final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withLocale(Locale.UK).withZone(ZoneOffset.UTC);

    Summary() {
    }

    @Override
    public String getName() {
        return "summary";
    }

    @Override
    public List<String> getOptionSyntax() {
        return Collections.singletonList("<file>");
    }

    @Override
    public void displayOptionUsage(PrintStream stream) {
        stream.println("  <file>   Location of the recording file (.jfr) to display information about");
    }

    @Override
    public String getDescription() {
        return "Display general information about a recording file (.jfr)";
    }

    @Override
    public void execute(Deque<String> options) throws UserSyntaxException, UserDataException {
        this.ensureMaxArgumentCount(options, 1);
        Path p = this.getJFRInputFile(options);
        try {
            this.printInformation(p);
        }
        catch (IOException e) {
            this.couldNotReadError(p, e);
        }
    }

    private void printInformation(Path p) throws IOException {
        long totalDuration = 0L;
        long chunks = 0L;
        try (RecordingInput input = new RecordingInput(p.toFile());){
            ChunkHeader first;
            ChunkHeader ch = first = new ChunkHeader(input);
            String eventPrefix = "jdk.";
            if (first.getMajor() == 1) {
                eventPrefix = "com.oracle.jdk.";
            }
            HashMap<Long, Statistics> stats = new HashMap<Long, Statistics>();
            stats.put(0L, new Statistics(eventPrefix + "Metadata"));
            stats.put(1L, new Statistics(eventPrefix + "CheckPoint"));
            int minWidth = 0;
            while (true) {
                long chunkEnd = ch.getEnd();
                MetadataDescriptor md = ch.readMetadata();
                for (EventType eventType : md.getEventTypes()) {
                    stats.computeIfAbsent(eventType.getId(), e -> new Statistics(eventType.getName()));
                    minWidth = Math.max(minWidth, eventType.getName().length());
                }
                totalDuration += ch.getDurationNanos();
                ++chunks;
                input.position(ch.getEventStart());
                while (input.position() < chunkEnd) {
                    long pos = input.position();
                    int size = input.readInt();
                    long eventTypeId = input.readLong();
                    Statistics s = (Statistics)stats.get(eventTypeId);
                    if (s != null) {
                        ++s.count;
                        s.size += (long)size;
                    }
                    input.position(pos + (long)size);
                }
                if (ch.isLastChunk()) break;
                ch = ch.nextHeader();
            }
            this.println();
            long epochSeconds = first.getStartNanos() / 1000000000L;
            long adjustNanos = first.getStartNanos() - epochSeconds * 1000000000L;
            this.println(" Version: " + first.getMajor() + "." + first.getMinor());
            this.println(" Chunks: " + chunks);
            this.println(" Start: " + this.DATE_FORMAT.format(Instant.ofEpochSecond(epochSeconds, adjustNanos)) + " (UTC)");
            this.println(" Duration: " + (totalDuration + 500000000L) / 1000000000L + " s");
            ArrayList statsList = new ArrayList(stats.values());
            Collections.sort(statsList, (u, v) -> Long.compare(v.count, u.count));
            this.println();
            String header = "      Count  Size (bytes) ";
            String typeHeader = " Event Type";
            minWidth = Math.max(minWidth, typeHeader.length());
            this.println(typeHeader + this.pad(minWidth - typeHeader.length(), ' ') + header);
            this.println(this.pad(minWidth + header.length(), '='));
            for (Statistics s : statsList) {
                System.out.printf(" %-" + minWidth + "s%10d  %12d\n", s.name, s.count, s.size);
            }
        }
    }

    private String pad(int count, char c) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private static class Statistics {
        String name;
        long count;
        long size;

        Statistics(String name) {
            this.name = name;
        }
    }
}

