/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.util.concurrent.Callable;
import javax.management.openmbean.CompositeData;
import jdk.jfr.SettingDescriptor;
import jdk.management.jfr.FlightRecorderMXBean;
import jdk.management.jfr.FlightRecorderMXBeanImpl;
import jdk.management.jfr.Stringifier;
import jdk.management.jfr.internal.FlightRecorderMXBeanProvider;

public final class SettingDescriptorInfo {
    private final String name;
    private final String label;
    private final String description;
    private final String typeName;
    private final String contentType;
    private final String defaultValue;

    SettingDescriptorInfo(SettingDescriptor settingDescriptor) {
        this.name = settingDescriptor.getName();
        this.label = settingDescriptor.getLabel();
        this.description = settingDescriptor.getDescription();
        this.typeName = settingDescriptor.getTypeName();
        this.contentType = settingDescriptor.getContentType();
        this.defaultValue = settingDescriptor.getDefaultValue();
    }

    private SettingDescriptorInfo(CompositeData cd) {
        this.name = (String)cd.get("name");
        this.label = (String)cd.get("label");
        this.description = (String)cd.get("description");
        this.typeName = (String)cd.get("typeName");
        this.defaultValue = (String)cd.get("defaultValue");
        this.contentType = (String)cd.get("contentType");
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public static SettingDescriptorInfo from(CompositeData cd) {
        if (cd == null) {
            return null;
        }
        return new SettingDescriptorInfo(cd);
    }

    public String toString() {
        Stringifier s = new Stringifier();
        s.add("name", this.name);
        s.add("label", this.label);
        s.add("description", this.description);
        s.add("typeName", this.typeName);
        s.add("contentType", this.contentType);
        s.add("defaultValue", this.defaultValue);
        return s.toString();
    }

    static {
        FlightRecorderMXBeanProvider.setFlightRecorderMXBeanFactory(new Callable<FlightRecorderMXBean>(){

            @Override
            public FlightRecorderMXBean call() throws Exception {
                return new FlightRecorderMXBeanImpl();
            }
        });
    }
}

