/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.util.TimerTask;
import jdk.management.jfr.Stream;
import jdk.management.jfr.StreamManager;

final class StreamCleanupTask
extends TimerTask {
    private final Stream stream;
    private final StreamManager manager;

    StreamCleanupTask(StreamManager streamManager, Stream stream) {
        this.stream = stream;
        this.manager = streamManager;
    }

    @Override
    public void run() {
        long lastTouched = this.stream.getLastTouched();
        long now = System.currentTimeMillis();
        if (now - lastTouched >= StreamManager.TIME_OUT) {
            this.manager.destroy(this.stream);
        } else {
            this.manager.scheduleAbort(this.stream, lastTouched + StreamManager.TIME_OUT);
        }
    }
}

