/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.io.IOException;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.Parser;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.TimeConverter;
import jdk.jfr.internal.consumer.RecordingInput;

final class EventParser
extends Parser {
    private final Parser[] parsers;
    private final EventType eventType;
    private final TimeConverter timeConverter;
    private final boolean hasDuration;
    private final List<ValueDescriptor> valueDescriptors;

    EventParser(TimeConverter timeConverter, EventType type, Parser[] parsers) {
        this.timeConverter = timeConverter;
        this.parsers = parsers;
        this.eventType = type;
        this.hasDuration = type.getField("duration") != null;
        this.valueDescriptors = type.getFields();
    }

    @Override
    public Object parse(RecordingInput input) throws IOException {
        Object[] values = new Object[this.parsers.length];
        for (int i = 0; i < this.parsers.length; ++i) {
            values[i] = this.parsers[i].parse(input);
        }
        Long startTicks = (Long)values[0];
        long startTime = this.timeConverter.convertTimestamp(startTicks);
        if (this.hasDuration) {
            long durationTicks = (Long)values[1];
            long endTime = this.timeConverter.convertTimestamp(startTicks + durationTicks);
            return new RecordedEvent(this.eventType, this.valueDescriptors, values, startTime, endTime, this.timeConverter);
        }
        return new RecordedEvent(this.eventType, this.valueDescriptors, values, startTime, startTime, this.timeConverter);
    }
}

