/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.jfr.RecordingState;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.settings.CutoffSetting;
import jdk.jfr.internal.test.WhiteBox;

public final class OldObjectSample {
    private static final String EVENT_NAME = "jdk.OldObjectSample";
    private static final String OLD_OBJECT_CUTOFF = "jdk.OldObjectSample#cutoff";
    private static final String OLD_OBJECT_ENABLED = "jdk.OldObjectSample#enabled";

    public static void emit(PlatformRecording recording) {
        if (OldObjectSample.isEnabled(recording)) {
            long nanos = CutoffSetting.parseValueSafe(recording.getSettings().get(OLD_OBJECT_CUTOFF));
            long ticks = Utils.nanosToTicks(nanos);
            JVM.getJVM().emitOldObjectSamples(ticks, WhiteBox.getWriteAllObjectSamples());
        }
    }

    public static void emit(List<PlatformRecording> recordings, Boolean pathToGcRoots) {
        boolean enabled = false;
        long cutoffNanos = Boolean.TRUE.equals(pathToGcRoots) ? Long.MAX_VALUE : 0L;
        for (PlatformRecording r : recordings) {
            if (r.getState() != RecordingState.RUNNING || !OldObjectSample.isEnabled(r)) continue;
            enabled = true;
            long c = CutoffSetting.parseValueSafe(r.getSettings().get(OLD_OBJECT_CUTOFF));
            cutoffNanos = Math.max(c, cutoffNanos);
        }
        if (enabled) {
            long ticks = Utils.nanosToTicks(cutoffNanos);
            JVM.getJVM().emitOldObjectSamples(ticks, WhiteBox.getWriteAllObjectSamples());
        }
    }

    public static void updateSettingPathToGcRoots(Map<String, String> s, Boolean pathToGcRoots) {
        if (pathToGcRoots != null) {
            s.put(OLD_OBJECT_CUTOFF, pathToGcRoots != false ? "infinity" : "0 ns");
        }
    }

    public static Map<String, String> createSettingsForSnapshot(PlatformRecording recording, Boolean pathToGcRoots) {
        HashMap<String, String> settings = new HashMap<String, String>(recording.getSettings());
        OldObjectSample.updateSettingPathToGcRoots(settings, pathToGcRoots);
        return settings;
    }

    private static boolean isEnabled(PlatformRecording r) {
        Map<String, String> settings = r.getSettings();
        String s = settings.get(OLD_OBJECT_ENABLED);
        return "true".equals(s);
    }
}

